/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.modifier;

import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ParallelLogic {
    public static int getParallelAmount(MetaMachine machine, GTRecipe recipe, int parallelLimit) {
        if (parallelLimit <= 1) {
            return parallelLimit;
        }
        if (!(machine instanceof IRecipeLogicMachine)) {
            return 1;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        int maxInputMultiplier = ParallelLogic.getMaxByInput(rlm, recipe, parallelLimit, Collections.emptyList());
        if (maxInputMultiplier == 0) {
            return 0;
        }
        return ParallelLogic.limitByOutputMerging(rlm, recipe, maxInputMultiplier, rlm::canVoidRecipeOutputs, Collections.emptyList());
    }

    public static int getMaxByInput(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelLimit, List<RecipeCapability<?>> capsToSkip) {
        int minimum = Integer.MAX_VALUE;
        for (RecipeCapability<?> cap : recipe.inputs.keySet()) {
            if (!cap.doMatchInRecipe() || capsToSkip.contains(cap)) continue;
            minimum = Math.min(minimum, cap.getMaxParallelByInput(holder, recipe, parallelLimit, false));
        }
        for (RecipeCapability<?> cap : recipe.tickInputs.keySet()) {
            if (!cap.doMatchInRecipe() || capsToSkip.contains(cap)) continue;
            minimum = Math.min(minimum, cap.getMaxParallelByInput(holder, recipe, parallelLimit, true));
        }
        if (minimum == Integer.MAX_VALUE) {
            return 0;
        }
        return minimum;
    }

    public static int limitByOutputMerging(IRecipeCapabilityHolder holder, GTRecipe recipe, int parallelLimit, Predicate<RecipeCapability<?>> canVoid, List<RecipeCapability<?>> capsToSkip) {
        int limit;
        int max = parallelLimit;
        for (RecipeCapability<?> cap : recipe.outputs.keySet()) {
            if (canVoid.test(cap) || !cap.doMatchInRecipe() || capsToSkip.contains(cap) || recipe.getOutputContents(cap).isEmpty()) continue;
            limit = cap.limitMaxParallelByOutput(holder, recipe, parallelLimit, false);
            if (limit == 0) {
                return 0;
            }
            max = Math.min(max, limit);
        }
        for (RecipeCapability<?> cap : recipe.tickOutputs.keySet()) {
            if (canVoid.test(cap) || !cap.doMatchInRecipe() || capsToSkip.contains(cap) || recipe.getTickOutputContents(cap).isEmpty()) continue;
            limit = cap.limitMaxParallelByOutput(holder, recipe, parallelLimit, true);
            if (limit == 0) {
                return 0;
            }
            max = Math.min(max, limit);
        }
        return max;
    }

    public static int getParallelAmountWithoutEU(MetaMachine machine, GTRecipe recipe, int parallelLimit) {
        if (parallelLimit <= 1) {
            return parallelLimit;
        }
        if (!(machine instanceof IRecipeLogicMachine)) {
            return 1;
        }
        IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)machine);
        int maxInputMultiplier = ParallelLogic.getMaxByInput(rlm, recipe, parallelLimit, List.of(EURecipeCapability.CAP));
        if (maxInputMultiplier == 0) {
            return 0;
        }
        return ParallelLogic.limitByOutputMerging(rlm, recipe, maxInputMultiplier, rlm::canVoidRecipeOutputs, List.of(EURecipeCapability.CAP));
    }

    public static int[] adjustMultiplier(boolean mergedAll, int minMultiplier, int multiplier, int maxMultiplier) {
        if (mergedAll) {
            minMultiplier = multiplier;
            int remainder = (maxMultiplier - multiplier) % 2;
            multiplier = multiplier + remainder + (maxMultiplier - multiplier) / 2;
        } else {
            maxMultiplier = multiplier;
            multiplier = (multiplier + minMultiplier) / 2;
        }
        if (maxMultiplier - minMultiplier <= 1) {
            multiplier = maxMultiplier = minMultiplier;
        }
        return new int[]{minMultiplier, multiplier, maxMultiplier};
    }

    public static int getParallelAmountFast(MetaMachine machine, @NotNull GTRecipe recipe, int parallelLimit) {
        IRecipeCapabilityHolder holder;
        if (parallelLimit <= 1) {
            return parallelLimit;
        }
        if (machine instanceof IRecipeCapabilityHolder) {
            holder = (IRecipeCapabilityHolder)((Object)machine);
        } else {
            return 1;
        }
        while (parallelLimit > 0) {
            GTRecipe copied = recipe.copy(ContentModifier.multiplier(parallelLimit), false);
            if (RecipeHelper.matchRecipe(holder, copied).isSuccess() && RecipeHelper.matchTickRecipe(holder, copied).isSuccess()) {
                return parallelLimit;
            }
            parallelLimit /= 2;
        }
        return 1;
    }
}

