/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.multipart;

import com.google.common.collect.Streams;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.model.machine.multipart.AndPartCondition;
import com.gregtechceu.gtceu.client.model.machine.multipart.KeyValuePartCondition;
import com.gregtechceu.gtceu.client.model.machine.multipart.OrPartCondition;
import com.gregtechceu.gtceu.client.model.machine.multipart.PartCondition;
import com.gregtechceu.gtceu.client.model.machine.variant.MultiVariantModel;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.state.StateDefinition;

public class MultiPartSelector
implements ModelState {
    private final PartCondition condition;
    private final MultiVariantModel variant;

    public MultiPartSelector(PartCondition condition, MultiVariantModel variant) {
        this.condition = condition;
        this.variant = variant;
    }

    public Predicate<MachineRenderState> getPredicate(StateDefinition<MachineDefinition, MachineRenderState> definition) {
        return this.condition.getPredicate(definition);
    }

    @Generated
    public MultiVariantModel getVariant() {
        return this.variant;
    }

    public static class Deserializer
    implements JsonDeserializer<MultiPartSelector> {
        public MultiPartSelector deserialize(JsonElement json, Type type, JsonDeserializationContext context) throws JsonParseException {
            return Deserializer.fromJson(json, context);
        }

        public static MultiPartSelector fromJson(JsonElement json, JsonDeserializationContext context) throws JsonParseException {
            JsonObject jsonobject = json.getAsJsonObject();
            return new MultiPartSelector(Deserializer.getSelector(jsonobject), (MultiVariantModel)context.deserialize(jsonobject.get("apply"), MultiVariantModel.class));
        }

        private static PartCondition getSelector(JsonObject json) {
            return json.has("when") ? Deserializer.getCondition(GsonHelper.m_13930_((JsonObject)json, (String)"when")) : PartCondition.TRUE;
        }

        private static PartCondition getCondition(JsonObject json) {
            Set entries = json.entrySet();
            if (entries.isEmpty()) {
                throw new JsonParseException("No elements found in selector");
            }
            if (entries.size() == 1) {
                if (json.has("OR")) {
                    List<PartCondition> conditions = Streams.stream((Iterable)GsonHelper.m_13933_((JsonObject)json, (String)"OR")).map(e -> Deserializer.getCondition(e.getAsJsonObject())).toList();
                    return new OrPartCondition(conditions);
                }
                if (json.has("AND")) {
                    List<PartCondition> conditions = Streams.stream((Iterable)GsonHelper.m_13933_((JsonObject)json, (String)"AND")).map(e -> Deserializer.getCondition(e.getAsJsonObject())).toList();
                    return new AndPartCondition(conditions);
                }
                return Deserializer.getKeyValueCondition((Map.Entry)entries.iterator().next());
            }
            return new AndPartCondition(entries.stream().map(Deserializer::getKeyValueCondition).collect(Collectors.toList()));
        }

        private static PartCondition getKeyValueCondition(Map.Entry<String, JsonElement> entry) {
            return new KeyValuePartCondition(entry.getKey(), entry.getValue().getAsString());
        }
    }
}

