/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MaterialBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;

@MethodsReturnNonnullByDefault
public class OreBlockRenderer {
    private static final Set<OreBlockRenderer> MODELS = new HashSet<OreBlockRenderer>();
    private final MaterialBlock block;

    public static void create(MaterialBlock block) {
        MODELS.add(new OreBlockRenderer(block));
    }

    public OreBlockRenderer(MaterialBlock block) {
        this.block = block;
    }

    public static void reinitModels() {
        for (OreBlockRenderer model : MODELS) {
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)model.block);
            ResourceLocation modelId = blockId.m_246208_("block/");
            OreBlockRenderer.cloneBlockModel(blockId, model.block.tagPrefix, model.block.material);
            GTDynamicResourcePack.addBlockState(blockId, (Supplier<JsonElement>)BlockModelGenerators.m_124859_((Block)model.block, (ResourceLocation)modelId));
            GTDynamicResourcePack.addItemModel(BuiltInRegistries.f_257033_.m_7981_((Object)model.block.m_5456_()), (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.m_125576_((Block)model.block)));
        }
    }

    public static void cloneBlockModel(ResourceLocation modelId, TagPrefix prefix, Material material) {
        JsonObject original;
        OreProperty prop = material.getProperty(PropertyKey.ORE);
        Preconditions.checkNotNull((Object)prop, (Object)"material %s has no ore property, but needs one for an ore model!".formatted(material.getName()));
        try (BufferedReader reader = Minecraft.m_91087_().m_91098_().m_215597_(GTCEu.id("models/block/ore%s.json".formatted(prop.isEmissive() ? "_emissive" : "")));){
            original = GsonHelper.m_13861_((Reader)reader, (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JsonObject newJson = original.deepCopy();
        JsonObject children = newJson.getAsJsonObject("children");
        children.getAsJsonObject("base_stone").addProperty("parent", TagPrefix.ORES.get(prefix).baseModelLocation().toString());
        ResourceLocation layer0 = prefix.materialIconType().getBlockTexturePath(material.getMaterialIconSet(), true);
        ResourceLocation layer1 = prefix.materialIconType().getBlockTexturePath(material.getMaterialIconSet(), "layer2", true);
        JsonObject oresTextures = children.getAsJsonObject("ore_texture").getAsJsonObject("textures");
        oresTextures.addProperty("layer0", layer0.toString());
        oresTextures.addProperty("layer1", layer1.toString());
        newJson.getAsJsonObject("textures").addProperty("particle", layer0.toString());
        GTDynamicResourcePack.addBlockModel(modelId, (JsonElement)newJson);
    }
}

