/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.block;

import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SurfaceRockRenderer {
    private static final Set<SurfaceRockRenderer> MODELS = new HashSet<SurfaceRockRenderer>();
    private final Block block;

    public static void create(Block block) {
        MODELS.add(new SurfaceRockRenderer(block));
    }

    public static void reinitModels() {
        for (SurfaceRockRenderer model : MODELS) {
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)model.block);
            ResourceLocation modelId = blockId.m_246208_("block/");
            GTDynamicResourcePack.addBlockModel(blockId, (Supplier<JsonElement>)new DelegatedModel(GTCEu.id("block/surface_rock")));
            GTDynamicResourcePack.addBlockState(blockId, (Supplier<JsonElement>)MultiVariantGenerator.m_125256_((Block)model.block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)modelId)).m_125271_((PropertyDispatch)PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61372_).m_125329_((Comparable)Direction.DOWN, Variant.m_125501_()).m_125329_((Comparable)Direction.UP, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R180)).m_125329_((Comparable)Direction.NORTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90)).m_125329_((Comparable)Direction.SOUTH, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R270)).m_125329_((Comparable)Direction.WEST, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R270)).m_125329_((Comparable)Direction.EAST, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90))));
            GTDynamicResourcePack.addItemModel(blockId, (Supplier<JsonElement>)new DelegatedModel(modelId));
        }
    }

    protected SurfaceRockRenderer(Block block) {
        this.block = block;
    }
}

