/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine.impl;

import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRender;
import com.gregtechceu.gtceu.client.renderer.machine.DynamicRenderType;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.machine.storage.CreativeChestMachine;
import com.gregtechceu.gtceu.common.machine.storage.QuantumChestMachine;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTMatrixUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class QuantumChestItemRender
extends DynamicRender<QuantumChestMachine, QuantumChestItemRender> {
    public static final Codec<QuantumChestItemRender> CODEC = Codec.unit(QuantumChestItemRender::new);
    public static final DynamicRenderType<QuantumChestMachine, QuantumChestItemRender> TYPE = new DynamicRenderType(CODEC);
    @Nullable
    private static Item CREATIVE_CHEST_ITEM = null;

    @Override
    public DynamicRenderType<QuantumChestMachine, QuantumChestItemRender> getType() {
        return TYPE;
    }

    @Override
    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (CREATIVE_CHEST_ITEM == null) {
            CREATIVE_CHEST_ITEM = GTMachines.CREATIVE_ITEM.getItem();
        }
        if (stack.m_41782_()) {
            poseStack.m_85836_();
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
            ItemStack itemStack = ItemStack.m_41712_((CompoundTag)stack.m_41698_("stored"));
            long storedAmount = stack.m_41784_().m_128454_("storedAmount");
            float totalTick = (float)Minecraft.m_91087_().f_91073_.m_46467_() + Minecraft.m_91087_().m_91296_();
            this.renderChestItem(poseStack, buffer, totalTick, Direction.NORTH, itemStack, storedAmount, ItemStack.f_41583_, stack.m_150930_(CREATIVE_CHEST_ITEM));
            poseStack.m_85849_();
        }
        super.renderByItem(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
    }

    @Override
    public void render(QuantumChestMachine machine, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        QuantumChestItemRender.setupModelRotation(machine, poseStack);
        float totalTick = (float)machine.getLevel().m_46467_() + partialTick;
        this.renderChestItem(poseStack, buffer, totalTick, machine.getFrontFacing(), machine.getStored(), machine.getStoredAmount(), machine.getLockedItem(), machine instanceof CreativeChestMachine);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderChestItem(PoseStack poseStack, MultiBufferSource buffer, float totalTick, Direction frontFacing, ItemStack stored, long storedAmount, ItemStack locked, boolean isCreative) {
        ItemStack itemStack;
        ItemStack itemStack2 = itemStack = !stored.m_41619_() ? stored : locked;
        if (itemStack.m_41619_()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        if (frontFacing.m_122434_() == Direction.Axis.Y) {
            Quaternionf rotation = GTMatrixUtils.getRotation(Direction.NORTH, frontFacing);
            poseStack.m_252781_(rotation);
        }
        poseStack.m_252781_(new Quaternionf().rotateY(totalTick * ((float)Math.PI * 2) / 80.0f));
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        itemRenderer.m_269128_(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, poseStack, buffer, (Level)Minecraft.m_91087_().f_91073_, Item.m_41393_((Item)itemStack.m_41720_()) + itemStack.m_41773_());
        poseStack.m_85849_();
        QuantumChestItemRender.drawAmountText(poseStack, buffer, frontFacing, storedAmount, isCreative);
    }

    public static void setupModelRotation(MetaMachine machine, PoseStack poseStack) {
        Direction frontFacing = machine.getFrontFacing();
        Direction upwardFacing = machine.getUpwardsFacing();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        GTMatrixUtils.rotateMatrix(poseStack.m_85850_().m_252922_(), GTMatrixUtils.upwardFacingAngle(upwardFacing) + (upwardFacing.m_122434_() == Direction.Axis.X ? (float)Math.PI : 0.0f), GTMatrixUtils.getDirectionAxis(frontFacing), new Vector3f[0]);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
    }

    public static void drawAmountText(PoseStack poseStack, MultiBufferSource buffer, Direction frontFacing, long storedAmount, boolean isCreative) {
        String text;
        poseStack.m_85836_();
        RenderSystem.disableDepthTest();
        poseStack.m_252880_((float)(frontFacing.m_122429_() * -1) / 16.0f, (float)(frontFacing.m_122430_() * -1) / 16.0f, (float)(frontFacing.m_122431_() * -1) / 16.0f);
        RenderUtil.moveToFace(poseStack, 0.5f, 0.5f, 0.5f, frontFacing);
        RenderUtil.rotateToFace(poseStack, frontFacing, Direction.NORTH);
        poseStack.m_85841_(0.015625f, 0.015625f, 0.0f);
        poseStack.m_252880_(-32.0f, -32.0f, 0.0f);
        boolean x = false;
        int y = 24;
        int w = 64;
        int h = 28;
        float textX = (float)x + (float)w / 2.0f;
        float textY = (float)y + (float)h / 2.0f;
        poseStack.m_85836_();
        if (isCreative) {
            text = "\u221e";
            poseStack.m_252880_(textX, textY, 0.0f);
            poseStack.m_85841_(3.0f, 3.0f, 1.0f);
            poseStack.m_252880_(-textX, -textY, 0.0f);
        } else {
            text = storedAmount <= 0L ? "*" : FormattingUtil.formatNumberReadable(storedAmount, false);
        }
        Font font = Minecraft.m_91087_().f_91062_;
        float f = textX - font.m_92865_().m_92353_(text) / 2.0f;
        Objects.requireNonNull(font);
        font.m_271703_(text, f, textY - 9.0f / 2.0f, -1, false, poseStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        poseStack.m_85849_();
    }
}

