/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.client.model.machine.MachineModel;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverableRenderer;
import com.gregtechceu.gtceu.client.util.AssetEventListener;
import com.gregtechceu.gtceu.integration.modernfix.GTModernFixIntegration;
import com.lowdragmc.lowdraglib.client.model.custommodel.CustomBakedModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="gtceu", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ModelUtils {
    private static final List<EventListenerHolder> EVENT_LISTENERS = new ArrayList<EventListenerHolder>();

    private ModelUtils() {
    }

    public static List<BakedQuad> getBakedModelQuads(BakedModel model, BlockAndTintGetter level, BlockPos pos, BlockState state, Direction side, RandomSource rand) {
        return model.getQuads(state, side, rand, model.getModelData(level, pos, state, ModelData.EMPTY), null);
    }

    public static BakedModel getModelForState(BlockState state) {
        return Minecraft.m_91087_().m_91289_().m_110910_(state);
    }

    public static String getPropertyValueString(Map.Entry<Property<?>, Comparable<?>> entry) {
        Property<?> property = entry.getKey();
        Comparable<?> value = entry.getValue();
        Object valueString = Util.m_137453_(property, value);
        if (Boolean.TRUE.equals(value)) {
            valueString = String.valueOf(ChatFormatting.GREEN) + (String)valueString;
        } else if (Boolean.FALSE.equals(value)) {
            valueString = String.valueOf(ChatFormatting.RED) + (String)valueString;
        }
        return property.m_61708_() + ": " + (String)valueString;
    }

    public static void registerAtlasStitchedEventListener(boolean removeOnReload, AssetEventListener.AtlasStitched listener) {
        EVENT_LISTENERS.add(new EventListenerHolder(listener, removeOnReload));
    }

    public static void registerAtlasStitchedEventListener(boolean removeOnReload, ResourceLocation atlasLocation, AssetEventListener.AtlasStitched listener) {
        ModelUtils.registerAtlasStitchedEventListener(removeOnReload, event -> {
            if (event.getAtlas().m_118330_().equals((Object)atlasLocation)) {
                listener.accept(event);
            }
        });
    }

    public static void registerBakeEventListener(boolean removeOnReload, AssetEventListener.ModifyBakingResult listener) {
        EVENT_LISTENERS.add(new EventListenerHolder(listener, removeOnReload));
    }

    public static void registerAddModelsEventListener(boolean removeOnReload, AssetEventListener.RegisterAdditional listener) {
        EVENT_LISTENERS.add(new EventListenerHolder(listener, removeOnReload));
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void registerReloadListener(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new ResourceManagerReloadListener(){

            public void m_6213_(@NotNull ResourceManager resourceManager) {
                EVENT_LISTENERS.removeIf(EventListenerHolder::removeOnReload);
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onAtlasStitched(TextureStitchEvent.Post event) {
        TextureAtlas atlas = event.getAtlas();
        if (atlas.m_118330_() == TextureAtlas.f_118259_) {
            MachineModel.initSprites(atlas);
            ICoverableRenderer.initSprites(atlas);
        }
        for (EventListenerHolder listener : EVENT_LISTENERS) {
            Class<?> eventClass = listener.listener.eventClass();
            if (eventClass == null || !eventClass.isInstance(event)) continue;
            listener.listener.accept(event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onModifyBakingResult(ModelEvent.ModifyBakingResult event) {
        for (EventListenerHolder eventListenerHolder : EVENT_LISTENERS) {
            Class<?> eventClass = eventListenerHolder.listener.eventClass();
            if (eventClass == null || !eventClass.isInstance(event)) continue;
            eventListenerHolder.listener.accept(event);
        }
        if (GTCEu.Mods.isModernFixLoaded() && GTModernFixIntegration.isDynamicResourcesEnabled()) {
            return;
        }
        for (Map.Entry entry : event.getModels().entrySet()) {
            CustomBakedModel ctmModel;
            BakedModel bakedModel;
            BakedModel model = (BakedModel)entry.getValue();
            if (!(model instanceof CustomBakedModel) || !((bakedModel = (ctmModel = (CustomBakedModel)model).getParent()) instanceof MachineModel)) continue;
            MachineModel machine = (MachineModel)bakedModel;
            entry.setValue(machine);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRegisterAdditional(ModelEvent.RegisterAdditional event) {
        for (EventListenerHolder listener : EVENT_LISTENERS) {
            Class<?> eventClass = listener.listener.eventClass();
            if (eventClass == null || !eventClass.isInstance(event)) continue;
            listener.listener.accept(event);
        }
    }

    private record EventListenerHolder(AssetEventListener<?> listener, boolean removeOnReload) {
    }
}

