/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block.explosive;

import com.gregtechceu.gtceu.common.entity.GTExplosiveEntity;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class GTExplosiveBlock
extends Block {
    private final boolean canRedstoneActivate;
    private final boolean explodeOnMine;
    private final int fuseLength;

    public GTExplosiveBlock(BlockBehaviour.Properties properties, boolean canRedstoneActivate, boolean explodeOnMine, int fuseLength) {
        super(properties.m_60922_((state, level, pos, ent) -> false).m_155956_(1.0f));
        this.canRedstoneActivate = canRedstoneActivate;
        this.explodeOnMine = explodeOnMine;
        this.fuseLength = fuseLength;
    }

    protected abstract GTExplosiveEntity createEntity(@NotNull Level var1, @NotNull BlockPos var2, @Nullable LivingEntity var3);

    public boolean m_180643_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public boolean m_6903_(Explosion explosion) {
        return false;
    }

    public void onCaughtFire(BlockState state, Level level, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.explode(level, pos, igniter);
    }

    public void explode(Level level, BlockPos pos, @Nullable LivingEntity exploder) {
        if (!level.f_46443_) {
            GTExplosiveEntity entity = this.createEntity(level, pos, exploder);
            entity.m_32085_(this.fuseLength);
            level.m_7967_((Entity)entity);
            level.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_142346_((Entity)entity, GameEvent.f_157776_, pos);
        }
    }

    public void m_7592_(Level level, BlockPos pos, Explosion explosion) {
        if (!level.f_46443_) {
            GTExplosiveEntity entity = this.createEntity(level, pos, explosion.m_252906_());
            entity.m_32085_(level.f_46441_.m_188503_(this.fuseLength / 4) + this.fuseLength / 8);
            level.m_7967_((Entity)entity);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_204117_(CustomTags.TOOLS_IGNITER)) {
            this.explode(level, pos, (LivingEntity)player);
            level.m_7471_(pos, false);
            if (stack.m_41763_()) {
                stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(hand));
            } else if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (this.explodeOnMine && !player.m_6144_()) {
            this.explode(level, pos, (LivingEntity)player);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity entity) {
        Arrow arrow;
        super.m_7892_(state, level, pos, entity);
        if (!level.f_46443_ && entity instanceof Arrow && (arrow = (Arrow)entity).m_6060_()) {
            LivingEntity living;
            Entity entity2 = arrow.m_19749_();
            this.explode(level, pos, entity2 instanceof LivingEntity ? (living = (LivingEntity)entity2) : null);
            level.m_7471_(pos, false);
        }
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        super.m_6807_(state, level, pos, oldState, movedByPiston);
        if (this.canRedstoneActivate && level.m_276867_(pos)) {
            this.explode(level, pos, null);
            level.m_7471_(pos, false);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder params) {
        Entity player;
        if (this.explodeOnMine && (player = (Entity)params.m_287159_(LootContextParams.f_81455_)) != null && !player.m_6144_()) {
            return Collections.emptyList();
        }
        return super.m_49635_(state, params);
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (this.canRedstoneActivate && level.m_276867_(pos)) {
            this.explode(level, pos, null);
            level.m_7471_(pos, false);
        }
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        if (this.explodeOnMine) {
            tooltip.add((Component)Component.m_237115_((String)"block.gtceu.explosive.breaking_tooltip"));
        }
        if (!this.canRedstoneActivate) {
            tooltip.add((Component)Component.m_237115_((String)"block.gtceu.explosive.lighting_tooltip"));
        }
    }
}

