/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands;

import com.gregtechceu.gtceu.api.data.chemical.material.properties.HazardProperty;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.capability.LocalizedHazardSavedData;
import com.gregtechceu.gtceu.common.commands.arguments.MedicalConditionArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;

public class HazardCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"environmental_hazard").requires(source -> source.m_6761_(3))).then(Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).then(Commands.m_82129_((String)"can_spread", (ArgumentType)BoolArgumentType.bool()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"source", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"chunk").then(Commands.m_82129_((String)"strength", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(HazardCommands::spawnChunkEnvironmentalHazard)))).then(Commands.m_82127_((String)"local").then(Commands.m_82129_((String)"from", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82129_((String)"to", (ArgumentType)BlockPosArgument.m_118239_()).executes(HazardCommands::spawnLocalEnvironmentalHazard)))))))).then(Commands.m_82127_((String)"clear").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"source", (ArgumentType)BlockPosArgument.m_118239_()).executes(context -> {
            BlockPos source = BlockPosArgument.m_264582_((CommandContext)context, (String)"source");
            return HazardCommands.clearEnvironmentalHazard((CommandContext<CommandSourceStack>)context, source, null);
        })).then(Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(context -> {
            BlockPos source = BlockPosArgument.m_264582_((CommandContext)context, (String)"source");
            MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
            return HazardCommands.clearEnvironmentalHazard((CommandContext<CommandSourceStack>)context, source, condition);
        })))));
    }

    private static int spawnChunkEnvironmentalHazard(CommandContext<CommandSourceStack> context) {
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos source = BlockPosArgument.m_264582_(context, (String)"source");
        int strength = IntegerArgumentType.getInteger(context, (String)"strength");
        MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
        boolean canSpread = BoolArgumentType.getBool(context, (String)"can_spread");
        EnvironmentalHazardSavedData.getOrCreate(serverLevel).addZone(source, strength, canSpread, HazardProperty.HazardTrigger.INHALATION, condition);
        return 1;
    }

    private static int spawnLocalEnvironmentalHazard(CommandContext<CommandSourceStack> context) {
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        BlockPos source = BlockPosArgument.m_264582_(context, (String)"source");
        BlockPos from = BlockPosArgument.m_264582_(context, (String)"from");
        BlockPos to = BlockPosArgument.m_264582_(context, (String)"to");
        MedicalCondition condition = MedicalConditionArgument.getCondition(context, "condition");
        boolean canSpread = BoolArgumentType.getBool(context, (String)"can_spread");
        LocalizedHazardSavedData.getOrCreate(serverLevel).addCuboidZone(source, from, to, canSpread, HazardProperty.HazardTrigger.INHALATION, condition);
        return 1;
    }

    private static int clearEnvironmentalHazard(CommandContext<CommandSourceStack> context, BlockPos clearAt, MedicalCondition condition) {
        ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
        if (condition == null) {
            EnvironmentalHazardSavedData.getOrCreate(serverLevel).removeZone(clearAt);
            LocalizedHazardSavedData.getOrCreate(serverLevel).removeZoneByPosition(clearAt);
        } else {
            EnvironmentalHazardSavedData.getOrCreate(serverLevel).removeZone(clearAt, condition);
            LocalizedHazardSavedData.getOrCreate(serverLevel).removeZoneByPosition(clearAt, condition);
        }
        return 1;
    }
}

