/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.ender;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEnderRegistry;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import com.gregtechceu.gtceu.api.misc.virtualregistry.entries.VirtualTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.cover.ender.AbstractEnderLinkCover;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
public class EnderFluidLinkCover
extends AbstractEnderLinkCover<VirtualTank> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(EnderFluidLinkCover.class, AbstractEnderLinkCover.MANAGED_FIELD_HOLDER);
    public static final int TRANSFER_RATE = 8000;
    @Persisted
    @DescSynced
    protected VirtualTank visualTank;
    @Persisted
    @DescSynced
    protected final FilterHandler<FluidStack, FluidFilter> filterHandler = FilterHandlers.fluid(this);
    protected int mBLeftToTransferLastSecond = 160000;

    public EnderFluidLinkCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
        if (!this.isRemote()) {
            this.visualTank = VirtualEnderRegistry.getInstance().getOrCreateEntry(this.getOwner(), EntryTypes.ENDER_FLUID, this.getChannelName());
        }
    }

    @Override
    protected VirtualTank getEntry() {
        return this.visualTank;
    }

    @Override
    protected void setEntry(VirtualEntry entry) {
        this.visualTank = (VirtualTank)entry;
    }

    @Override
    public boolean canAttach() {
        return FluidUtil.getFluidHandler((Level)this.coverHolder.getLevel(), (BlockPos)this.coverHolder.getPos(), (Direction)this.attachedSide).isPresent();
    }

    @Override
    protected EntryTypes<VirtualTank> getEntryType() {
        return EntryTypes.ENDER_FLUID;
    }

    @Override
    protected String identifier() {
        return "EFLink#";
    }

    @Override
    protected void transfer() {
        long timer = this.coverHolder.getOffsetTimer();
        if (this.mBLeftToTransferLastSecond > 0) {
            int platformTransferredFluid = this.doTransferFluids(this.mBLeftToTransferLastSecond);
            this.mBLeftToTransferLastSecond -= platformTransferredFluid;
        }
        if (timer % 20L == 0L) {
            this.mBLeftToTransferLastSecond = 160000;
        }
    }

    @Nullable
    protected IFluidHandlerModifiable getOwnFluidHandler() {
        return this.coverHolder.getFluidHandlerCap(this.attachedSide, false);
    }

    private int doTransferFluids(int platformTransferLimit) {
        IFluidHandlerModifiable ownFluidHandler = this.getOwnFluidHandler();
        if (ownFluidHandler != null) {
            return switch (this.io) {
                case IO.IN -> GTTransferUtils.transferFluidsFiltered(ownFluidHandler, (IFluidHandler)this.visualTank.getFluidTank(), this.filterHandler.getFilter(), platformTransferLimit);
                case IO.OUT -> GTTransferUtils.transferFluidsFiltered((IFluidHandler)this.visualTank.getFluidTank(), ownFluidHandler, this.filterHandler.getFilter(), platformTransferLimit);
                default -> 0;
            };
        }
        return 0;
    }

    @Override
    @NotNull
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected Widget addVirtualEntryWidget(VirtualEntry entry, int x, int y, int width, int height, boolean canClick) {
        return new TankWidget((IFluidHandler)((VirtualTank)entry).getFluidTank(), 0, x, y, width, height, canClick, canClick).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT);
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.ender_fluid_link.title";
    }

    @Override
    @Generated
    public FilterHandler<FluidStack, FluidFilter> getFilterHandler() {
        return this.filterHandler;
    }
}

