/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.item.component.IItemLifeCycle;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ToggleEnergyConsumerBehavior
implements IInteractionItem,
IItemLifeCycle,
IAddInformation {
    private final int energyUsagePerTick;

    public ToggleEnergyConsumerBehavior(int energyUsagePerTick) {
        this.energyUsagePerTick = energyUsagePerTick;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level world, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (player.m_6144_()) {
            IElectricItem electricItem = GTCapabilityHelper.getElectricItem(itemStack);
            boolean isItemActive = ToggleEnergyConsumerBehavior.isItemActive(itemStack);
            if (isItemActive) {
                ToggleEnergyConsumerBehavior.setItemActive(itemStack, false);
            } else if (electricItem != null && this.drainActivationEnergy(electricItem, true)) {
                ToggleEnergyConsumerBehavior.setItemActive(itemStack, true);
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }

    private boolean drainActivationEnergy(IElectricItem electricItem, boolean simulate) {
        return electricItem.discharge(this.energyUsagePerTick, electricItem.getTier(), true, false, simulate) >= (long)this.energyUsagePerTick;
    }

    @Override
    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        boolean shouldRemainActive;
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stack);
        if (ToggleEnergyConsumerBehavior.isItemActive(stack) && electricItem != null && !(shouldRemainActive = this.drainActivationEnergy(electricItem, false))) {
            ToggleEnergyConsumerBehavior.setItemActive(stack, false);
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)Component.m_237115_((String)"behavior.toggle_energy_consumer.tooltip"));
    }

    public static boolean isItemActive(ItemStack itemStack) {
        CompoundTag tagCompound = itemStack.m_41783_();
        return tagCompound != null && tagCompound.m_128471_("Active");
    }

    public static void setItemActive(ItemStack itemStack, boolean isActive) {
        CompoundTag tagCompound = itemStack.m_41784_();
        tagCompound.m_128379_("Active", isActive);
    }
}

