/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item.armor;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ArmorProperty;
import com.gregtechceu.gtceu.client.renderer.item.ArmorItemRenderer;
import com.lowdragmc.lowdraglib.Platform;
import java.util.Objects;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTArmorItem
extends ArmorItem {
    public final Material material;
    public final ArmorProperty armorProperty;

    public GTArmorItem(ArmorMaterial armorMaterial, ArmorItem.Type type, Item.Properties properties, Material material, ArmorProperty armorProperty) {
        super(armorMaterial, type, properties);
        this.material = material;
        this.armorProperty = armorProperty;
        if (Platform.isClient()) {
            ArmorItemRenderer.create((Item)this, type);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor() {
        return (itemStack, index) -> {
            Item patt1618$temp;
            if (index == 0 && (patt1618$temp = itemStack.m_41720_()) instanceof GTArmorItem) {
                GTArmorItem item = (GTArmorItem)patt1618$temp;
                Material material = item.material;
                return material.getLayerARGB(index);
            }
            return -1;
        };
    }

    @NotNull
    public String m_5524_() {
        return "item.gtceu.armor." + this.f_265916_.m_266355_();
    }

    @NotNull
    public Component m_41466_() {
        return Component.m_237110_((String)this.m_5524_(), (Object[])new Object[]{this.material.getLocalizedName()});
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        ResourceLocation id = this.armorProperty.getCustomTextureGetter().getCustomTexture(stack, entity, slot, Objects.equals(type, "overlay"));
        if (id != null) {
            return id.toString();
        }
        return null;
    }
}

