/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.widget.PhantomFluidWidget;
import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CircuitFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IHasCircuitSlot;
import com.gregtechceu.gtceu.api.machine.feature.IMachineLife;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidHatchPartMachine
extends TieredIOPartMachine
implements IMachineLife,
IHasCircuitSlot,
IPaintable {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidHatchPartMachine.class, TieredIOPartMachine.MANAGED_FIELD_HOLDER);
    public static final int INITIAL_TANK_CAPACITY_1X = 8000;
    public static final int INITIAL_TANK_CAPACITY_4X = 2000;
    public static final int INITIAL_TANK_CAPACITY_9X = 1000;
    @Persisted
    public final NotifiableFluidTank tank;
    private final int slots;
    @Nullable
    protected TickableSubscription autoIOSubs;
    @Nullable
    protected ISubscription tankSubs;
    @Persisted
    @DescSynced
    protected boolean circuitSlotEnabled;
    @Persisted
    protected final NotifiableItemStackHandler circuitInventory;

    public FluidHatchPartMachine(IMachineBlockEntity holder, int tier, IO io, int initialCapacity, int slots, Object ... args) {
        super(holder, tier, io);
        this.slots = slots;
        this.tank = this.createTank(initialCapacity, slots, args);
        this.circuitSlotEnabled = true;
        this.circuitInventory = this.createCircuitItemHandler(io).shouldSearchContent(false);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableFluidTank createTank(int initialCapacity, int slots, Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, slots, FluidHatchPartMachine.getTankCapacity(initialCapacity, this.getTier()), this.io);
    }

    public static int getTankCapacity(int initialCapacity, int tier) {
        return initialCapacity * (1 << Math.min(9, tier));
    }

    protected NotifiableItemStackHandler createCircuitItemHandler(Object ... args) {
        IO io;
        Object object;
        if (args.length > 0 && (object = args[0]) instanceof IO && (io = (IO)object) == IO.IN) {
            return new NotifiableItemStackHandler(this, 1, IO.IN, IO.NONE).setFilter(IntCircuitBehaviour::isIntegratedCircuit);
        }
        return new NotifiableItemStackHandler(this, 0, IO.NONE);
    }

    @Override
    public void onMachineRemoved() {
        if (!ConfigHolder.INSTANCE.machines.ghostCircuit) {
            this.clearInventory((IItemHandlerModifiable)this.circuitInventory.storage);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateTankSubscription));
        }
        this.getHandlerList().setColor(this.getPaintingColor());
        this.tankSubs = this.tank.addChangedListener(this::updateTankSubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.tankSubs != null) {
            this.tankSubs.unsubscribe();
            this.tankSubs = null;
        }
    }

    @Override
    public void onPaintingColorChanged(int color) {
        this.getHandlerList().setColor(color, true);
    }

    @Override
    public void addedToController(IMultiController controller) {
        if (!controller.allowCircuitSlots()) {
            if (!ConfigHolder.INSTANCE.machines.ghostCircuit) {
                this.clearInventory((IItemHandlerModifiable)this.circuitInventory.storage);
            } else {
                this.circuitInventory.setStackInSlot(0, ItemStack.f_41583_);
            }
            this.setCircuitSlotEnabled(false);
        }
        super.addedToController(controller);
    }

    @Override
    public void removedFromController(IMultiController controller) {
        super.removedFromController(controller);
        for (IMultiController c : this.controllers) {
            if (c.allowCircuitSlots()) continue;
            return;
        }
        this.setCircuitSlotEnabled(true);
    }

    @Override
    public int tintColor(int index) {
        if (index == 9) {
            return this.getRealColor();
        }
        return -1;
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateTankSubscription();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        super.onRotated(oldFacing, newFacing);
        this.updateTankSubscription(newFacing);
    }

    protected void updateTankSubscription() {
        this.updateTankSubscription(this.getFrontFacing());
    }

    protected void updateTankSubscription(Direction newFacing) {
        if (this.isWorkingEnabled() && (this.io.support(IO.OUT) && !this.tank.isEmpty() || this.io.support(IO.IN)) && GTTransferUtils.hasAdjacentFluidHandler(this.getLevel(), this.getPos(), newFacing)) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    protected void autoIO() {
        if (this.getOffsetTimer() % 5L == 0L) {
            if (this.isWorkingEnabled()) {
                if (this.io == IO.OUT) {
                    this.tank.exportToNearby(this.getFrontFacing());
                } else if (this.io == IO.IN) {
                    this.tank.importFromNearby(this.getFrontFacing());
                } else if (this.io == IO.BOTH) {
                    this.tank.importFromNearby(this.getFrontFacing());
                    this.tank.exportToNearby(this.getFrontFacing().m_122424_());
                }
            }
            this.updateTankSubscription();
        }
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        super.setWorkingEnabled(workingEnabled);
        this.updateTankSubscription();
    }

    @Override
    protected InteractionResult onScrewdriverClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        InteractionResult superResult = super.onScrewdriverClick(playerIn, hand, gridSide, hitResult);
        if (superResult != InteractionResult.PASS) {
            return superResult;
        }
        if (this.io == IO.BOTH) {
            return InteractionResult.PASS;
        }
        if (playerIn.m_6144_() && this.swapIO()) {
            return InteractionResult.m_19078_((boolean)playerIn.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    public boolean swapIO() {
        IMachineBlockEntity newHolder;
        MetaMachine metaMachine;
        BlockPos blockPos = this.getHolder().pos();
        MachineDefinition newDefinition = null;
        if (this.io == IO.IN) {
            if (this.slots == 1) {
                newDefinition = GTMachines.FLUID_EXPORT_HATCH[this.getTier()];
            } else if (this.slots == 4) {
                newDefinition = GTMachines.FLUID_EXPORT_HATCH_4X[this.getTier()];
            } else if (this.slots == 9) {
                newDefinition = GTMachines.FLUID_EXPORT_HATCH_9X[this.getTier()];
            }
        } else if (this.io == IO.OUT) {
            if (this.slots == 1) {
                newDefinition = GTMachines.FLUID_IMPORT_HATCH[this.getTier()];
            } else if (this.slots == 4) {
                newDefinition = GTMachines.FLUID_IMPORT_HATCH_4X[this.getTier()];
            } else if (this.slots == 9) {
                newDefinition = GTMachines.FLUID_IMPORT_HATCH_9X[this.getTier()];
            }
        }
        if (newDefinition == null) {
            return false;
        }
        BlockState newBlockState = newDefinition.getBlock().m_49966_();
        this.getLevel().m_46597_(blockPos, newBlockState);
        BlockEntity blockEntity = this.getLevel().m_7702_(blockPos);
        if (blockEntity instanceof IMachineBlockEntity && (metaMachine = (newHolder = (IMachineBlockEntity)blockEntity).getMetaMachine()) instanceof FluidHatchPartMachine) {
            FluidHatchPartMachine newMachine = (FluidHatchPartMachine)metaMachine;
            newMachine.setFrontFacing(this.getFrontFacing());
            newMachine.setUpwardsFacing(this.getUpwardsFacing());
            newMachine.setPaintingColor(this.getPaintingColor());
            for (int i = 0; i < this.tank.getTanks(); ++i) {
                newMachine.tank.setFluidInTank(i, this.tank.getFluidInTank(i));
            }
        }
        return true;
    }

    @Override
    public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        super.attachConfigurators(configuratorPanel);
        if (this.isCircuitSlotEnabled() && this.io == IO.IN) {
            configuratorPanel.attachConfigurators(new CircuitFancyConfigurator(this.circuitInventory.storage));
        }
    }

    @Override
    public Widget createUIWidget() {
        if (this.slots == 1) {
            return this.createSingleSlotGUI();
        }
        return this.createMultiSlotGUI();
    }

    protected Widget createSingleSlotGUI() {
        TankWidget tankWidget;
        WidgetGroup group = new WidgetGroup(0, 0, 89, 63);
        group.addWidget((Widget)new ImageWidget(4, 4, 81, 55, (IGuiTexture)GuiTextures.DISPLAY));
        if (this.io == IO.OUT) {
            tankWidget = new PhantomFluidWidget((IFluidHandler)this.tank.getLockedFluid(), 0, 67, 40, 18, 18, () -> this.tank.getLockedFluid().getFluid(), f -> {
                if (!this.tank.getFluidInTank(0).isEmpty()) {
                    return;
                }
                if (f == null || f.isEmpty()) {
                    this.tank.setLocked(false);
                } else {
                    FluidStack newFluid = f.copy();
                    newFluid.setAmount(1);
                    this.tank.setLocked(true, newFluid);
                }
            }).setShowAmount(false).setDrawHoverTips(true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT);
            group.addWidget((Widget)tankWidget);
            group.addWidget((Widget)new ToggleButtonWidget(7, 40, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this.tank::isLocked, this.tank::setLocked).setTooltipText("gtceu.gui.fluid_lock.tooltip").setShouldUseBaseBackground()).addWidget((Widget)new TankWidget(this.tank.getStorages()[0], 67, 22, 18, 18, true, this.io.support(IO.IN)).setShowAmount(true).setDrawHoverTips(true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
        } else {
            tankWidget = new TankWidget(this.tank.getStorages()[0], 67, 22, 18, 18, true, this.io.support(IO.IN)).setShowAmount(true).setDrawHoverTips(true).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT);
            group.addWidget((Widget)tankWidget);
        }
        group.addWidget((Widget)new LabelWidget(8, 8, "gtceu.gui.fluid_amount")).addWidget((Widget)new LabelWidget(8, 18, () -> this.getFluidAmountText(tankWidget))).addWidget((Widget)new LabelWidget(8, 28, () -> this.getFluidNameText(tankWidget).getString()));
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        return group;
    }

    private Component getFluidNameText(TankWidget tankWidget) {
        Component translation = !this.tank.getFluidInTank(tankWidget.getTank()).isEmpty() ? this.tank.getFluidInTank(tankWidget.getTank()).getDisplayName() : this.tank.getLockedFluid().getFluid().getDisplayName();
        return translation;
    }

    private String getFluidAmountText(TankWidget tankWidget) {
        String fluidAmount = "";
        if (!this.tank.getFluidInTank(tankWidget.getTank()).isEmpty()) {
            fluidAmount = this.getFormattedFluidAmount(this.tank.getFluidInTank(tankWidget.getTank()));
        } else if (!this.tank.getLockedFluid().getFluid().isEmpty()) {
            fluidAmount = "0";
        }
        return fluidAmount;
    }

    public String getFormattedFluidAmount(FluidStack fluidStack) {
        return String.format("%,d", fluidStack.isEmpty() ? 0 : fluidStack.getAmount());
    }

    protected Widget createMultiSlotGUI() {
        int rowSize;
        int colSize = rowSize = (int)Math.sqrt(this.slots);
        if (this.slots == 8) {
            rowSize = 4;
            colSize = 2;
        }
        WidgetGroup group = new WidgetGroup(0, 0, 18 * rowSize + 16, 18 * colSize + 16);
        WidgetGroup container = new WidgetGroup(4, 4, 18 * rowSize + 8, 18 * colSize + 8);
        int index = 0;
        for (int y = 0; y < colSize; ++y) {
            for (int x = 0; x < rowSize; ++x) {
                container.addWidget((Widget)new TankWidget(this.tank.getStorages()[index++], 4 + x * 18, 4 + y * 18, true, this.io.support(IO.IN)).setBackground((IGuiTexture)GuiTextures.FLUID_SLOT));
            }
        }
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    @Generated
    public boolean isCircuitSlotEnabled() {
        return this.circuitSlotEnabled;
    }

    @Generated
    public void setCircuitSlotEnabled(boolean circuitSlotEnabled) {
        this.circuitSlotEnabled = circuitSlotEnabled;
    }

    @Override
    @Generated
    public NotifiableItemStackHandler getCircuitInventory() {
        return this.circuitInventory;
    }
}

