/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.primitive;

import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.world.level.biome.Biome;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PrimitivePumpMachine
extends MultiblockControllerMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PrimitivePumpMachine.class, MultiblockControllerMachine.MANAGED_FIELD_HOLDER);
    private int biomeModifier = 0;
    private int hatchModifier = 0;
    private NotifiableFluidTank fluidTank;
    private TickableSubscription produceWaterSubscription;

    public PrimitivePumpMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.initializeTank();
        this.produceWaterSubscription = this.subscribeServerTick(this::produceWater);
    }

    private void initializeTank() {
        for (IMultiPart part : this.getParts()) {
            List<RecipeHandlerList> handlerLists = part.getRecipeHandlers();
            for (RecipeHandlerList handlerList : handlerLists) {
                List<IRecipeHandler<?>> recipeCap = handlerList.getCapability(FluidRecipeCapability.CAP);
                if (!handlerList.getHandlerIO().support(IO.OUT) || recipeCap.isEmpty()) continue;
                this.fluidTank = (NotifiableFluidTank)recipeCap.get(0);
                long tankCapacity = this.fluidTank.getTankCapacity(0);
                this.hatchModifier = tankCapacity == 1000L ? 1 : (tankCapacity == 8000L ? 2 : 4);
                return;
            }
        }
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.resetState();
    }

    @Override
    public void onPartUnload() {
        super.onPartUnload();
        this.resetState();
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.resetState();
    }

    private void resetState() {
        this.unsubscribe(this.produceWaterSubscription);
        this.hatchModifier = 0;
        this.fluidTank = null;
    }

    private void produceWater() {
        if (this.getOffsetTimer() % 20L == 0L && this.isFormed() && !this.getMultiblockState().hasError()) {
            if (this.biomeModifier == 0) {
                this.biomeModifier = GTUtil.getPumpBiomeModifier((Holder<Biome>)this.getLevel().m_204166_(this.getPos()));
            } else if (this.biomeModifier > 0) {
                if (this.fluidTank == null) {
                    this.initializeTank();
                }
                if (this.fluidTank != null) {
                    this.fluidTank.handleRecipe(IO.OUT, null, List.of(FluidIngredient.of(GTMaterials.Water.getFluid(this.getFluidProduction()))), false);
                }
            }
        }
    }

    private boolean isRainingInBiome() {
        if (!this.getLevel().m_46471_()) {
            return false;
        }
        return this.getBiomePrecipitation() != Biome.Precipitation.NONE;
    }

    private Biome.Precipitation getBiomePrecipitation() {
        return ((Biome)this.getLevel().m_204166_(this.getPos()).m_203334_()).m_264600_(this.getPos());
    }

    public int getFluidProduction() {
        int value = this.biomeModifier * this.hatchModifier;
        if (this.isRainingInBiome()) {
            value = value * 3 / 2;
        }
        return value;
    }
}

