/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.customlogic;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public enum FormingPressLogic implements GTRecipeType.ICustomRecipeLogic
{
    INSTANCE;


    @Override
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        List<RecipeHandlerList> rhlList = holder.getCapabilitiesForIO(IO.IN);
        if (rhlList.isEmpty()) {
            return null;
        }
        ArrayList<RecipeHandlerList> distinct = new ArrayList<RecipeHandlerList>();
        ArrayList indistinct = new ArrayList();
        for (RecipeHandlerList recipeHandlerList : rhlList) {
            if (recipeHandlerList.isDistinct() && recipeHandlerList.hasCapability(ItemRecipeCapability.CAP)) {
                distinct.add(recipeHandlerList);
                continue;
            }
            if (!recipeHandlerList.hasCapability(ItemRecipeCapability.CAP)) continue;
            indistinct.addAll(recipeHandlerList.getCapability(ItemRecipeCapability.CAP));
        }
        RecipeData data = new RecipeData();
        for (RecipeHandlerList recipeHandlerList : distinct) {
            List<ItemStack> stacks = FormingPressLogic.collect(recipeHandlerList);
            if (stacks.isEmpty()) continue;
            data.mold = ItemStack.f_41583_;
            data.item = ItemStack.f_41583_;
            for (ItemStack stack : stacks) {
                boolean isMold = GTItems.SHAPE_MOLD_NAME.isIn(stack);
                if (data.mold.m_41619_() && isMold && stack.m_41788_()) {
                    data.mold = stack;
                } else if (!(!data.item.m_41619_() || isMold && stack.m_41788_())) {
                    data.item = stack;
                }
                if (!data.found()) continue;
                return data.buildRecipe();
            }
        }
        List<ItemStack> list = FormingPressLogic.collect(indistinct);
        if (list.isEmpty()) {
            return null;
        }
        for (ItemStack stack : list) {
            if (data.mold.m_41619_() && GTItems.SHAPE_MOLD_NAME.isIn(stack) && stack.m_41788_()) {
                data.mold = stack;
            } else if (data.item.m_41619_()) {
                data.item = stack;
            }
            if (!data.found()) continue;
            return data.buildRecipe();
        }
        return null;
    }

    private static List<ItemStack> collect(RecipeHandlerList rhl) {
        return FormingPressLogic.collect(rhl.getCapability(ItemRecipeCapability.CAP));
    }

    private static List<ItemStack> collect(List<IRecipeHandler<?>> handlers) {
        if (handlers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (IRecipeHandler<?> handler : handlers) {
            for (Object content : handler.getContents()) {
                ItemStack stack;
                if (!(content instanceof ItemStack) || (stack = (ItemStack)content).m_41619_()) continue;
                list.add(stack);
            }
        }
        return list;
    }

    @Override
    public void buildRepresentativeRecipes() {
        ItemStack press = GTItems.SHAPE_MOLD_NAME.asStack();
        press.m_41714_((Component)Component.m_237115_((String)"gtceu.forming_press.naming.press"));
        ItemStack toName = new ItemStack((ItemLike)Items.f_42656_);
        toName.m_41714_((Component)Component.m_237115_((String)"gtceu.forming_press.naming.to_name"));
        ItemStack named = new ItemStack((ItemLike)Items.f_42656_);
        named.m_41714_((Component)Component.m_237115_((String)"gtceu.forming_press.naming.named"));
        GTRecipe recipe = GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder("name_item").notConsumable(press).inputItems(toName).outputItems(named).duration(40).EUt(4L).buildRawRecipe();
        recipe.setId(recipe.m_6423_().m_246208_("/"));
        GTRecipeTypes.FORMING_PRESS_RECIPES.addToMainCategory(recipe);
    }

    private static class RecipeData {
        ItemStack mold = ItemStack.f_41583_;
        ItemStack item = ItemStack.f_41583_;

        private RecipeData() {
        }

        boolean found() {
            return !this.mold.m_41619_() && !this.item.m_41619_();
        }

        GTRecipe buildRecipe() {
            ItemStack output = this.item.m_255036_(1);
            output.m_41714_(this.mold.m_41786_());
            return GTRecipeTypes.FORMING_PRESS_RECIPES.recipeBuilder(GTStringUtils.itemStackToString(output)).notConsumable(this.mold).inputItems(this.item.m_255036_(1)).outputItems(output).duration(40).EUt(4L).buildRawRecipe();
        }
    }
}

