/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait.customlogic;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTRecipeCategories;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.item.TurbineRotorBehaviour;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MaceratorLogic
extends Enum<MaceratorLogic>
implements GTRecipeType.ICustomRecipeLogic {
    public static final /* enum */ MaceratorLogic INSTANCE = new MaceratorLogic();
    private static final /* synthetic */ MaceratorLogic[] $VALUES;

    public static MaceratorLogic[] values() {
        return (MaceratorLogic[])$VALUES.clone();
    }

    public static MaceratorLogic valueOf(String name) {
        return Enum.valueOf(MaceratorLogic.class, name);
    }

    @Override
    @Nullable
    public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
        List<IRecipeHandler<?>> recipeHandlers = holder.getCapabilitiesFlat(IO.IN, ItemRecipeCapability.CAP);
        for (IRecipeHandler<?> handler : recipeHandlers) {
            for (Object content : handler.getContents()) {
                GTRecipe recipe;
                ItemStack stack;
                if (!(content instanceof ItemStack) || (stack = (ItemStack)content).m_41619_() || (recipe = this.search(stack)) == null) continue;
                return recipe;
            }
        }
        return null;
    }

    @Nullable
    private GTRecipe search(ItemStack stack) {
        IGTTool tool;
        TurbineRotorBehaviour turbineBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        if (turbineBehaviour != null) {
            float durability = 1.0f - (float)turbineBehaviour.getPartDamage(stack) / (float)turbineBehaviour.getPartMaxDurability(stack);
            return this.applyDurabilityRecipe("rotor_decomp", stack, turbineBehaviour.getPartMaterial(stack), (float)(TagPrefix.turbineBlade.materialAmount() * 8L) / 3628800.0f, durability, GTValues.VH[4], 1);
        }
        Item item = stack.m_41720_();
        if (item instanceof IGTTool && !(tool = (IGTTool)item).isElectric()) {
            float durability = (float)(tool.getTotalMaxDurability(stack) - stack.m_41773_() + 1) / (float)(tool.getTotalMaxDurability(stack) + 1);
            return this.applyDurabilityRecipe("tool_decomp", stack, tool.getMaterial(), tool.getToolType().materialAmount / 3628800L, durability, GTValues.VH[1], 2);
        }
        return null;
    }

    @Nullable
    public GTRecipe applyDurabilityRecipe(String id, ItemStack inputStack, @NotNull Material mat, float fullAmount, float durability, long voltage, int durationFactor) {
        int leftAmount;
        float outputAmount = durability * fullAmount;
        int dustAmount = (int)outputAmount;
        int leftover = (int)((outputAmount - (float)dustAmount) * 36.0f);
        TagPrefix tag = leftover % 4 >= leftover % 9 ? TagPrefix.dustSmall : TagPrefix.dustTiny;
        int n = leftAmount = leftover % 4 >= leftover % 9 ? leftover / 9 : leftover / 4;
        if (dustAmount == 0 && leftAmount == 0) {
            return null;
        }
        GTRecipeBuilder builder = GTRecipeTypes.MACERATOR_RECIPES.recipeBuilder(id + "/" + mat.getName()).inputItems(inputStack).EUt(voltage).duration((int)((float)mat.getMass() * outputAmount) * durationFactor);
        if (dustAmount > 0) {
            builder.outputItems(TagPrefix.dust, mat, dustAmount);
        }
        if (leftAmount > 0) {
            builder.outputItems(tag, mat, leftAmount);
        }
        return builder.buildRawRecipe();
    }

    @Override
    public void buildRepresentativeRecipes() {
        ItemStack stack = GTItems.TURBINE_ROTOR.asStack();
        stack.m_41714_((Component)Component.m_237115_((String)"gtceu.auto_decomp.rotor"));
        float durability = 0.75f;
        TurbineRotorBehaviour turbineBehaviour = TurbineRotorBehaviour.getBehaviour(stack);
        assert (turbineBehaviour != null) : "Default Turbine Stack doesn't have Turbine Behaviour";
        turbineBehaviour.setPartMaterial(stack, GTMaterials.Iron);
        turbineBehaviour.setPartDamage(stack, 8928);
        GTRecipe rotorRecipe = this.applyDurabilityRecipe("rotor_decomp", stack, turbineBehaviour.getPartMaterial(stack), (float)(TagPrefix.turbineBlade.materialAmount() * 8L) / 3628800.0f, durability, GTValues.VH[4], 1);
        assert (rotorRecipe != null) : "Default Turbine Decomp recipe couldn't be generated";
        rotorRecipe.setId(rotorRecipe.m_6423_().m_246208_("/"));
        stack = ((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)GTMaterials.Iron, (Object)GTToolType.PICKAXE)).asStack();
        stack.m_41714_((Component)Component.m_237115_((String)"gtceu.auto_decomp.tool"));
        stack.m_41721_(79);
        GTRecipe pickaxeRecipe = this.applyDurabilityRecipe("tool_decomp", stack, GTMaterials.Iron, GTToolType.PICKAXE.materialAmount / 3628800L, durability, GTValues.VH[1], 2);
        assert (pickaxeRecipe != null) : "Default Tool Decomp recipe couldn't be generated";
        pickaxeRecipe.setId(pickaxeRecipe.m_6423_().m_246208_("/"));
        GTRecipeCategories.MACERATOR_RECYCLING.addRecipe(pickaxeRecipe);
        GTRecipeCategories.MACERATOR_RECYCLING.addRecipe(rotorRecipe);
    }

    private static /* synthetic */ MaceratorLogic[] $values() {
        return new MaceratorLogic[]{INSTANCE};
    }

    static {
        $VALUES = MaceratorLogic.$values();
    }
}

