/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.fluidpipe;

import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.core.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class PipeTankList
implements IFluidHandlerModifiable,
Iterable<CustomFluidTank> {
    private final FluidPipeBlockEntity pipe;
    private final CustomFluidTank[] tanks;
    private final Direction facing;

    public PipeTankList(FluidPipeBlockEntity pipe, Direction facing, CustomFluidTank ... fluidTanks) {
        this.tanks = fluidTanks;
        this.pipe = pipe;
        this.facing = facing;
    }

    private int findChannel(FluidStack stack) {
        if (stack.isEmpty() || this.tanks == null) {
            return -1;
        }
        int empty = -1;
        for (int i = this.tanks.length - 1; i >= 0; --i) {
            FluidStack f = this.tanks[i].getFluid();
            if (f.isEmpty()) {
                empty = i;
                continue;
            }
            if (!f.isFluidEqual(stack)) continue;
            return i;
        }
        return empty;
    }

    public int getTanks() {
        return this.tanks.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.tanks[tank].getFluid();
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        this.tanks[tank].setFluid(fluidStack);
    }

    public int getTankCapacity(int tank) {
        return this.tanks[tank].getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.tanks[tank].isFluidValid(stack);
    }

    private int fullCapacity() {
        return this.tanks.length * this.pipe.getCapacityPerTank();
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int channel;
        if (this.pipe.isBlocked(this.facing) || resource.getAmount() < 0 || (channel = this.findChannel(resource)) < 0) {
            return 0;
        }
        return this.fill(resource, action, channel);
    }

    private int fill(FluidStack resource, IFluidHandler.FluidAction action, int channel) {
        int toAdd;
        if (channel >= this.tanks.length) {
            return 0;
        }
        CustomFluidTank tank = this.tanks[channel];
        FluidStack currentFluid = tank.getFluid();
        if (currentFluid.isEmpty() || currentFluid.getAmount() <= 0) {
            FluidStack newFluid = resource.copy();
            newFluid.setAmount(Math.min(this.pipe.getCapacityPerTank(), newFluid.getAmount()));
            if (action.execute()) {
                tank.setFluid(newFluid);
                this.pipe.receivedFrom(this.facing);
                this.pipe.checkAndDestroy(newFluid);
            }
            return newFluid.getAmount();
        }
        if (currentFluid.isFluidEqual(resource) && (toAdd = Math.min(tank.getCapacity() - currentFluid.getAmount(), resource.getAmount())) > 0) {
            if (action.execute()) {
                currentFluid.setAmount(currentFluid.getAmount() + toAdd);
                this.pipe.receivedFrom(this.facing);
                this.pipe.checkAndDestroy(currentFluid);
            }
            return toAdd;
        }
        return 0;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0) {
            return FluidStack.EMPTY;
        }
        for (CustomFluidTank tank : this.tanks) {
            FluidStack drained = tank.drain(maxDrain, action);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.getAmount() <= 0) {
            return FluidStack.EMPTY;
        }
        resource = resource.copy();
        for (CustomFluidTank tank : this.tanks) {
            FluidStack drained = tank.drain(resource, action);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Override
    @NotNull
    public Iterator<CustomFluidTank> iterator() {
        return Arrays.stream(this.tanks).iterator();
    }
}

