/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.laser;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserNetWalker;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserRoutePath;
import com.gregtechceu.gtceu.common.pipelike.laser.LevelLaserPipeNet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaserPipeNet
extends PipeNet<LaserPipeProperties> {
    private final Map<BlockPos, LaserRoutePath> netData = new Object2ObjectOpenHashMap();

    public LaserPipeNet(LevelLaserPipeNet world) {
        super(world);
    }

    @Nullable
    public LaserRoutePath getNetData(BlockPos pipePos, Direction facing) {
        LaserRoutePath data = this.netData.get(pipePos);
        if (data == null) {
            data = LaserNetWalker.createNetData(this, pipePos, facing);
            if (data == LaserNetWalker.FAILED_MARKER) {
                return null;
            }
            this.netData.put(pipePos, data);
        }
        return data;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.netData.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.netData.clear();
    }

    @Override
    protected void writeNodeData(LaserPipeProperties laserPipeProperties, CompoundTag compoundTag) {
    }

    @Override
    protected LaserPipeProperties readNodeData(CompoundTag tagCompound) {
        return LaserPipeProperties.INSTANCE;
    }

    public static class LaserData
    implements IAttachData {
        private final BlockPos pipePos;
        private final Direction faceToHandler;
        private final int distance;
        private final LaserPipeProperties properties;
        byte connections;

        @Override
        public boolean canAttachTo(Direction side) {
            return (this.connections & 1 << side.ordinal()) != 0 && side.m_122434_() == this.faceToHandler.m_122434_();
        }

        @Override
        public boolean setAttached(Direction side, boolean attach) {
            boolean result = this.canAttachTo(side);
            if (result != attach) {
                this.connections = attach ? (byte)(this.connections | 1 << side.ordinal()) : (byte)(this.connections & ~(1 << side.ordinal()));
            }
            return result != attach;
        }

        @NotNull
        public BlockPos getHandlerPos() {
            return this.pipePos.m_121945_(this.faceToHandler);
        }

        @Nullable
        public ILaserContainer getHandler(@NotNull Level world) {
            return GTCapabilityHelper.getLaser(world, this.getHandlerPos(), this.faceToHandler.m_122424_());
        }

        @Generated
        public LaserData(BlockPos pipePos, Direction faceToHandler, int distance, LaserPipeProperties properties, byte connections) {
            this.pipePos = pipePos;
            this.faceToHandler = faceToHandler;
            this.distance = distance;
            this.properties = properties;
            this.connections = connections;
        }

        @Generated
        public BlockPos getPipePos() {
            return this.pipePos;
        }

        @Generated
        public Direction getFaceToHandler() {
            return this.faceToHandler;
        }

        @Generated
        public int getDistance() {
            return this.distance;
        }

        @Generated
        public LaserPipeProperties getProperties() {
            return this.properties;
        }

        @Generated
        public byte getConnections() {
            return this.connections;
        }
    }
}

