/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.recipe.condition;

import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.ConditionSerializeUtils;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.common.data.GTRecipeConditions;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AdjacentFluidCondition
extends RecipeCondition {
    public static final Codec<AdjacentFluidCondition> CODEC = RecordCodecBuilder.create(instance -> RecipeCondition.isReverse(instance).and((App)Codec.STRING.fieldOf("fluidString").forGetter(AdjacentFluidCondition::getFluidString)).apply((Applicative)instance, AdjacentFluidCondition::new));
    @NotNull
    private String fluidString = "";
    @Nullable
    private List<HolderSet<Fluid>> fluids = null;

    public void setFluids(@NotNull List<HolderSet<Fluid>> fluids) {
        this.fluids = fluids;
        this.fluidString = ConditionSerializeUtils.encodeHolderSets(fluids);
    }

    public List<HolderSet<Fluid>> getFluids() {
        if (this.fluids == null) {
            this.fluids = ConditionSerializeUtils.decodeHolderSets(this.getFluidString(), Registries.f_256808_);
        }
        return this.fluids;
    }

    public AdjacentFluidCondition(@NotNull List<HolderSet<Fluid>> fluids) {
        this.setFluids(fluids);
    }

    public AdjacentFluidCondition(boolean isReverse, String fluidString) {
        super(isReverse);
        this.fluidString = fluidString;
    }

    public AdjacentFluidCondition(boolean isReverse, @NotNull List<HolderSet<Fluid>> fluids) {
        super(isReverse);
        this.setFluids(fluids);
    }

    public static AdjacentFluidCondition fromFluids(Collection<Fluid> fluids) {
        return new AdjacentFluidCondition(fluids.stream().map(Fluid::m_205069_).map(xva$0 -> HolderSet.m_205809_((Holder[])new Holder[]{xva$0})).toList());
    }

    public static AdjacentFluidCondition fromFluids(Fluid ... fluids) {
        return AdjacentFluidCondition.fromFluids(Arrays.asList(fluids));
    }

    public static AdjacentFluidCondition fromTags(Collection<TagKey<Fluid>> tags) {
        return new AdjacentFluidCondition(tags.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.f_257020_).m_203561_(arg_0)).toList());
    }

    @SafeVarargs
    public static AdjacentFluidCondition fromTags(TagKey<Fluid> ... tags) {
        return AdjacentFluidCondition.fromTags(Arrays.asList(tags));
    }

    @Override
    public RecipeConditionType<?> getType() {
        return GTRecipeConditions.ADJACENT_FLUID;
    }

    @Override
    public Component getTooltips() {
        return Component.m_237115_((String)"recipe.condition.adjacent_fluid.tooltip");
    }

    @Override
    public boolean testCondition(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        Level level = recipeLogic.getMachine().getLevel();
        BlockPos pos = recipeLogic.getMachine().getPos();
        if (level == null) {
            return false;
        }
        HashSet<HolderSet<Fluid>> remainingFluids = new HashSet<HolderSet<Fluid>>(this.getOrInitFluids(recipe));
        if (remainingFluids.isEmpty()) {
            return true;
        }
        for (BlockPos offset : GTUtil.NON_CORNER_NEIGHBOURS) {
            FluidState fluid = level.m_6425_(pos.m_121955_((Vec3i)offset));
            if (!fluid.m_76170_()) continue;
            Iterator it = remainingFluids.iterator();
            while (it.hasNext()) {
                if (!fluid.m_205072_((HolderSet)it.next())) continue;
                it.remove();
                break;
            }
            if (!remainingFluids.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<HolderSet<Fluid>> getOrInitFluids(@NotNull GTRecipe recipe) {
        if (this.getFluids().isEmpty() || recipe.data.m_128441_("fluidA") && recipe.data.m_128441_("fluidB")) {
            Fluid fluidB;
            ArrayList<HolderSet<Fluid>> fluids = new ArrayList<HolderSet<Fluid>>();
            Fluid fluidA = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(recipe.data.m_128461_("fluidA")));
            if (!fluidA.m_76145_().m_76178_()) {
                fluids.add((HolderSet<Fluid>)HolderSet.m_205809_((Holder[])new Holder[]{fluidA.m_205069_()}));
            }
            if (!(fluidB = (Fluid)BuiltInRegistries.f_257020_.m_7745_(new ResourceLocation(recipe.data.m_128461_("fluidB")))).m_76145_().m_76178_()) {
                fluids.add((HolderSet<Fluid>)HolderSet.m_205809_((Holder[])new Holder[]{fluidB.m_205069_()}));
            }
            this.setFluids(fluids);
        }
        return this.getFluids();
    }

    @Override
    public RecipeCondition createTemplate() {
        return new AdjacentFluidCondition();
    }

    @Generated
    public AdjacentFluidCondition() {
    }

    @NotNull
    @Generated
    public String getFluidString() {
        return this.fluidString;
    }
}

