/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins;

import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.MultiblockWorldSavedData;
import com.lowdragmc.lowdraglib.async.AsyncThreadData;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements LevelAccessor {
    @Shadow
    @Final
    public boolean f_46443_;
    @Shadow
    @Final
    private Thread f_46423_;

    @Unique
    @Nullable
    private ChunkAccess gtceu$maybeGetChunkAsync(int chunkX, int chunkZ) {
        if (this.f_46443_) {
            return null;
        }
        if (Thread.currentThread() == this.f_46423_) {
            return null;
        }
        if (!MultiblockWorldSavedData.isThreadService() && !AsyncThreadData.isThreadService()) {
            return null;
        }
        if (!this.m_7726_().m_5563_(chunkX, chunkZ)) {
            return null;
        }
        return this.m_7726_().m_7131_(chunkX, chunkZ);
    }

    @Inject(method={"getBlockEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void gtceu$getBlockEntityOffThread(BlockPos pos, CallbackInfoReturnable<BlockEntity> cir) {
        ChunkAccess chunk = this.gtceu$maybeGetChunkAsync(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunk instanceof LevelChunk) {
            LevelChunk levelChunk = (LevelChunk)chunk;
            cir.setReturnValue((Object)((BlockEntity)levelChunk.m_62954_().get(pos)));
        }
    }

    @Inject(method={"getBlockState"}, at={@At(value="HEAD")}, cancellable=true)
    private void gtceu$getBlockStateOffThread(BlockPos pos, CallbackInfoReturnable<BlockState> cir) {
        ChunkAccess chunk = this.gtceu$maybeGetChunkAsync(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        if (chunk != null) {
            cir.setReturnValue((Object)chunk.m_8055_(pos));
        }
    }

    @Inject(method={"markAndNotifyBlock"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlocksDirty(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/state/BlockState;)V", remap=true)}, remap=false)
    private void gtceu$updateChunkMultiblocks(BlockPos pos, LevelChunk chunk, BlockState oldState, BlockState newState, int flags, int recursionLeft, CallbackInfo ci) {
        LevelMixin levelMixin = this;
        if (!(levelMixin instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)levelMixin;
        MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
        HashSet<MultiblockState> defensiveCopy = new HashSet<MultiblockState>(mwsd.getControllersInChunk(chunk.m_7697_()));
        for (MultiblockState structure : defensiveCopy) {
            if (!structure.isPosInCache(pos)) continue;
            serverLevel.m_7654_().m_18709_(() -> structure.onBlockStateChanged(pos, newState));
        }
    }
}

