/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.ItemMaterialData;
import com.gregtechceu.gtceu.api.data.chemical.material.MarkerMaterial;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.ItemMaterialInfo;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.data.recipe.builder.BlastingRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.CampfireRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedEnergyTransferRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedFluidContainerRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapedRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.ShapelessRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.SmeltingRecipeBuilder;
import com.gregtechceu.gtceu.data.recipe.builder.SmokingRecipeBuilder;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharArraySet;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class VanillaRecipeHelper {
    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, regName, input, output, 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, Ingredient input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, regName, input, output, 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, Ingredient input, ItemStack output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, Item input, Item output) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input.m_7968_(), output.m_7968_(), 0.0f);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, Item input, Item output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input.m_7968_(), output.m_7968_(), experience);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmeltingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmeltingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output, float experience) {
        new SmeltingRecipeBuilder(regName).input(input).output(output).cookingTime(200).experience(experience).save(provider);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addBlastingRecipe(provider, regName, Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), output, 0.0f);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addBlastingRecipe(provider, regName, Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), output, experience);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addBlastingRecipe(provider, regName, Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), output, 0.0f);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addBlastingRecipe(provider, regName, Ingredient.m_43927_((ItemStack[])new ItemStack[]{input}), output, experience);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addBlastingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, Ingredient input, ItemStack output, float experience) {
        VanillaRecipeHelper.addBlastingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, Ingredient input, ItemStack output, float experience) {
        new BlastingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addBlastingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new BlastingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addSmokingRecipe(provider, regName, input, output, 0.0f);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addSmokingRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new SmokingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addSmokingRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output, float experience) {
        new SmokingRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output, float experience) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output) {
        VanillaRecipeHelper.addCampfireRecipe(provider, regName, input, output, 0.0f);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, ItemStack input, ItemStack output, float experience) {
        new CampfireRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output, float experience) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, experience);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, TagKey<Item> input, ItemStack output) {
        VanillaRecipeHelper.addCampfireRecipe(provider, GTCEu.id(regName), input, output, 0.0f);
    }

    public static void addCampfireRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, TagKey<Item> input, ItemStack output, float experience) {
        new CampfireRecipeBuilder(regName).input(input).output(output).cookingTime(100).experience(experience).save(provider);
    }

    public static void addShapedNBTClearingRecipe(Consumer<FinishedRecipe> provider, String regName, ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, regName, result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, false, regName, result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, setMaterialInfoData, GTCEu.id(regName), result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addStrictShapedRecipe(provider, false, regName, result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, boolean isStrict, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        ShapedRecipeBuilder builder = new ShapedRecipeBuilder(regName).output(result);
        builder.isStrict(isStrict);
        CharSet tools = ToolHelper.getToolSymbols();
        CharArraySet foundTools = new CharArraySet(9);
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (char c : pattern.toCharArray()) {
                    if (!tools.contains(c)) continue;
                    foundTools.add(c);
                }
            }
            if (o instanceof String[]) {
                for (String s : pattern = (String[])o) {
                    builder.pattern(s);
                    for (char c : s.toCharArray()) {
                        if (!tools.contains(c)) continue;
                        foundTools.add(c);
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object object = recipe[i + 1];
            ++i;
            if (object instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)object;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (object instanceof TagKey) {
                TagKey key = (TagKey)object;
                builder.define(sign.charValue(), (TagKey<Item>)key);
                continue;
            }
            if (object instanceof TagPrefix) {
                TagPrefix prefix = (TagPrefix)object;
                if (prefix.getItemParentTags().length <= 0) continue;
                builder.define(sign.charValue(), prefix.getItemParentTags()[0]);
                continue;
            }
            if (object instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)object;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (object instanceof MaterialEntry) {
                MaterialEntry entry = (MaterialEntry)object;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix(), entry.material());
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix(), entry.material()));
                continue;
            }
            if (!(object instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)object;
            builder.define(sign.charValue(), entry.asStack());
        }
        CharIterator it = foundTools.iterator();
        while (it.hasNext()) {
            char c = it.nextChar();
            builder.define(c, ToolHelper.getToolFromSymbol((char)c).itemTags.get(0));
        }
        builder.save(provider);
        if (setMaterialInfoData) {
            ItemMaterialData.registerMaterialInfo((ItemLike)result.m_41720_(), VanillaRecipeHelper.getRecyclingIngredients(result.m_41613_(), recipe));
        }
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, setMaterialInfoData, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, setMaterialInfoData, false, regName, result, recipe);
    }

    public static void addStrictShapedRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedRecipe(provider, setMaterialInfoData, true, regName, result, recipe);
    }

    public static void addShapelessRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapelessRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedEnergyTransferRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, boolean overrideCharge, boolean transferMaxCharge, @NotNull ResourceLocation regName, @NotNull Ingredient chargeIngredient, @NotNull ItemStack result, Object ... recipe) {
        ShapedEnergyTransferRecipeBuilder builder = new ShapedEnergyTransferRecipeBuilder(regName).output(result);
        builder.chargeIngredient(chargeIngredient).overrideCharge(overrideCharge).transferMaxCharge(transferMaxCharge);
        CharSet tools = ToolHelper.getToolSymbols();
        CharArraySet foundTools = new CharArraySet(9);
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (char c : pattern.toCharArray()) {
                    if (!tools.contains(c)) continue;
                    foundTools.add(c);
                }
            }
            if (o instanceof String[]) {
                for (String s : pattern = (String[])o) {
                    builder.pattern(s);
                    for (char c : s.toCharArray()) {
                        if (!tools.contains(c)) continue;
                        foundTools.add(c);
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object object = recipe[i + 1];
            ++i;
            if (object instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)object;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (object instanceof TagKey) {
                TagKey key = (TagKey)object;
                builder.define(sign.charValue(), (TagKey<Item>)key);
                continue;
            }
            if (object instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)object;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (object instanceof MaterialEntry) {
                MaterialEntry entry = (MaterialEntry)object;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix(), entry.material());
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix(), entry.material()));
                continue;
            }
            if (!(object instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)object;
            builder.define(sign.charValue(), entry.asStack());
        }
        CharIterator it = foundTools.iterator();
        while (it.hasNext()) {
            char c = it.nextChar();
            builder.define(c, ToolHelper.getToolFromSymbol((char)c).itemTags.get(0));
        }
        builder.save(provider);
        if (setMaterialInfoData) {
            ItemMaterialData.registerMaterialInfo((ItemLike)result.m_41720_(), VanillaRecipeHelper.getRecyclingIngredients(result.m_41613_(), recipe));
        }
    }

    public static void addShapedEnergyTransferRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, boolean overrideCharge, boolean transferMaxCharge, @NotNull String regName, @NotNull Ingredient chargeIngredient, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedEnergyTransferRecipe(provider, setMaterialInfoData, overrideCharge, transferMaxCharge, GTCEu.id(regName), chargeIngredient, result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, boolean isStrict, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        ShapedRecipeBuilder builder = new ShapedFluidContainerRecipeBuilder(regName).output(result);
        builder.isStrict(isStrict);
        CharSet tools = ToolHelper.getToolSymbols();
        CharArraySet foundTools = new CharArraySet(9);
        for (int i = 0; i < recipe.length; ++i) {
            String[] pattern;
            Object o = recipe[i];
            if (o instanceof String) {
                pattern = (String[])o;
                builder.pattern((String)pattern);
                for (char c : pattern.toCharArray()) {
                    if (!tools.contains(c)) continue;
                    foundTools.add(c);
                }
            }
            if (o instanceof String[]) {
                for (String s : pattern = (String[])o) {
                    builder.pattern(s);
                    for (char c : s.toCharArray()) {
                        if (!tools.contains(c)) continue;
                        foundTools.add(c);
                    }
                }
            }
            if (!(o instanceof Character)) continue;
            Character sign = (Character)o;
            Object object = recipe[i + 1];
            ++i;
            if (object instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)object;
                builder.define(sign.charValue(), ingredient);
                continue;
            }
            if (object instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)object;
                builder.define(sign.charValue(), itemStack);
                continue;
            }
            if (object instanceof TagKey) {
                TagKey key = (TagKey)object;
                builder.define(sign.charValue(), (TagKey<Item>)key);
                continue;
            }
            if (object instanceof TagPrefix) {
                TagPrefix prefix = (TagPrefix)object;
                if (prefix.getItemParentTags().length <= 0) continue;
                builder.define(sign.charValue(), prefix.getItemParentTags()[0]);
                continue;
            }
            if (object instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)object;
                builder.define(sign.charValue(), itemLike);
                continue;
            }
            if (object instanceof MaterialEntry) {
                MaterialEntry entry = (MaterialEntry)object;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix(), entry.material());
                if (tag != null) {
                    builder.define(sign.charValue(), tag);
                    continue;
                }
                builder.define(sign.charValue(), ChemicalHelper.get(entry.tagPrefix(), entry.material()));
                continue;
            }
            if (!(object instanceof ItemProviderEntry)) continue;
            ItemProviderEntry entry = (ItemProviderEntry)object;
            builder.define(sign.charValue(), entry.asStack());
        }
        CharIterator it = foundTools.iterator();
        while (it.hasNext()) {
            char c = it.nextChar();
            builder.define(c, ToolHelper.getToolFromSymbol((char)c).itemTags.get(0));
        }
        builder.save(provider);
        if (setMaterialInfoData) {
            ItemMaterialData.registerMaterialInfo((ItemLike)result.m_41720_(), VanillaRecipeHelper.getRecyclingIngredients(result.m_41613_(), recipe));
        }
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, setMaterialInfoData, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, boolean setMaterialInfoData, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, setMaterialInfoData, false, regName, result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, GTCEu.id(regName), result, recipe);
    }

    public static void addShapedFluidContainerRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapedFluidContainerRecipe(provider, false, regName, result, recipe);
    }

    public static void addShapelessNBTClearingRecipe(Consumer<FinishedRecipe> provider, @NotNull String regName, @NotNull ItemStack result, Object ... recipe) {
        VanillaRecipeHelper.addShapelessRecipe(provider, regName, result, recipe);
    }

    public static void addShapelessRecipe(Consumer<FinishedRecipe> provider, @NotNull ResourceLocation regName, @NotNull ItemStack result, Object ... recipe) {
        ShapelessRecipeBuilder builder = new ShapelessRecipeBuilder(regName).output(result);
        for (Object content : recipe) {
            if (content instanceof Ingredient) {
                Ingredient ingredient = (Ingredient)content;
                builder.requires(ingredient);
                continue;
            }
            if (content instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)content;
                builder.requires(itemStack);
                continue;
            }
            if (content instanceof TagKey) {
                TagKey key = (TagKey)content;
                builder.requires((TagKey<Item>)key);
                continue;
            }
            if (content instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)content;
                builder.requires(itemLike);
                continue;
            }
            if (content instanceof MaterialEntry) {
                MaterialEntry entry = (MaterialEntry)content;
                TagKey<Item> tag = ChemicalHelper.getTag(entry.tagPrefix(), entry.material());
                if (tag != null) {
                    builder.requires(tag);
                    continue;
                }
                builder.requires(ChemicalHelper.get(entry.tagPrefix(), entry.material()));
                continue;
            }
            if (content instanceof ItemProviderEntry) {
                ItemProviderEntry entry = (ItemProviderEntry)content;
                builder.requires(entry.asStack());
                continue;
            }
            if (!(content instanceof Character)) continue;
            Character c = (Character)content;
            builder.requires(ToolHelper.getToolFromSymbol((char)c.charValue()).itemTags.get(0));
        }
        builder.save(provider);
    }

    public static boolean isMaterialWood(@NotNull Material material) {
        return !material.isNull() && material.hasProperty(PropertyKey.WOOD);
    }

    public static ItemMaterialInfo getRecyclingIngredients(int outputCount, Object ... recipe) {
        Object object;
        Char2IntOpenHashMap inputCountMap = new Char2IntOpenHashMap();
        Reference2LongOpenHashMap materialStacksExploded = new Reference2LongOpenHashMap();
        int itr = 0;
        while ((object = recipe[itr]) instanceof String) {
            String s = (String)object;
            object = s.toCharArray();
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Object c = object[i];
                if (ToolHelper.getToolFromSymbol((char)c) != null) continue;
                inputCountMap.addTo((char)c, 1);
            }
            ++itr;
        }
        char lastChar = ' ';
        for (int i = itr; i < recipe.length; ++i) {
            TagPrefix prefix;
            Item itemLike;
            Object ingredient = recipe[i];
            if (ingredient instanceof Character) {
                lastChar = ((Character)ingredient).charValue();
                continue;
            }
            if (lastChar == ' ') {
                return null;
            }
            if (ingredient instanceof Ingredient) {
                ItemStack stack;
                Ingredient ingr = (Ingredient)ingredient;
                ItemStack[] stacks = ingr.m_43908_();
                if (stacks.length == 0 || (stack = stacks[0]) == ItemStack.f_41583_) continue;
                itemLike = stack.m_41720_();
            } else if (ingredient instanceof ItemStack) {
                ItemStack itemStack = (ItemStack)ingredient;
                itemLike = itemStack.m_41720_();
            } else {
                if (ingredient instanceof TagKey) {
                    TagKey key = (TagKey)ingredient;
                    continue;
                }
                if (ingredient instanceof ItemLike) {
                    itemLike = (ItemLike)ingredient;
                } else if (ingredient instanceof MaterialEntry) {
                    MaterialEntry entry = (MaterialEntry)ingredient;
                    ItemStack stack = ChemicalHelper.get(entry.tagPrefix(), entry.material());
                    if (stack == ItemStack.f_41583_) continue;
                    itemLike = stack.m_41720_();
                } else {
                    if (!(ingredient instanceof ItemProviderEntry)) continue;
                    ItemProviderEntry entry = (ItemProviderEntry)ingredient;
                    itemLike = entry.m_5456_();
                }
            }
            ItemMaterialInfo info = ItemMaterialData.getMaterialInfo((ItemLike)itemLike);
            if (info != null) {
                for (MaterialStack ms : info.getMaterials()) {
                    if (ms.material() instanceof MarkerMaterial) continue;
                    VanillaRecipeHelper.addMaterialStack((Reference2LongOpenHashMap<Material>)materialStacksExploded, inputCountMap.get(lastChar), outputCount, ms);
                }
                continue;
            }
            MaterialStack materialStack = ChemicalHelper.getMaterialStack((ItemLike)itemLike);
            if (!materialStack.isEmpty() && !(materialStack.material() instanceof MarkerMaterial)) {
                VanillaRecipeHelper.addMaterialStack((Reference2LongOpenHashMap<Material>)materialStacksExploded, inputCountMap.get(lastChar), outputCount, materialStack);
            }
            if ((prefix = ChemicalHelper.getPrefix((ItemLike)itemLike)).isEmpty() || prefix.secondaryMaterials().isEmpty()) continue;
            for (MaterialStack ms : prefix.secondaryMaterials()) {
                VanillaRecipeHelper.addMaterialStack((Reference2LongOpenHashMap<Material>)materialStacksExploded, inputCountMap.get(lastChar), outputCount, ms);
            }
        }
        return new ItemMaterialInfo((Reference2LongMap<Material>)materialStacksExploded);
    }

    private static void addMaterialStack(@NotNull Reference2LongOpenHashMap<Material> materialStacksExploded, int inputCount, int outputCount, @NotNull MaterialStack ms) {
        materialStacksExploded.addTo((Object)ms.material(), ms.amount() * (long)inputCount / (long)outputCount);
    }
}

