/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.gui.widget;

import appeng.api.stacks.GenericStack;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.ConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.slot.IConfigurableSlot;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.TextFieldWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class AmountSetWidget
extends Widget {
    private int index = -1;
    private final TextFieldWidget amountText;
    private final ConfigWidget parentWidget;

    public AmountSetWidget(int x, int y, ConfigWidget widget) {
        super(x, y, 80, 30);
        this.parentWidget = widget;
        this.amountText = new TextFieldWidget(x + 3, y + 12, 65, 13, this::getAmountStr, this::setNewAmount).setNumbersOnly(0, Integer.MAX_VALUE).setMaxStringLength(10);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSlotIndexClient(int slotIndex) {
        this.index = slotIndex;
        this.writeClientAction(0, buf -> buf.m_130130_(this.index));
    }

    public void setSlotIndex(int slotIndex) {
        this.index = slotIndex;
    }

    public String getAmountStr() {
        if (this.index < 0) {
            return "0";
        }
        IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
        if (slot.getConfig() != null) {
            return String.valueOf(slot.getConfig().amount());
        }
        return "0";
    }

    public void setNewAmount(String amount) {
        try {
            long newAmount = Long.parseLong(amount);
            if (this.index < 0) {
                return;
            }
            IConfigurableSlot slot = this.parentWidget.getConfig(this.index);
            if (newAmount > 0L && slot.getConfig() != null) {
                slot.setConfig(new GenericStack(slot.getConfig().what(), newAmount));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        super.handleClientAction(id, buffer);
        if (id == 0) {
            this.index = buffer.m_130242_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        Position position = this.getPosition();
        GuiTextures.BACKGROUND.draw(graphics, mouseX, mouseY, (float)position.x, (float)position.y, 80, 30);
        DrawerHelper.drawStringSized((GuiGraphics)graphics, (String)"Amount", (float)(position.x + 3), (float)(position.y + 3), (int)0x404040, (boolean)false, (float)1.0f, (boolean)false);
        GuiTextures.DISPLAY.draw(graphics, mouseX, mouseY, (float)(position.x + 3), (float)(position.y + 11), 65, 14);
    }

    @Generated
    public TextFieldWidget getAmountText() {
        return this.amountText;
    }
}

