/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.commons.lang3.StringUtils;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class AutoOutputBlockProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        BlockEntity be = blockAccessor.getBlockEntity();
        if (be != null) {
            CompoundTag tag;
            CompoundTag data = blockAccessor.getServerData().m_128469_(this.getUid().toString());
            if (data.m_128425_("autoOutputItem", 10)) {
                tag = data.m_128469_("autoOutputItem");
                this.addAutoOutputInfo(iTooltip, blockAccessor, tag, "gtceu.top.item_auto_output");
            }
            if (data.m_128425_("autoOutputFluid", 10)) {
                tag = data.m_128469_("autoOutputFluid");
                this.addAutoOutputInfo(iTooltip, blockAccessor, tag, "gtceu.top.fluid_auto_output");
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        IAutoOutputFluid outputFluid;
        IAutoOutputItem outputItem;
        MetaMachine direction;
        BlockPos pos;
        CompoundTag data = compoundTag.m_128469_(this.getUid().toString());
        Level level = blockAccessor.getLevel();
        MetaMachine metaMachine = MetaMachine.getMachine((BlockGetter)level, pos = blockAccessor.getPosition());
        if (metaMachine instanceof IAutoOutputItem && (direction = (outputItem = (IAutoOutputItem)((Object)metaMachine)).getOutputFacingItems()) != null) {
            data.m_128365_("autoOutputItem", (Tag)this.writeData(new CompoundTag(), (Direction)direction, blockAccessor, outputItem.isAllowInputFromOutputSideItems(), outputItem.isAutoOutputItems()));
        }
        if ((direction = MetaMachine.getMachine((BlockGetter)level, pos)) instanceof IAutoOutputFluid && (direction = (outputFluid = (IAutoOutputFluid)((Object)direction)).getOutputFacingFluids()) != null) {
            data.m_128365_("autoOutputFluid", (Tag)this.writeData(new CompoundTag(), (Direction)direction, blockAccessor, outputFluid.isAllowInputFromOutputSideFluids(), outputFluid.isAutoOutputFluids()));
        }
        compoundTag.m_128365_(this.getUid().toString(), (Tag)data);
    }

    public ResourceLocation getUid() {
        return GTCEu.id("auto_output_info");
    }

    private CompoundTag writeData(CompoundTag compoundTag, Direction direction, BlockAccessor blockAccessor, boolean allowInput, boolean auto) {
        compoundTag.m_128359_("direction", direction.m_122433_());
        Level level = blockAccessor.getLevel();
        BlockPos pos = blockAccessor.getPosition().m_121945_(direction);
        if (level != null) {
            ResourceLocation key = BuiltInRegistries.f_256975_.m_7981_((Object)level.m_8055_(pos).m_60734_());
            compoundTag.m_128359_("block", key.toString());
        }
        compoundTag.m_128379_("allowInput", allowInput);
        compoundTag.m_128379_("auto", auto);
        return compoundTag;
    }

    private void addAutoOutputInfo(ITooltip iTooltip, BlockAccessor blockAccessor, CompoundTag compoundTag, String text) {
        Direction direction = Direction.m_122402_((String)compoundTag.m_128461_("direction"));
        boolean allowInput = compoundTag.m_128471_("allowInput");
        boolean auto = compoundTag.m_128471_("auto");
        if (direction != null) {
            ItemStack block;
            iTooltip.add((Component)Component.m_237110_((String)text, (Object[])new Object[]{StringUtils.capitalize((String)direction.m_122433_())}));
            if (blockAccessor.showDetails() && !(block = ((Block)BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(compoundTag.m_128461_("block")))).m_5456_().m_7968_()).m_41619_()) {
                iTooltip.append(iTooltip.getElementHelper().smallItem(block));
            }
            if (allowInput || auto) {
                MutableComponent component = Component.m_237113_((String)" (");
                if (auto) {
                    component.m_7220_((Component)Component.m_237115_((String)"gtceu.top.auto_output"));
                }
                if (allowInput && auto) {
                    component.m_130946_("/");
                }
                if (allowInput) {
                    component.m_7220_((Component)Component.m_237115_((String)"gtceu.top.allow_output_input"));
                }
                component.m_130946_(")");
                iTooltip.append((Component)component);
            }
        }
    }
}

