/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.blockentity.CableBlockEntity;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class CableBlockProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        CompoundTag data;
        BlockEntity be = blockAccessor.getBlockEntity();
        if (be != null && (data = blockAccessor.getServerData().m_128469_(this.getUid().toString())).m_128425_("cableData", 10)) {
            CompoundTag tag = data.m_128469_("cableData");
            long voltage = tag.m_128454_("currentVoltage");
            double amperage = tag.m_128459_("currentAmperage");
            iTooltip.add((Component)Component.m_237115_((String)"gtceu.top.cable_voltage"));
            if (voltage != 0L) {
                iTooltip.append((Component)Component.m_237113_((String)GTValues.VNF[GTUtil.getTierByVoltage(voltage)]));
                iTooltip.append((Component)Component.m_237113_((String)" / "));
            }
            iTooltip.append((Component)Component.m_237113_((String)GTValues.VNF[GTUtil.getTierByVoltage(tag.m_128454_("maxVoltage"))]));
            iTooltip.add((Component)Component.m_237115_((String)"gtceu.top.cable_amperage"));
            if (amperage != 0.0) {
                iTooltip.append((Component)Component.m_237113_((String)(FormattingUtil.DECIMAL_FORMAT_1F.format(amperage) + "A / ")));
            }
            iTooltip.append((Component)Component.m_237113_((String)(FormattingUtil.DECIMAL_FORMAT_1F.format(tag.m_128459_("maxAmperage")) + "A")));
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        CableBlock cableBlock;
        CableBlockEntity cable;
        CompoundTag data = compoundTag.m_128469_(this.getUid().toString());
        Block block = blockAccessor.getBlock();
        if (block instanceof CableBlock && (cable = (CableBlockEntity)(cableBlock = (CableBlock)block).getPipeTile((BlockGetter)blockAccessor.getLevel(), blockAccessor.getPosition())) != null) {
            CompoundTag cableData = new CompoundTag();
            cableData.m_128356_("maxVoltage", cable.getMaxVoltage());
            cableData.m_128356_("currentVoltage", cable.getCurrentMaxVoltage());
            cableData.m_128347_("maxAmperage", (double)cable.getMaxAmperage());
            cableData.m_128347_("currentAmperage", cable.getAverageAmperage());
            data.m_128365_("cableData", (Tag)cableData);
        }
        compoundTag.m_128365_(this.getUid().toString(), (Tag)data);
    }

    public ResourceLocation getUid() {
        return GTCEu.id("cable_info");
    }
}

