/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import com.gregtechceu.gtceu.common.blockentity.FluidPipeBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.Accessor;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;

public enum FluidPipeStorageProvider implements IServerExtensionProvider<FluidPipeBlockEntity, CompoundTag>,
IClientExtensionProvider<CompoundTag, FluidView>
{
    INSTANCE;


    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<CompoundTag>> groups) {
        return ClientViewGroup.map(groups, FluidView::readDefault, (group, clientGroup) -> {
            if (group.id != null) {
                clientGroup.title = Component.m_237113_((String)group.id);
            }
            clientGroup.bgColor = 0x55666666;
        });
    }

    @Nullable
    public List<ViewGroup<CompoundTag>> getGroups(ServerPlayer serverPlayer, ServerLevel serverLevel, FluidPipeBlockEntity pipe, boolean showDetails) {
        ArrayList<ViewGroup<CompoundTag>> tanks = new ArrayList<ViewGroup<CompoundTag>>();
        for (CustomFluidTank tank : pipe.getFluidTanks()) {
            if (tank.getFluidAmount() <= 0) continue;
            tanks.add((ViewGroup<CompoundTag>)new ViewGroup(List.of(FluidView.writeDefault((JadeFluidObject)JadeFluidObject.of((Fluid)tank.getFluid().getFluid(), (long)tank.getFluidAmount()), (long)tank.getCapacity()))));
        }
        return tanks;
    }

    public ResourceLocation getUid() {
        return GTCEu.id("fluid_storage");
    }
}

