/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.util.TooltipHelper;
import com.gregtechceu.gtceu.integration.ae2.machine.MEPatternBufferPartMachine;
import com.gregtechceu.gtceu.integration.jade.GTElementHelper;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.ui.IElementHelper;

public class MEPatternBufferProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        IMachineBlockEntity blockEntity;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine() instanceof MEPatternBufferPartMachine) {
            CompoundTag serverData = blockAccessor.getServerData();
            if (!serverData.m_128471_("formed")) {
                return;
            }
            iTooltip.add((Component)Component.m_237110_((String)"gtceu.top.proxies_bound", (Object[])new Object[]{serverData.m_128451_("proxies")}).m_130938_(TooltipHelper.RAINBOW_HSL_SLOW));
            MEPatternBufferProvider.readBufferTag(iTooltip, serverData);
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        IMachineBlockEntity blockEntity;
        MetaMachine metaMachine;
        BlockEntity blockEntity2 = blockAccessor.getBlockEntity();
        if (blockEntity2 instanceof IMachineBlockEntity && (metaMachine = (blockEntity = (IMachineBlockEntity)blockEntity2).getMetaMachine()) instanceof MEPatternBufferPartMachine) {
            MEPatternBufferPartMachine buffer = (MEPatternBufferPartMachine)metaMachine;
            if (!buffer.isFormed()) {
                compoundTag.m_128379_("formed", false);
                return;
            }
            compoundTag.m_128379_("formed", true);
            compoundTag.m_128405_("proxies", buffer.getProxies().size());
            MEPatternBufferProvider.writeBufferTag(compoundTag, buffer);
        }
    }

    public ResourceLocation getUid() {
        return GTCEu.id("me_pattern_buffer");
    }

    public static void writeBufferTag(CompoundTag compoundTag, MEPatternBufferPartMachine buffer) {
        MEPatternBufferPartMachine.BufferData merged = buffer.mergeInternalSlots();
        Object2LongMap<ItemStack> items = merged.items();
        Object2LongMap<FluidStack> fluids = merged.fluids();
        ListTag itemsTag = new ListTag();
        for (Object2LongMap.Entry entry : items.object2LongEntrySet()) {
            CompoundTag ct = ((ItemStack)entry.getKey()).serializeNBT();
            ct.m_128356_("real", entry.getLongValue());
            itemsTag.add((Object)ct);
        }
        if (!itemsTag.isEmpty()) {
            compoundTag.m_128365_("items", (Tag)itemsTag);
        }
        ListTag fluidsTag = new ListTag();
        for (Object2LongMap.Entry entry : fluids.object2LongEntrySet()) {
            CompoundTag ct = ((FluidStack)entry.getKey()).writeToNBT(new CompoundTag());
            ct.m_128356_("real", entry.getLongValue());
            fluidsTag.add((Object)ct);
        }
        if (!fluidsTag.isEmpty()) {
            compoundTag.m_128365_("fluids", (Tag)fluidsTag);
        }
    }

    public static void readBufferTag(ITooltip iTooltip, CompoundTag serverData) {
        IElementHelper helper = iTooltip.getElementHelper();
        ListTag itemsTag = serverData.m_128437_("items", 10);
        for (Tag t : itemsTag) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag ct = (CompoundTag)t;
            ItemStack stack = ItemStack.m_41712_((CompoundTag)ct);
            long count = ct.m_128454_("real");
            if (stack.m_41619_() || count <= 0L) continue;
            iTooltip.add(helper.smallItem(stack));
            MutableComponent text = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatNumbers(count)).m_130940_(ChatFormatting.DARK_PURPLE)).m_7220_((Component)Component.m_237113_((String)"\u00d7 ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)stack.m_41786_().m_6881_().m_130940_(ChatFormatting.GOLD));
            iTooltip.append((Component)text);
        }
        ListTag fluidsTag = serverData.m_128437_("fluids", 10);
        for (Tag t : fluidsTag) {
            if (!(t instanceof CompoundTag)) continue;
            CompoundTag ct = (CompoundTag)t;
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)ct);
            long amount = ct.m_128454_("real");
            if (stack.isEmpty() || amount <= 0L) continue;
            iTooltip.add(GTElementHelper.smallFluid(JadeFluidObject.of((Fluid)stack.getFluid())));
            MutableComponent text = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237113_((String)FormattingUtil.formatBuckets(amount))).m_130940_(ChatFormatting.DARK_PURPLE).m_7220_((Component)Component.m_237113_((String)" ").m_130940_(ChatFormatting.WHITE)).m_7220_((Component)stack.getDisplayName().m_6881_().m_130940_(ChatFormatting.DARK_AQUA));
            iTooltip.append((Component)text);
        }
    }
}

