/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jade.provider;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class ParallelProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (blockAccessor.getServerData().m_128441_("parallel")) {
            int parallel = blockAccessor.getServerData().m_128451_("parallel");
            if (!blockAccessor.getServerData().m_128471_("exact") && parallel > 1) {
                MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers(parallel)).m_130940_(ChatFormatting.DARK_PURPLE);
                String key = "gtceu.multiblock.parallel";
                iTooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{parallels}));
            } else {
                int subtickParallel;
                int batch = blockAccessor.getServerData().m_128451_("batch");
                int totalRuns = parallel * batch * (subtickParallel = blockAccessor.getServerData().m_128451_("subtickParallel"));
                if (totalRuns == 1) {
                    return;
                }
                MutableComponent runs = Component.m_237113_((String)FormattingUtil.formatNumbers(totalRuns)).m_130940_(ChatFormatting.DARK_PURPLE);
                String key = "gtceu.multiblock.total_runs";
                iTooltip.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{runs}));
                if (parallel > 1) {
                    MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers(parallel)).m_130940_(ChatFormatting.DARK_PURPLE);
                    String keyParallel = "gtceu.multiblock.parallel.exact";
                    iTooltip.add((Component)Component.m_237110_((String)keyParallel, (Object[])new Object[]{parallels}));
                }
                if (batch > 1) {
                    MutableComponent batches = Component.m_237113_((String)FormattingUtil.formatNumbers(batch)).m_130940_(ChatFormatting.DARK_PURPLE);
                    String keyBatch = "gtceu.multiblock.batch_enabled";
                    iTooltip.add((Component)Component.m_237110_((String)keyBatch, (Object[])new Object[]{batches}));
                }
                if (subtickParallel > 1) {
                    MutableComponent subticks = Component.m_237113_((String)FormattingUtil.formatNumbers(subtickParallel)).m_130940_(ChatFormatting.DARK_PURPLE);
                    String keySubtick = "gtceu.multiblock.subtick_parallels";
                    iTooltip.add((Component)Component.m_237110_((String)keySubtick, (Object[])new Object[]{subticks}));
                }
            }
        }
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof MetaMachineBlockEntity) {
            MetaMachineBlockEntity blockEntity2 = (MetaMachineBlockEntity)blockEntity;
            MetaMachine metaMachine = blockEntity2.getMetaMachine();
            if (metaMachine instanceof IParallelHatch) {
                IParallelHatch parallelHatch2 = (IParallelHatch)((Object)metaMachine);
                compoundTag.m_128405_("parallel", parallelHatch2.getCurrentParallel());
            } else {
                metaMachine = blockEntity2.getMetaMachine();
                if (metaMachine instanceof IMultiController) {
                    IRecipeLogicMachine rlm;
                    IMultiController controller = (IMultiController)((Object)metaMachine);
                    if (controller instanceof IRecipeLogicMachine && (rlm = (IRecipeLogicMachine)((Object)controller)).getRecipeLogic().isActive() && rlm.getRecipeLogic().getLastRecipe() != null) {
                        compoundTag.m_128405_("parallel", rlm.getRecipeLogic().getLastRecipe().parallels);
                        compoundTag.m_128405_("batch", rlm.getRecipeLogic().getLastRecipe().batchParallels);
                        compoundTag.m_128405_("subtickParallel", rlm.getRecipeLogic().getLastRecipe().subtickParallels);
                        compoundTag.m_128379_("exact", true);
                    } else {
                        controller.getParallelHatch().ifPresent(parallelHatch -> compoundTag.m_128405_("parallel", parallelHatch.getCurrentParallel()));
                    }
                }
            }
        }
    }

    public ResourceLocation getUid() {
        return GTCEu.id("parallel_info");
    }
}

