/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.events;

import com.gregtechceu.gtceu.api.cosmetics.event.RegisterGTCapesEvent;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;

@Info(value="Invoked when the server is first loaded.\n")
public class RegisterCapesEventJS
extends EventJS {
    private final RegisterGTCapesEvent event;

    public RegisterCapesEventJS(RegisterGTCapesEvent event) {
        this.event = event;
    }

    @Info(value="Registers a cape.\n", params={@Param(name="id", value="An identifier for the cape"), @Param(name="texture", value="The full path to the cape's texture in a resource pack")})
    public void registerCape(ResourceLocation id, ResourceLocation texture) {
        this.event.registerCape(id, texture);
    }

    @Info(value="Registers a cape that will always be unlocked for all players.\n", params={@Param(name="id", value="An identifier for the cape"), @Param(name="texture", value="The full path to the cape's texture in a resource pack")})
    public void registerFreeCape(ResourceLocation id, ResourceLocation texture) {
        this.event.registerFreeCape(id, texture);
    }

    @Info(value="Automatically makes a cape available to a player.\n", params={@Param(name="owner", value="The UUID of the player to give the cape to."), @Param(name="capeId", value="The cape to give")})
    public void unlockCapeFor(UUID owner, ResourceLocation capeId) {
        this.event.unlockCapeFor(owner, capeId);
    }
}

