/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import it.unimi.dsi.fastutil.longs.LongLongPair;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class KJSHelpers {
    public static final Pattern VALUE_REGEX = Pattern.compile("^(?<v>[+-]?\\d+)V?\\s*(?:@|x|\\*)?\\s*?(?<a>\\+?[1-9]\\d*)A?$", 2);
    private static final Set<String> VOLTAGE_KEYS = Set.of("voltage", "v", "V", "eu", "EU", "");
    private static final Set<String> AMPERAGE_KEYS = Set.of("amperage", "a", "A");
    private static final long DEFAULT_VOLTAGE = 0L;
    private static final long DEFAULT_AMPERAGE = 1L;

    public static EnergyStack.WithIO parseIOEnergyStack(Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o instanceof EnergyStack.WithIO) {
            EnergyStack.WithIO stack = (EnergyStack.WithIO)o;
            return stack;
        }
        if (o instanceof EnergyStack) {
            EnergyStack stack = (EnergyStack)o;
            return new EnergyStack.WithIO(stack, IO.IN);
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            long value = n.longValue();
            return EnergyStack.WithIO.fromVoltage(value);
        }
        LongLongPair pair = KJSHelpers.parseEnergyStackValues(o);
        if (pair == null) {
            return EnergyStack.WithIO.EMPTY;
        }
        return EnergyStack.WithIO.fromVA(pair.firstLong(), pair.secondLong());
    }

    public static EnergyStack parseEnergyStack(Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o instanceof EnergyStack) {
            EnergyStack stack = (EnergyStack)o;
            return stack;
        }
        if (o instanceof EnergyStack.WithIO) {
            EnergyStack.WithIO stack = (EnergyStack.WithIO)o;
            return stack.stack();
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return new EnergyStack(n.longValue());
        }
        LongLongPair pair = KJSHelpers.parseEnergyStackValues(o);
        if (pair == null) {
            return EnergyStack.EMPTY;
        }
        return new EnergyStack(Math.abs(pair.firstLong()), Math.abs(pair.secondLong()));
    }

    @Nullable
    private static LongLongPair parseEnergyStackValues(Object o) {
        long amperage;
        long voltage;
        block5: {
            block4: {
                voltage = 0L;
                amperage = 1L;
                if (!(o instanceof CharSequence)) break block4;
                String s = o.toString();
                Matcher match = VALUE_REGEX.matcher(s);
                if (!match.matches()) {
                    return null;
                }
                voltage = Long.parseLong(match.group("v"));
                if (match.group("a") == null) break block5;
                amperage = Long.parseLong(match.group("a"));
                break block5;
            }
            Map map = MapJS.of((Object)o);
            if (map == null) {
                return null;
            }
            for (String key : VOLTAGE_KEYS) {
                if (map.containsKey(key) && (voltage = UtilsJS.parseLong(map.get(key), (long)0L)) != 0L) break;
            }
            for (String key : AMPERAGE_KEYS) {
                if (map.containsKey(key) && (amperage = UtilsJS.parseLong(map.get(key), (long)1L)) != 1L) break;
            }
        }
        return LongLongPair.of((long)voltage, (long)amperage);
    }
}

