/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.worldgen.ores.GeneratedVeinMetadata;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.integration.map.GenericMapRenderer;
import com.gregtechceu.gtceu.integration.map.ftbchunks.FTBChunksRenderer;
import com.gregtechceu.gtceu.integration.map.journeymap.JourneymapRenderer;
import com.gregtechceu.gtceu.integration.map.xaeros.XaerosRenderer;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class GroupingMapRenderer
extends GenericMapRenderer {
    private static final GroupingMapRenderer instance;
    private final Map<String, GenericMapRenderer> renderers;
    private final GenericMapRenderer[] rendererList;

    public GroupingMapRenderer(Map<String, GenericMapRenderer> renderers) {
        super(false);
        this.renderers = renderers;
        this.rendererList = (GenericMapRenderer[])renderers.values().toArray(GenericMapRenderer[]::new);
    }

    @Override
    public boolean addMarker(String name, String id, ResourceKey<Level> dim, ChunkPos pos, ProspectorMode.FluidInfo fluid) {
        boolean value = false;
        for (GenericMapRenderer renderer : this.rendererList) {
            value |= renderer.addMarker(name, id, dim, pos, fluid);
        }
        return value;
    }

    @Override
    public boolean addMarker(String name, ResourceKey<Level> dim, GeneratedVeinMetadata vein, String id) {
        boolean value = false;
        for (GenericMapRenderer renderer : this.rendererList) {
            value |= renderer.addMarker(name, dim, vein, id);
        }
        return value;
    }

    @Override
    public boolean removeMarker(ResourceKey<Level> dim, String id) {
        boolean value = false;
        for (GenericMapRenderer renderer : this.rendererList) {
            value |= renderer.removeMarker(dim, id);
        }
        return value;
    }

    @Override
    public boolean doShowLayer(String name) {
        boolean value = false;
        for (GenericMapRenderer renderer : this.rendererList) {
            value |= renderer.doShowLayer(name);
        }
        return value;
    }

    @Override
    public void setLayerActive(String name, boolean active) {
        for (GenericMapRenderer renderer : this.rendererList) {
            renderer.setLayerActive(name, active);
        }
    }

    @Override
    public void clear() {
        for (GenericMapRenderer renderer : this.rendererList) {
            renderer.clear();
        }
    }

    @Generated
    public static GroupingMapRenderer getInstance() {
        return instance;
    }

    @Generated
    public Map<String, GenericMapRenderer> getRenderers() {
        return this.renderers;
    }

    static {
        HashMap<String, GenericMapRenderer> renderers = new HashMap<String, GenericMapRenderer>();
        ConfigHolder.CompatibilityConfigs.MinimapCompatConfig.Toggle toggle = ConfigHolder.INSTANCE.compat.minimap.toggle;
        if (toggle.journeyMapIntegration && GTCEu.isModLoaded("journeymap")) {
            renderers.put("journeymap", new JourneymapRenderer());
        }
        if (toggle.xaerosMapIntegration && GTCEu.isModLoaded("xaerominimap")) {
            renderers.put("xaerominimap", new XaerosRenderer());
        }
        if (toggle.ftbChunksIntegration && GTCEu.isModLoaded("ftbchunks")) {
            renderers.put("ftbchunks", new FTBChunksRenderer());
        }
        instance = new GroupingMapRenderer(renderers);
    }
}

