/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.cache.fluid;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import com.gregtechceu.gtceu.integration.map.layer.builtin.FluidRenderLayer;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class FluidCache {
    private final Table<ResourceKey<Level>, ChunkPos, ProspectorMode.FluidInfo> fluidCache = HashBasedTable.create();

    public void addFluid(ResourceKey<Level> dim, int chunkX, int chunkZ, ProspectorMode.FluidInfo fluid) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        if (!this.fluidCache.contains(dim, (Object)pos)) {
            this.fluidCache.put(dim, (Object)pos, (Object)fluid);
            GroupingMapRenderer.getInstance().addMarker(FluidRenderLayer.getName(fluid).getString(), FluidRenderLayer.getId(fluid, pos), dim, pos, fluid);
        }
    }

    public void fromNbt(CompoundTag nbt) {
        ListTag fluidList = nbt.m_128437_("fluids", 10);
        for (Tag fluidTagRaw : fluidList) {
            if (!(fluidTagRaw instanceof CompoundTag)) continue;
            CompoundTag fluidTag = (CompoundTag)fluidTagRaw;
            ResourceKey dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(fluidTag.m_128461_("dim")));
            ChunkPos pos = new ChunkPos(fluidTag.m_128454_("pos"));
            ProspectorMode.FluidInfo fluid = ProspectorMode.FluidInfo.fromNbt(fluidTag);
            this.fluidCache.put((Object)dim, (Object)pos, (Object)fluid);
            GroupingMapRenderer.getInstance().addMarker(FluidRenderLayer.getName(fluid).getString(), FluidRenderLayer.getId(fluid, pos), (ResourceKey<Level>)dim, pos, fluid);
        }
    }

    public CompoundTag toNbt() {
        CompoundTag result = new CompoundTag();
        ListTag fluidList = new ListTag();
        for (Map.Entry dimensions : this.fluidCache.rowMap().entrySet()) {
            for (Map.Entry entry : ((Map)dimensions.getValue()).entrySet()) {
                CompoundTag tag = ((ProspectorMode.FluidInfo)entry.getValue()).toNbt();
                tag.m_128356_("pos", ((ChunkPos)entry.getKey()).m_45588_());
                tag.m_128359_("dim", ((ResourceKey)dimensions.getKey()).m_135782_().toString());
                fluidList.add((Object)tag);
            }
        }
        result.m_128365_("fluids", (Tag)fluidList);
        return result;
    }

    public void clear() {
        this.fluidCache.clear();
    }
}

