/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.map.xaeros.worldmap.fluid;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.gui.misc.ProspectorMode;
import com.gregtechceu.gtceu.integration.map.GroupingMapRenderer;
import com.gregtechceu.gtceu.integration.map.layer.builtin.FluidRenderLayer;
import com.gregtechceu.gtceu.integration.map.xaeros.XaerosRenderer;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import xaero.map.highlight.ChunkHighlighter;

public class FluidChunkHighlighter
extends ChunkHighlighter {
    private static final int FILL_OPACITY = 25;
    private static final int BORDER_OPACITY = 50;

    public FluidChunkHighlighter() {
        super(false);
    }

    private boolean isEnabled() {
        return GroupingMapRenderer.getInstance().doShowLayer("bedrock_fluids");
    }

    public boolean regionHasHighlights(ResourceKey<Level> dimension, int regionX, int regionZ) {
        return this.isEnabled();
    }

    protected int[] getColors(ResourceKey<Level> dimension, int chunkX, int chunkZ) {
        if (!this.isEnabled()) {
            return null;
        }
        Map dimensionMap = XaerosRenderer.fluidElements.row(dimension);
        ProspectorMode.FluidInfo vein = (ProspectorMode.FluidInfo)dimensionMap.get(new ChunkPos(chunkX, chunkZ));
        if (vein == null) {
            return null;
        }
        ProspectorMode.FluidInfo topFluid = (ProspectorMode.FluidInfo)dimensionMap.get(new ChunkPos(chunkX, chunkZ - 1));
        ProspectorMode.FluidInfo rightFluid = (ProspectorMode.FluidInfo)dimensionMap.get(new ChunkPos(chunkX + 1, chunkZ));
        ProspectorMode.FluidInfo bottomFluid = (ProspectorMode.FluidInfo)dimensionMap.get(new ChunkPos(chunkX, chunkZ + 1));
        ProspectorMode.FluidInfo leftFluid = (ProspectorMode.FluidInfo)dimensionMap.get(new ChunkPos(chunkX - 1, chunkZ));
        int color = IClientFluidTypeExtensions.of((Fluid)vein.fluid()).getTintColor();
        Material material = ChemicalHelper.getMaterial(vein.fluid());
        if (!material.isNull()) {
            color = material.getMaterialARGB();
        }
        color = (color & 0xFF) << 24 | (color >> 8 & 0xFF) << 16 | (color >> 16 & 0xFF) << 8;
        int centerColor = color | 0x3F;
        int sideColor = color | 0x7F;
        this.resultStore[0] = centerColor;
        this.resultStore[1] = topFluid == null ? sideColor : centerColor;
        this.resultStore[2] = rightFluid == null ? sideColor : centerColor;
        this.resultStore[3] = bottomFluid == null ? sideColor : centerColor;
        this.resultStore[4] = leftFluid == null ? sideColor : centerColor;
        return this.resultStore;
    }

    public int calculateRegionHash(ResourceKey<Level> dimension, int regionX, int regionZ) {
        if (!this.isEnabled()) {
            return 0;
        }
        long accumulator = 25L;
        for (int x = regionX << 5; x < regionX + 1 << 5; ++x) {
            for (int z = regionZ << 5; z < regionZ + 1 << 5; ++z) {
                ProspectorMode.FluidInfo fluid = (ProspectorMode.FluidInfo)XaerosRenderer.fluidElements.get(dimension, (Object)new ChunkPos(x, z));
                if (fluid == null) {
                    accumulator *= 37L;
                    accumulator = accumulator * 37L + (long)x;
                    accumulator = accumulator * 37L + (long)z;
                    continue;
                }
                accumulator += (long)BuiltInRegistries.f_257020_.m_7447_((Object)fluid.fluid());
                accumulator *= 37L;
                accumulator += (long)fluid.yield();
                accumulator *= 37L;
                accumulator = accumulator * 37L + (long)x;
                accumulator = accumulator * 37L + (long)z;
            }
        }
        accumulator = accumulator * 37L + 50L;
        return (int)(accumulator >> 32) * 37 + (int)accumulator;
    }

    public boolean chunkIsHighlit(ResourceKey<Level> dimension, int chunkX, int chunkZ) {
        return this.isEnabled() && XaerosRenderer.fluidElements.get(dimension, (Object)new ChunkPos(chunkX, chunkZ)) != null;
    }

    public Component getChunkHighlightSubtleTooltip(ResourceKey<Level> dimension, int x, int z) {
        return null;
    }

    public Component getChunkHighlightBluntTooltip(ResourceKey<Level> dimension, int x, int z) {
        if (!this.isEnabled()) {
            return null;
        }
        ProspectorMode.FluidInfo fluid = (ProspectorMode.FluidInfo)XaerosRenderer.fluidElements.get(dimension, (Object)new ChunkPos(x, z));
        if (fluid == null) {
            return null;
        }
        return (Component)FluidRenderLayer.getTooltip(fluid).stream().reduce(Component.m_237119_(), (c1, c2) -> {
            if (c1.getString().isEmpty()) {
                return c2;
            }
            if (c2.getString().isEmpty()) {
                return c1;
            }
            return ((MutableComponent)c1).m_130946_("\n").m_7220_(c2);
        });
    }

    public void addMinimapBlockHighlightTooltips(List<Component> list, ResourceKey<Level> dimension, int blockX, int blockZ, int width) {
    }
}

