/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.xei.handlers.fluid;

import com.gregtechceu.gtceu.api.transfer.fluid.IFluidHandlerModifiable;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;

public class CycleFluidStackHandler
implements IFluidHandlerModifiable {
    private final List<FluidStackList> stacks = new ArrayList<FluidStackList>();

    public CycleFluidStackHandler(List<List<FluidStack>> stacks) {
        for (List<FluidStack> list : stacks) {
            this.stacks.add(FluidStackList.of(list));
        }
    }

    public int getTanks() {
        return this.stacks.size();
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        List<FluidStack> stackList = this.stacks.get(tank).getStacks();
        return stackList != null && !stackList.isEmpty() ? stackList.get(Math.abs((int)(System.currentTimeMillis() / 1000L) % stackList.size())) : FluidStack.EMPTY;
    }

    @Override
    public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
        if (tank >= 0 && tank < this.stacks.size()) {
            this.stacks.set(tank, FluidStackList.of(fluidStack));
        }
    }

    public int getTankCapacity(int tank) {
        return this.getFluidInTank(tank).getAmount();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    @Override
    public boolean supportsFill(int tank) {
        return false;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return FluidStack.EMPTY;
    }

    @Override
    public boolean supportsDrain(int tank) {
        return false;
    }

    public FluidStackList getStackList(int i) {
        return this.stacks.get(i);
    }
}

