/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTMath {
    public static long clamp(long value, long min, long max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int lerpInt(double delta, int start, int end) {
        return start + Mth.m_14107_((double)(delta * (double)(end - start)));
    }

    public static List<ItemStack> splitStacks(ItemStack stack, long amount) {
        int fullStacks = (int)(amount / Integer.MAX_VALUE);
        int rem = (int)(amount % Integer.MAX_VALUE);
        ObjectArrayList stacks = new ObjectArrayList(fullStacks + 1);
        if (fullStacks > 0) {
            stacks.addAll(Collections.nCopies(fullStacks, stack.m_255036_(Integer.MAX_VALUE)));
        }
        if (rem > 0) {
            stacks.add(stack.m_255036_(rem));
        }
        return stacks;
    }

    public static List<FluidStack> splitFluidStacks(FluidStack stack, long amount) {
        FluidStack copy;
        int fullStacks = (int)(amount / Integer.MAX_VALUE);
        int rem = (int)(amount % Integer.MAX_VALUE);
        ObjectArrayList stacks = new ObjectArrayList(fullStacks + 1);
        if (fullStacks > 0) {
            copy = stack.copy();
            copy.setAmount(Integer.MAX_VALUE);
            stacks.addAll(Collections.nCopies(fullStacks, copy));
        }
        if (rem > 0) {
            copy = stack.copy();
            copy.setAmount(rem);
            stacks.add(copy);
        }
        return stacks;
    }

    public static int[] split(long value) {
        IntArrayList result = new IntArrayList();
        while (value > 0L) {
            int intValue = (int)Math.min(value, Integer.MAX_VALUE);
            result.add(intValue);
            value -= (long)intValue;
        }
        return result.toIntArray();
    }

    public static int saturatedCast(long value) {
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return value < Integer.MIN_VALUE ? Integer.MIN_VALUE : (int)value;
    }

    public static int hashInts(int ... vals) {
        return Arrays.hashCode(vals);
    }

    public static int hashLongs(long ... vals) {
        return Arrays.hashCode(vals);
    }

    public static float ratio(BigInteger a, BigInteger b) {
        return new BigDecimal(a).divide(new BigDecimal(b), MathContext.DECIMAL32).floatValue();
    }

    public static int ceilDiv(int x, int y) {
        int q = x / y;
        if ((x ^ y) >= 0 && q * y != x) {
            return q + 1;
        }
        return q;
    }
}

