/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.security.InvalidParameterException;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.Contract;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GTMatrixUtils {
    private static final ImmutableMap<Direction, Vector3fc> directionAxises = (ImmutableMap)Util.m_137537_(() -> {
        ImmutableMap.Builder map = ImmutableMap.builderWithExpectedSize((int)6);
        for (Direction dir : GTUtil.DIRECTIONS) {
            map.put((Object)dir, (Object)dir.m_253071_());
        }
        return map.build();
    });
    private static final Table<Direction, Direction, Matrix4fc> rotations = Tables.synchronizedTable((Table)HashBasedTable.create());

    @Contract(pure=true)
    public static float getRotationAngle(Vector3fc from, Vector3fc to) {
        return (float)Math.acos(from.dot(to));
    }

    public static Vector3f getRotationAxis(Vector3f from, Vector3fc to) {
        return GTMatrixUtils.getRotationAxis((Vector3fc)from, to, from);
    }

    public static Vector3f getRotationAxis(Vector3fc from, Vector3fc to, Vector3f dest) {
        return from.cross(to, dest).normalize();
    }

    @Contract(pure=true)
    public static Quaternionf getRotation(Vector3fc from, Vector3fc to) {
        return from.rotationTo(to, new Quaternionf());
    }

    @Contract(pure=true)
    public static Quaternionf getRotation(Direction from, Direction to) {
        return GTMatrixUtils.getRotation(GTMatrixUtils.getDirectionAxis(from), GTMatrixUtils.getDirectionAxis(to));
    }

    public static void rotateMatrix(Matrix4f matrix, Vector3f from, Vector3fc to, Vector3f ... additional) {
        if (from.equals((Object)to)) {
            return;
        }
        if (-from.x() == to.x() && -from.y() == to.y() && -from.z() == to.z()) {
            GTMatrixUtils.rotateMatrix(matrix, (float)Math.PI, GTMatrixUtils.getDirectionAxis(Direction.UP), additional);
        } else {
            float angle = GTMatrixUtils.getRotationAngle((Vector3fc)from, to);
            GTMatrixUtils.getRotationAxis(from, to);
            GTMatrixUtils.rotateMatrix(matrix, angle, (Vector3fc)from, additional);
        }
    }

    public static void rotateMatrix(Matrix4f matrix, float angle, Vector3fc axis, Vector3f ... additional) {
        matrix.rotate(angle, axis);
        for (Vector3f vec : additional) {
            vec.rotateAxis(angle, axis.x(), axis.y(), axis.z());
        }
    }

    public static float upwardFacingAngle(Direction upward) {
        return (switch (upward) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 2.0f;
            case Direction.WEST -> 3.0f;
            case Direction.EAST -> 1.0f;
            default -> throw new InvalidParameterException("Upward facing can't be up/down");
        }) * 1.5707964f;
    }

    public static Vector3f rotateMatrixToFront(Matrix4f matrix, Direction frontFace) {
        Vector3f front = frontFace.m_253071_();
        GTMatrixUtils.rotateMatrix(matrix, Direction.NORTH.m_253071_(), GTMatrixUtils.getDirectionAxis(frontFace), front);
        return front;
    }

    public static void rotateMatrixToUp(Matrix4f matrix, Vector3f front, Direction upwardsFace) {
        GTMatrixUtils.rotateMatrix(matrix, GTMatrixUtils.upwardFacingAngle(upwardsFace), (Vector3fc)front, new Vector3f[0]);
    }

    public static Matrix4fc createRotationState(Direction frontFace, Direction upwardFace) {
        if (rotations.contains((Object)frontFace, (Object)upwardFace)) {
            Matrix4fc rotation = (Matrix4fc)rotations.get((Object)frontFace, (Object)upwardFace);
            assert (rotation != null);
            return rotation;
        }
        Matrix4f matrix = new Matrix4f();
        Vector3f front = GTMatrixUtils.rotateMatrixToFront(matrix, frontFace);
        front.absolute();
        GTMatrixUtils.rotateMatrixToUp(matrix, front, upwardFace);
        rotations.put((Object)frontFace, (Object)upwardFace, (Object)matrix);
        return matrix;
    }

    public static Vector3fc getDirectionAxis(Direction dir) {
        return Objects.requireNonNull((Vector3fc)directionAxises.get((Object)dir));
    }
}

