/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.transfer.fluid.CustomFluidTank;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraftforge.fluids.FluidStack;

public class OverlayedTankHandler {
    private final List<OverlayedTank> overlayedTanks;

    public OverlayedTankHandler(List<NotifiableFluidTank> tanks) {
        this.overlayedTanks = new ArrayList<OverlayedTank>(tanks.size());
        ArrayList<NotifiableFluidTank> copy = new ArrayList<NotifiableFluidTank>(tanks);
        copy.sort(IRecipeHandler.ENTRY_COMPARATOR);
        for (NotifiableFluidTank tank : copy) {
            this.overlayedTanks.add(new OverlayedTank(tank));
        }
    }

    public void reset() {
        for (OverlayedTank tank : this.overlayedTanks) {
            tank.reset();
        }
    }

    public int tryFill(FluidStack fluid, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int total = 0;
        for (OverlayedTank tank : this.overlayedTanks) {
            int filled = tank.fill(fluid, amount);
            total += filled;
            if ((amount -= filled) > 0) continue;
            return total;
        }
        return total;
    }

    private static class OverlayedTank {
        private final int size;
        private final int capacity;
        private final boolean sameFluidFill;
        private final Predicate<FluidStack> filter;
        private final List<FluidStack> originalStacks;
        private List<FluidStack> stacks;

        private OverlayedTank(NotifiableFluidTank tank) {
            this.size = tank.getTanks();
            this.capacity = tank.getTankCapacity(0);
            this.sameFluidFill = tank.isAllowSameFluids();
            this.filter = tank.getFilter();
            this.originalStacks = new ArrayList<FluidStack>(tank.getStorages().length);
            for (CustomFluidTank storage : tank.getStorages()) {
                if (storage.getFluid().isEmpty()) continue;
                this.originalStacks.add(storage.getFluid());
            }
            this.reset();
        }

        public void reset() {
            this.stacks = new ArrayList<FluidStack>(this.size);
            for (FluidStack stack : this.originalStacks) {
                this.stacks.add(stack.copy());
            }
        }

        public int fill(FluidStack fluid, int amount) {
            if (!this.filter.test(fluid) || this.capacity <= 0) {
                return 0;
            }
            int filled = this.tryFill(fluid, amount);
            if (!this.sameFluidFill || filled >= amount) {
                return filled;
            }
            int total = filled;
            amount -= filled;
            for (int i = 1; i < this.size; ++i) {
                filled = this.tryFill(fluid, amount);
                total += filled;
                if ((amount -= filled) > 0) continue;
                return total;
            }
            return total;
        }

        private int tryFill(FluidStack fluid, int amount) {
            FluidStack existing = this.search(fluid);
            if (existing.isEmpty() || existing.getAmount() >= this.capacity) {
                if (!existing.isEmpty() && !this.sameFluidFill) {
                    return 0;
                }
                if (this.stacks.size() >= this.size) {
                    return 0;
                }
                int canInsert = Math.min(this.capacity, amount);
                this.stacks.add(new FluidStack(fluid, amount));
                return canInsert;
            }
            int canInsert = Math.min(this.capacity - existing.getAmount(), amount);
            existing.grow(canInsert);
            return canInsert;
        }

        private FluidStack search(FluidStack fluid) {
            FluidStack found = FluidStack.EMPTY;
            for (FluidStack stack : this.stacks) {
                if (!stack.isFluidEqual(fluid)) continue;
                if (!this.sameFluidFill || stack.getAmount() < this.capacity) {
                    return stack;
                }
                found = stack;
            }
            return found;
        }
    }
}

