/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.utils;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.item.IComponentItem;
import com.gregtechceu.gtceu.api.item.component.IDataItem;
import com.gregtechceu.gtceu.api.item.component.IItemComponent;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.ingredient.EnergyStack;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ResearchManager {
    public static final String RESEARCH_NBT_TAG = "assembly_line_research";
    public static final String RESEARCH_ID_NBT_TAG = "research_id";
    public static final String RESEARCH_TYPE_NBT_TAG = "research_type";

    @NotNull
    public static ItemStack getDefaultScannerItem() {
        return GTItems.TOOL_DATA_STICK.asStack();
    }

    @NotNull
    public static ItemStack getDefaultResearchStationItem(int cwut) {
        if (cwut > 32) {
            return GTItems.TOOL_DATA_MODULE.asStack();
        }
        return GTItems.TOOL_DATA_ORB.asStack();
    }

    private ResearchManager() {
    }

    public static void writeResearchToNBT(@NotNull CompoundTag stackCompound, @NotNull String researchId, GTRecipeType recipeType) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_(RESEARCH_ID_NBT_TAG, researchId);
        compound.m_128359_(RESEARCH_TYPE_NBT_TAG, recipeType.registryName.toString());
        stackCompound.m_128365_(RESEARCH_NBT_TAG, (Tag)compound);
    }

    @Nullable
    public static ResearchItem readResearchId(@NotNull ItemStack stack) {
        CompoundTag compound = stack.m_41783_();
        if (!ResearchManager.hasResearchTag(compound)) {
            return null;
        }
        CompoundTag researchCompound = compound.m_128469_(RESEARCH_NBT_TAG);
        return ResearchItem.CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)researchCompound).result().orElse(null);
    }

    public static boolean isStackDataItem(@NotNull ItemStack stack, boolean isDataBank) {
        Item item = stack.m_41720_();
        if (item instanceof IComponentItem) {
            IComponentItem metaItem = (IComponentItem)item;
            for (IItemComponent behaviour : metaItem.getComponents()) {
                if (!(behaviour instanceof IDataItem)) continue;
                IDataItem dataItem = (IDataItem)((Object)behaviour);
                return !dataItem.requireDataBank() || isDataBank;
            }
        }
        return false;
    }

    public static boolean hasResearchTag(@NotNull ItemStack stack) {
        return ResearchManager.hasResearchTag(stack.m_41783_());
    }

    private static boolean hasResearchTag(@Nullable CompoundTag compound) {
        if (compound == null || compound.m_128456_()) {
            return false;
        }
        return compound.m_128425_(RESEARCH_NBT_TAG, 10);
    }

    public static void createDefaultResearchRecipe(@NotNull GTRecipeBuilder builder, Consumer<FinishedRecipe> provider) {
        if (!ConfigHolder.INSTANCE.machines.enableResearch) {
            return;
        }
        for (GTRecipeBuilder.ResearchRecipeEntry entry : builder.researchRecipeEntries()) {
            if (entry.researchItem().m_41619_() && entry.researchFluid().isEmpty()) {
                throw new IllegalStateException("Both entry types in the research entry are null!");
            }
            ResearchManager.createDefaultResearchRecipe(builder.recipeType, entry.researchId(), entry.researchItem(), entry.researchFluid(), entry.dataStack(), entry.duration(), entry.EUt(), entry.CWUt(), provider);
        }
    }

    public static void createDefaultResearchRecipe(@NotNull GTRecipeType recipeType, @NotNull String researchId, @NotNull ItemStack researchItem, @NotNull FluidStack researchFluid, @NotNull ItemStack dataItem, int duration, EnergyStack eut, int CWUt, Consumer<FinishedRecipe> provider) {
        if (!ConfigHolder.INSTANCE.machines.enableResearch) {
            return;
        }
        CompoundTag compound = dataItem.m_41784_();
        ResearchManager.writeResearchToNBT(compound, researchId, recipeType);
        if (CWUt > 0) {
            GTRecipeBuilder builder = GTRecipeTypes.RESEARCH_STATION_RECIPES.recipeBuilder(researchId).inputItems(dataItem.m_41720_());
            if (!researchItem.m_41619_()) {
                builder.inputItems(researchItem);
            }
            if (!researchFluid.isEmpty()) {
                builder.inputFluids(researchFluid);
            }
            builder.outputItems(dataItem).EUt(eut.voltage(), eut.amperage()).CWUt(CWUt).totalCWU(duration).save(provider);
        } else {
            GTRecipeBuilder builder = GTRecipeTypes.SCANNER_RECIPES.recipeBuilder(FormattingUtil.toLowerCaseUnderscore(researchId)).inputItems(dataItem.m_41720_());
            if (!researchItem.m_41619_()) {
                builder.inputItems(researchItem);
            }
            if (!researchFluid.isEmpty()) {
                builder.inputFluids(researchFluid);
            }
            builder.outputItems(dataItem).duration(duration).EUt(eut.voltage(), eut.amperage()).researchScan(true).save(provider);
        }
    }

    public record ResearchItem(@NotNull String researchId, @NotNull GTRecipeType recipeType) {
        public static final Codec<ResearchItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf(ResearchManager.RESEARCH_ID_NBT_TAG).forGetter(ResearchItem::researchId), (App)GTRegistries.RECIPE_TYPES.codec().fieldOf(ResearchManager.RESEARCH_TYPE_NBT_TAG).forGetter(ResearchItem::recipeType)).apply((Applicative)instance, ResearchItem::new));
    }

    public static class DataStickCopyScannerLogic
    implements GTRecipeType.ICustomRecipeLogic {
        private static final int EUT = 2;
        private static final int DURATION = 100;

        @Override
        public GTRecipe createCustomRecipe(IRecipeCapabilityHolder holder) {
            IItemHandlerModifiable[] itemInputs = (IItemHandlerModifiable[])holder.getCapabilitiesFlat(IO.IN, ItemRecipeCapability.CAP).stream().filter(IItemHandlerModifiable.class::isInstance).map(IItemHandlerModifiable.class::cast).toArray(IItemHandlerModifiable[]::new);
            CombinedInvWrapper inputs = new CombinedInvWrapper(itemInputs);
            if (inputs.getSlots() > 1) {
                GTRecipe recipe = this.createDataRecipe(inputs.getStackInSlot(0), inputs.getStackInSlot(1));
                if (recipe != null) {
                    return recipe;
                }
                return this.createDataRecipe(inputs.getStackInSlot(1), inputs.getStackInSlot(0));
            }
            return null;
        }

        private GTRecipe createDataRecipe(@NotNull ItemStack first, @NotNull ItemStack second) {
            CompoundTag compound = second.m_41783_();
            if (compound == null) {
                return null;
            }
            if (!ResearchManager.isStackDataItem(first, true)) {
                return null;
            }
            if (!ResearchManager.isStackDataItem(second, true)) {
                return null;
            }
            ItemStack output = first.m_41777_();
            output.m_41751_(compound.m_6426_());
            return GTRecipeTypes.SCANNER_RECIPES.recipeBuilder(GTStringUtils.itemStackToString(output)).inputItems(first).notConsumable(second).outputItems(output).duration(100).EUt(2L).buildRawRecipe();
        }

        @Override
        public void buildRepresentativeRecipes() {
            ItemStack copiedStick = GTItems.TOOL_DATA_STICK.asStack();
            copiedStick.m_41714_((Component)Component.m_237115_((String)"gtceu.scanner.copy_stick_from"));
            ItemStack emptyStick = GTItems.TOOL_DATA_STICK.asStack();
            emptyStick.m_41714_((Component)Component.m_237115_((String)"gtceu.scanner.copy_stick_empty"));
            ItemStack resultStick = GTItems.TOOL_DATA_STICK.asStack();
            resultStick.m_41714_((Component)Component.m_237115_((String)"gtceu.scanner.copy_stick_to"));
            GTRecipe recipe = GTRecipeTypes.SCANNER_RECIPES.recipeBuilder("copy_" + GTStringUtils.itemStackToString(copiedStick)).inputItems(emptyStick).notConsumable(copiedStick).outputItems(resultStick).duration(100).EUt(2L).buildRawRecipe();
            recipe.setId(recipe.m_6423_().m_246208_("/"));
            GTRecipeTypes.SCANNER_RECIPES.addToMainCategory(recipe);
        }
    }
}

