/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.capability.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public interface IRecipeCapabilityHolder {
    default public boolean hasCapabilityProxies() {
        return !this.getCapabilitiesProxy().isEmpty();
    }

    @NotNull
    public Map<IO, List<RecipeHandlerList>> getCapabilitiesProxy();

    @NotNull
    public Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> getCapabilitiesFlat();

    @NotNull
    default public List<RecipeHandlerList> getCapabilitiesForIO(IO io) {
        return this.getCapabilitiesProxy().getOrDefault(io, Collections.emptyList());
    }

    @NotNull
    default public List<IRecipeHandler<?>> getCapabilitiesFlat(IO io, RecipeCapability<?> cap) {
        return this.getCapabilitiesFlat().getOrDefault(io, Collections.emptyMap()).getOrDefault(cap, Collections.emptyList());
    }

    default public void addHandlerList(RecipeHandlerList handlerList) {
        if (handlerList == RecipeHandlerList.NO_DATA) {
            return;
        }
        IO io = handlerList.getHandlerIO();
        this.getCapabilitiesProxy().computeIfAbsent(io, i -> new ArrayList()).add(handlerList);
        Set<Map.Entry<RecipeCapability<?>, List<IRecipeHandler<?>>>> entrySet = handlerList.getHandlerMap().entrySet();
        Map inner = this.getCapabilitiesFlat().computeIfAbsent(io, i -> new Reference2ObjectOpenHashMap(entrySet.size()));
        for (Map.Entry<RecipeCapability<?>, List<IRecipeHandler<?>>> entry : entrySet) {
            List<IRecipeHandler<?>> entryList = entry.getValue();
            inner.computeIfAbsent(entry.getKey(), c -> new ArrayList(entryList.size())).addAll(entryList);
        }
    }
}

