/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget.directional.handlers;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.api.gui.widget.directional.IDirectionalConfigHandler;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputFluid;
import com.gregtechceu.gtceu.api.machine.feature.IAutoOutputItem;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class AutoOutputItemConfigHandler
implements IDirectionalConfigHandler {
    private static final IGuiTexture TEXTURE_OFF = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, GuiTextures.IO_CONFIG_ITEM_MODES_BUTTON.getSubTexture(0.0f, 0.0f, 1.0f, 0.33333334f)});
    private static final IGuiTexture TEXTURE_OUTPUT = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, GuiTextures.IO_CONFIG_ITEM_MODES_BUTTON.getSubTexture(0.0f, 0.33333334f, 1.0f, 0.33333334f)});
    private static final IGuiTexture TEXTURE_AUTO = new GuiTextureGroup(new IGuiTexture[]{GuiTextures.VANILLA_BUTTON, GuiTextures.IO_CONFIG_ITEM_MODES_BUTTON.getSubTexture(0.0f, 0.6666667f, 1.0f, 0.33333334f)});
    private final IAutoOutputItem machine;
    private Direction side;
    private ButtonWidget ioModeButton;

    public AutoOutputItemConfigHandler(IAutoOutputItem machine) {
        this.machine = machine;
    }

    @Override
    public Widget getSideSelectorWidget(SceneWidget scene, FancyMachineUIWidget machineUI) {
        WidgetGroup group = new WidgetGroup(0, 0, 37, 18);
        this.ioModeButton = new ButtonWidget(0, 0, 18, 18, this::onIOModePressed){

            public void updateScreen() {
                super.updateScreen();
                if (AutoOutputItemConfigHandler.this.side == null) {
                    this.setButtonTexture(new IGuiTexture[]{TEXTURE_OFF});
                    this.setHoverTooltips((Component[])LangHandler.getMultiLang("gtceu.gui.item_auto_output.unselected").toArray(Component[]::new));
                } else if (AutoOutputItemConfigHandler.this.machine.getOutputFacingItems() == AutoOutputItemConfigHandler.this.side) {
                    if (AutoOutputItemConfigHandler.this.machine.isAutoOutputItems()) {
                        this.setButtonTexture(new IGuiTexture[]{TEXTURE_AUTO});
                        this.setHoverTooltips(new String[]{"gtceu.gui.item_auto_output.enabled"});
                    } else {
                        this.setButtonTexture(new IGuiTexture[]{TEXTURE_OUTPUT});
                        this.setHoverTooltips(new String[]{"gtceu.gui.item_auto_output.disabled"});
                    }
                } else {
                    this.setButtonTexture(new IGuiTexture[]{TEXTURE_OFF});
                    this.setHoverTooltips((Component[])LangHandler.getMultiLang("gtceu.gui.item_auto_output.other_direction").toArray(Component[]::new));
                }
            }
        };
        group.addWidget((Widget)this.ioModeButton);
        group.addWidget((Widget)new ToggleButtonWidget(19, 0, 18, 18, (IGuiTexture)GuiTextures.BUTTON_ITEM_OUTPUT, this.machine::isAllowInputFromOutputSideItems, this.machine::setAllowInputFromOutputSideItems).setShouldUseBaseBackground().setTooltipText("gtceu.gui.item_auto_output.allow_input"));
        return group;
    }

    private void onIOModePressed(ClickData cd) {
        if (this.side == null) {
            return;
        }
        if (this.machine.getOutputFacingItems() == this.side) {
            this.machine.setAutoOutputItems(!this.machine.isAutoOutputItems());
        } else {
            this.machine.setAutoOutputItems(false);
            this.machine.setOutputFacingItems(this.side);
        }
    }

    @Override
    public void onSideSelected(BlockPos pos, Direction side) {
        this.side = side;
    }

    @Override
    public IDirectionalConfigHandler.ScreenSide getScreenSide() {
        return IDirectionalConfigHandler.ScreenSide.LEFT;
    }

    @Override
    public void handleClick(ClickData cd, Direction direction) {
        if (!this.canHandleClick(cd) || !this.machine.hasAutoOutputItem()) {
            return;
        }
        if (this.machine.getOutputFacingItems() != this.side) {
            this.machine.setOutputFacingItems(this.side);
            this.machine.setAutoOutputItems(false);
        } else {
            this.machine.setAutoOutputItems(!this.machine.isAutoOutputItems());
        }
    }

    private boolean canHandleClick(ClickData cd) {
        if (cd.button == 0) {
            return true;
        }
        return !(this.machine instanceof IAutoOutputFluid) && cd.button == 1;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderOverlay(SceneWidget sceneWidget, BlockPosFace blockPosFace) {
        if (this.machine.getOutputFacingItems() != blockPosFace.facing) {
            return;
        }
        sceneWidget.drawFacingBorder(new PoseStack(), blockPosFace, this.machine.isAutoOutputItems() ? -37361 : -1879085553, 1);
    }

    @Override
    public void addAdditionalUIElements(WidgetGroup parent) {
        LabelWidget text = new LabelWidget(4, 4, "gtceu.gui.auto_output.name"){

            public boolean isVisible() {
                return AutoOutputItemConfigHandler.this.machine.isAutoOutputItems() && AutoOutputItemConfigHandler.this.machine.getOutputFacingItems() != null;
            }
        };
        text.setTextColor(-37361).setDropShadow(false);
        parent.addWidget((Widget)text);
    }
}

