/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.google.common.collect.Sets;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTAxeItem;
import com.gregtechceu.gtceu.api.item.tool.GTHoeItem;
import com.gregtechceu.gtceu.api.item.tool.GTShovelItem;
import com.gregtechceu.gtceu.api.item.tool.GTSwordItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolItem;
import com.gregtechceu.gtceu.api.item.tool.IGTToolDefinition;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.item.tool.ToolDefinitionBuilder;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.sound.ExistingSoundEntry;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.common.data.item.GTToolActions;
import com.gregtechceu.gtceu.common.item.tool.behavior.AOEConfigUIBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.BlockRotatingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.DisableShieldBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.DouseCampfireBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.EntityDamageBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.GrassPathBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestCropsBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HarvestIceBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.HoeGroundBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.LogStripBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.PlungerBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ProspectingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.RotateRailBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ScrapeBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.ToolModeSwitchBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.TorchPlaceBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.TreeFellingBehavior;
import com.gregtechceu.gtceu.common.item.tool.behavior.WaxOffBehavior;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GTToolType {
    private static final Map<String, GTToolType> types = new HashMap<String, GTToolType>();
    public static final GTToolType SWORD = GTToolType.builder("sword").toolTag(ToolItemTagType.MATCH, ItemTags.f_271388_).harvestTag(BlockTags.f_278398_).toolStats(b -> b.attacking().attackDamage(3.0f).attackSpeed(-2.4f)).constructor(GTSwordItem::new).toolClassNames("sword").defaultActions(ToolActions.DEFAULT_SWORD_ACTIONS).materialAmount(7257600L).build();
    public static final GTToolType PICKAXE = GTToolType.builder("pickaxe").toolTag(ToolItemTagType.MATCH, ItemTags.f_271360_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).toolStats(b -> b.blockBreaking().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(TorchPlaceBehavior.INSTANCE)).toolClassNames("pickaxe").defaultActions(ToolActions.DEFAULT_PICKAXE_ACTIONS).materialAmount(10886400L).build();
    public static final GTToolType SHOVEL = GTToolType.builder("shovel").toolTag(ToolItemTagType.MATCH, ItemTags.f_271138_).harvestTag(BlockTags.f_144283_).toolStats(b -> b.blockBreaking().attackDamage(1.5f).attackSpeed(-3.0f).behaviors(GrassPathBehavior.INSTANCE, DouseCampfireBehavior.INSTANCE)).constructor(GTShovelItem::new).toolClassNames("shovel").defaultActions(ToolActions.SHOVEL_DIG).materialAmount(3628800L).build();
    public static final GTToolType AXE = GTToolType.builder("axe").toolTag(ToolItemTagType.MATCH, ItemTags.f_271207_).harvestTag(BlockTags.f_144280_).toolStats(b -> b.blockBreaking().attackDamage(5.0f).attackSpeed(-3.2f).baseEfficiency(2.0f).behaviors(DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE, LogStripBehavior.INSTANCE, ScrapeBehavior.INSTANCE, WaxOffBehavior.INSTANCE)).constructor(GTAxeItem::new).toolClassNames("axe").materialAmount(10886400L).defaultActions(ToolActions.AXE_DIG).build();
    public static final GTToolType HOE = GTToolType.builder("hoe").toolTag(ToolItemTagType.MATCH, ItemTags.f_271298_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.cannotAttack().attackSpeed(-1.0f).behaviors(HoeGroundBehavior.INSTANCE)).constructor(GTHoeItem::new).toolClassNames("hoe").defaultActions(ToolActions.HOE_DIG).materialAmount(7257600L).build();
    public static final GTToolType MINING_HAMMER = GTToolType.builder("mining_hammer").toolTag(ToolItemTagType.MATCH, CustomTags.MINING_HAMMERS).harvestTag(BlockTags.f_144282_).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).toolClasses(PICKAXE).defaultActions(ToolActions.DEFAULT_PICKAXE_ACTIONS).materialAmount(21772800L).build();
    public static final GTToolType SPADE = GTToolType.builder("spade").toolTag(ToolItemTagType.MATCH, CustomTags.SPADES).harvestTag(BlockTags.f_144283_).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).efficiencyMultiplier(0.4f).attackDamage(1.5f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).behaviors(AOEConfigUIBehavior.INSTANCE, GrassPathBehavior.INSTANCE, DouseCampfireBehavior.INSTANCE)).toolClasses(SHOVEL).defaultActions(ToolActions.SHOVEL_DIG).materialAmount(10886400L).build();
    public static final GTToolType SCYTHE = GTToolType.builder("scythe").toolTag(ToolItemTagType.MATCH, CustomTags.SCYTHES).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().attacking().attackDamage(5.0f).attackSpeed(-3.0f).durabilityMultiplier(3.0f).aoe(2, 2, 2).behaviors(AOEConfigUIBehavior.INSTANCE, HoeGroundBehavior.INSTANCE, HarvestCropsBehavior.INSTANCE).canApplyEnchantment(EnchantmentCategory.DIGGER)).constructor(GTHoeItem::new).toolClassNames("scythe").toolClasses(HOE).defaultActions(ToolActions.HOE_DIG).materialAmount(10886400L).build();
    public static final GTToolType SAW = GTToolType.builder("saw").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_SAWS).toolTag(ToolItemTagType.MATCH, CustomTags.SAWS).harvestTag(CustomTags.MINEABLE_WITH_SAW).toolStats(b -> b.crafting().damagePerCraftingAction(2).attackDamage(-1.0f).attackSpeed(-2.6f).behaviors(HarvestIceBehavior.INSTANCE)).sound(GTSoundEntries.SAW_TOOL).symbol('s').defaultActions(GTToolActions.SAW_DIG).materialAmount(7257600L).build();
    public static final GTToolType HARD_HAMMER = GTToolType.builder("hammer").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_HAMMERS).toolTag(ToolItemTagType.MATCH, CustomTags.HAMMERS).harvestTag(CustomTags.MINEABLE_WITH_HAMMER).harvestTag(BlockTags.f_144282_).toolStats(b -> b.blockBreaking().crafting().damagePerCraftingAction(2).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(new EntityDamageBehavior(2.0f, IronGolem.class), ProspectingBehavior.INSTANCE)).sound(GTSoundEntries.FORGE_HAMMER).symbol('h').toolClasses(PICKAXE).defaultActions(ToolActions.DEFAULT_PICKAXE_ACTIONS).defaultActions(GTToolActions.DEFAULT_HAMMER_ACTIONS).materialAmount(21772800L).build();
    public static final GTToolType SOFT_MALLET = GTToolType.builder("mallet").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_MALLETS).toolTag(ToolItemTagType.MATCH, CustomTags.MALLETS).toolStats(b -> b.crafting().cannotAttack().attackSpeed(-2.4f).sneakBypassUse().behaviors(ToolModeSwitchBehavior.INSTANCE)).sound(GTSoundEntries.SOFT_MALLET_TOOL).symbol('r').defaultActions(GTToolActions.DEFAULT_MALLET_ACTIONS, GTToolActions.INTERACT_WITH_COVER).materialAmount(21772800L).build();
    public static final GTToolType WRENCH = GTToolType.builder("wrench").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE)).sound(GTSoundEntries.WRENCH_TOOL, true).symbol('w').defaultActions(GTToolActions.WRENCH_DIG, GTToolActions.WRENCH_DISMANTLE, GTToolActions.WRENCH_CONNECT).materialAmount(14515200L).build();
    public static final GTToolType FILE = GTToolType.builder("file").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_FILES).toolTag(ToolItemTagType.MATCH, CustomTags.FILES).toolStats(b -> b.crafting().damagePerCraftingAction(4).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.FILE_TOOL).symbol('f').materialAmount(7257600L).build();
    public static final GTToolType CROWBAR = GTToolType.builder("crowbar").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_CROWBARS).toolTag(ToolItemTagType.MATCH, CustomTags.CROWBARS).harvestTag(CustomTags.MINEABLE_WITH_CROWBAR).toolStats(b -> b.blockBreaking().crafting().attackDamage(2.0f).attackSpeed(-2.4f).sneakBypassUse().behaviors(RotateRailBehavior.INSTANCE)).sound(new ExistingSoundEntry(SoundEvents.f_12018_, SoundSource.BLOCKS), true).symbol('c').defaultActions(GTToolActions.CROWBAR_DIG, GTToolActions.CROWBAR_REMOVE_COVER).materialAmount(5443200L).build();
    public static final GTToolType SCREWDRIVER = GTToolType.builder("screwdriver").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_SCREWDRIVERS).toolTag(ToolItemTagType.MATCH, CustomTags.SCREWDRIVERS).toolStats(b -> b.crafting().damagePerCraftingAction(4).sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, Spider.class))).sound(GTSoundEntries.SCREWDRIVER_TOOL).symbol('d').defaultActions(GTToolActions.DEFAULT_SCREWDRIVER_ACTIONS).materialAmount(3628800L).build();
    public static final GTToolType MORTAR = GTToolType.builder("mortar").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_MORTARS).toolTag(ToolItemTagType.MATCH, CustomTags.MORTARS).toolStats(b -> b.crafting().damagePerCraftingAction(2).cannotAttack().attackSpeed(-2.4f)).sound(GTSoundEntries.MORTAR_TOOL).symbol('m').materialAmount(7257600L).build();
    public static final GTToolType WIRE_CUTTER = GTToolType.builder("wire_cutter").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(ToolItemTagType.MATCH, CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).symbol('x').defaultActions(GTToolActions.DEFAULT_WIRE_CUTTER_ACTIONS).materialAmount(14515200L).build();
    public static final GTToolType KNIFE = GTToolType.builder("knife").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_KNIVES).toolTag(ToolItemTagType.MATCH, CustomTags.KNIVES).harvestTag(CustomTags.MINEABLE_WITH_KNIFE).toolStats(b -> b.crafting().attacking().attackSpeed(3.0f)).constructor(GTSwordItem::new).symbol('k').toolClasses(SWORD).defaultActions(GTToolActions.KNIFE_DIG).materialAmount(3628800L).build();
    public static final GTToolType BUTCHERY_KNIFE = GTToolType.builder("butchery_knife").toolTag(ToolItemTagType.MATCH, CustomTags.BUTCHERY_KNIVES).toolStats(b -> b.attacking().attackDamage(1.5f).attackSpeed(-1.3f).defaultEnchantment(Enchantments.f_44982_, 3)).constructor(GTSwordItem::new).materialAmount(14515200L).build();
    public static final GTToolType PLUNGER = GTToolType.builder("plunger").toolTag(ToolItemTagType.MATCH, CustomTags.PLUNGERS).toolStats(b -> b.cannotAttack().attackSpeed(-2.4f).sneakBypassUse().behaviors(PlungerBehavior.INSTANCE)).sound(GTSoundEntries.PLUNGER_TOOL).build();
    public static final GTToolType SHEARS = GTToolType.builder("shears").toolTag(ToolItemTagType.MATCH, CustomTags.SHEARS).harvestTag(CustomTags.MINEABLE_WITH_SHEARS).toolStats(b -> b).defaultActions(ToolActions.DEFAULT_SHEARS_ACTIONS).build();
    public static final GTToolType DRILL_LV = GTToolType.builder("lv_drill").idFormat("lv_%s_drill").toolTag(ToolItemTagType.MATCH, CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(1, 1, 0).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(3.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(1).toolClassNames("drill").defaultActions(GTToolActions.DEFAULT_DRILL_ACTIONS).build();
    public static final GTToolType DRILL_MV = GTToolType.builder("mv_drill").idFormat("mv_%s_drill").toolTag(ToolItemTagType.MATCH, CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(1, 1, 2).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(4.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_MV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(2).toolClassNames("drill").defaultActions(GTToolActions.DEFAULT_DRILL_ACTIONS).build();
    public static final GTToolType DRILL_HV = GTToolType.builder("hv_drill").idFormat("hv_%s_drill").toolTag(ToolItemTagType.MATCH, CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(2, 2, 4).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(5.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(3).toolClassNames("drill").defaultActions(GTToolActions.DEFAULT_DRILL_ACTIONS).build();
    public static final GTToolType DRILL_EV = GTToolType.builder("ev_drill").idFormat("ev_%s_drill").toolTag(ToolItemTagType.MATCH, CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(3, 3, 6).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(6.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_EV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(4).toolClassNames("drill").defaultActions(GTToolActions.DEFAULT_DRILL_ACTIONS).build();
    public static final GTToolType DRILL_IV = GTToolType.builder("iv_drill").idFormat("iv_%s_drill").toolTag(ToolItemTagType.MATCH, CustomTags.DRILLS).toolTag(ItemTags.f_271360_).toolTag(ItemTags.f_271138_).toolTag(ItemTags.f_271298_).toolTag(ItemTags.f_144323_).harvestTag(BlockTags.f_144282_).harvestTag(BlockTags.f_144283_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().aoe(4, 4, 8).attackDamage(1.0f).attackSpeed(-3.2f).durabilityMultiplier(7.0f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV).behaviors(AOEConfigUIBehavior.INSTANCE, TorchPlaceBehavior.INSTANCE)).sound(GTSoundEntries.DRILL_TOOL, true).electric(5).toolClassNames("drill").defaultActions(GTToolActions.DEFAULT_DRILL_ACTIONS).build();
    public static final GTToolType CHAINSAW_LV = GTToolType.builder("lv_chainsaw").idFormat("lv_%s_chainsaw").toolTag(ToolItemTagType.MATCH, ItemTags.f_271207_).toolTag(ToolItemTagType.MATCH, CustomTags.CHAINSAWS).harvestTag(BlockTags.f_144280_).harvestTag(BlockTags.f_278398_).harvestTag(BlockTags.f_144281_).toolStats(b -> b.blockBreaking().efficiencyMultiplier(2.0f).attackDamage(5.0f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV).behaviors(HarvestIceBehavior.INSTANCE, DisableShieldBehavior.INSTANCE, TreeFellingBehavior.INSTANCE)).sound(GTSoundEntries.CHAINSAW_TOOL, true).electric(1).toolClasses(AXE).defaultActions(ToolActions.AXE_DIG, ToolActions.SWORD_DIG, ToolActions.HOE_DIG, GTToolActions.SAW_DIG).build();
    public static final GTToolType WRENCH_LV = GTToolType.builder("lv_wrench").idFormat("lv_%s_wrench").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(2.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(1).toolClasses(WRENCH).defaultActions(GTToolActions.WRENCH_DIG, GTToolActions.WRENCH_DISMANTLE, GTToolActions.WRENCH_CONNECT).build();
    public static final GTToolType WRENCH_HV = GTToolType.builder("hv_wrench").idFormat("hv_%s_wrench").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(3.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(3).toolClasses(WRENCH).defaultActions(GTToolActions.WRENCH_DIG, GTToolActions.WRENCH_DISMANTLE, GTToolActions.WRENCH_CONNECT).build();
    public static final GTToolType WRENCH_IV = GTToolType.builder("iv_wrench").idFormat("iv_%s_wrench").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCHES).toolTag(ToolItemTagType.MATCH, CustomTags.WRENCH).harvestTag(CustomTags.MINEABLE_WITH_WRENCH).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().efficiencyMultiplier(4.0f).attackDamage(1.0f).attackSpeed(-2.8f).behaviors(BlockRotatingBehavior.INSTANCE, new EntityDamageBehavior(3.0f, IronGolem.class), ToolModeSwitchBehavior.INSTANCE).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEntries.WRENCH_TOOL, true).electric(5).toolClasses(WRENCH).defaultActions(GTToolActions.WRENCH_DIG, GTToolActions.WRENCH_DISMANTLE, GTToolActions.WRENCH_CONNECT).build();
    public static final GTToolType WIRE_CUTTER_LV = GTToolType.builder("lv_wirecutter").idFormat("lv_%s_wire_cutter").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(ToolItemTagType.MATCH, CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(1).toolClasses(WIRE_CUTTER).defaultActions(GTToolActions.DEFAULT_WIRE_CUTTER_ACTIONS).build();
    public static final GTToolType WIRE_CUTTER_HV = GTToolType.builder("hv_wirecutter").idFormat("hv_%s_wire_cutter").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(ToolItemTagType.MATCH, CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_HV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(3).toolClasses(WIRE_CUTTER).defaultActions(GTToolActions.DEFAULT_WIRE_CUTTER_ACTIONS).build();
    public static final GTToolType WIRE_CUTTER_IV = GTToolType.builder("iv_wirecutter").idFormat("iv_%s_wire_cutter").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_WIRE_CUTTERS).toolTag(ToolItemTagType.MATCH, CustomTags.WIRE_CUTTERS).harvestTag(CustomTags.MINEABLE_WITH_WIRE_CUTTER).toolStats(b -> b.blockBreaking().crafting().sneakBypassUse().damagePerCraftingAction(4).attackDamage(-1.0f).attackSpeed(-2.4f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_IV)).sound(GTSoundEntries.WIRECUTTER_TOOL, true).electric(5).toolClasses(WIRE_CUTTER).defaultActions(GTToolActions.DEFAULT_WIRE_CUTTER_ACTIONS).build();
    public static final GTToolType BUZZSAW = GTToolType.builder("buzzsaw").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_SAWS).toolTag(ToolItemTagType.MATCH, CustomTags.SAWS).toolTag(ToolItemTagType.MATCH, CustomTags.BUZZSAWS).toolStats(b -> b.crafting().attackDamage(1.5f).attackSpeed(-3.2f).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.CHAINSAW_TOOL, true).electric(1).toolClasses(SAW).build();
    public static final GTToolType SCREWDRIVER_LV = GTToolType.builder("lv_screwdriver").idFormat("lv_%s_screwdriver").toolTag(ToolItemTagType.CRAFTING, CustomTags.CRAFTING_SCREWDRIVERS).toolTag(ToolItemTagType.MATCH, CustomTags.SCREWDRIVERS).toolStats(b -> b.crafting().sneakBypassUse().attackDamage(-1.0f).attackSpeed(3.0f).behaviors(new EntityDamageBehavior(3.0f, Spider.class)).brokenStack(ToolHelper.SUPPLY_POWER_UNIT_LV)).sound(GTSoundEntries.SCREWDRIVER_TOOL).electric(1).toolClasses(SCREWDRIVER).defaultActions(GTToolActions.DEFAULT_SCREWDRIVER_ACTIONS).build();
    public final String name;
    public final String idFormat;
    public final List<TagKey<Item>> itemTags;
    public final List<TagKey<Item>> matchTags;
    public final List<TagKey<Item>> craftingTags;
    public final List<TagKey<Block>> harvestTags;
    public final Set<ToolAction> defaultAbilities;
    public final ResourceLocation modelLocation;
    public final Set<String> toolClassNames;
    public final Set<GTToolType> toolClasses;
    @Nullable
    public final SoundEntry soundEntry;
    public final boolean playSoundOnBlockDestroy;
    public final char symbol;
    public final long materialAmount;
    public final IGTToolDefinition toolDefinition;
    public final ToolConstructor constructor;
    public final int electricTier;

    public GTToolType(String name, String idFormat, char symbol, Set<GTToolType> toolClasses, ToolConstructor constructor, IGTToolDefinition toolDefinition, List<TagKey<Item>> itemTags, List<TagKey<Item>> matchTags, List<TagKey<Item>> craftingTags, List<TagKey<Block>> harvestTags, Set<ToolAction> defaultAbilities, Set<String> toolClassNames, ResourceLocation modelLocation, @Nullable SoundEntry soundEntry, boolean playSoundOnBlockDestroy, int electricTier, long materialAmount) {
        this.name = name;
        this.idFormat = idFormat;
        this.symbol = symbol;
        toolClasses.add(this);
        this.toolClasses = toolClasses;
        this.toolDefinition = toolDefinition;
        this.constructor = constructor;
        this.itemTags = itemTags;
        this.matchTags = matchTags;
        this.craftingTags = craftingTags;
        this.harvestTags = harvestTags;
        this.defaultAbilities = defaultAbilities;
        this.modelLocation = modelLocation;
        this.toolClassNames = toolClassNames;
        this.soundEntry = soundEntry;
        this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
        this.electricTier = electricTier;
        this.materialAmount = materialAmount;
        types.put(name, this);
    }

    public boolean is(ItemStack itemStack) {
        return ToolHelper.is(itemStack, this);
    }

    public String getUnlocalizedName() {
        return "item.gtceu.tool." + this.name;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    @Generated
    public static Map<String, GTToolType> getTypes() {
        return types;
    }

    @FunctionalInterface
    public static interface ToolConstructor {
        public IGTTool apply(GTToolType var1, MaterialToolTier var2, Material var3, IGTToolDefinition var4, Item.Properties var5);
    }

    public static class Builder {
        private final String name;
        private String idFormat;
        private final List<TagKey<Item>> itemTags = new ArrayList<TagKey<Item>>();
        private final List<TagKey<Item>> matchTags = new ArrayList<TagKey<Item>>();
        private final List<TagKey<Item>> craftingTags = new ArrayList<TagKey<Item>>();
        private final List<TagKey<Block>> harvestTags = new ArrayList<TagKey<Block>>();
        private final Set<ToolAction> defaultAbilities = Sets.newIdentityHashSet();
        private Set<String> toolClassNames = new HashSet<String>();
        private final Set<GTToolType> toolClasses = new HashSet<GTToolType>();
        private IGTToolDefinition toolStats;
        private long materialAmount;
        private int tier = -1;
        private char symbol = (char)32;
        private ToolConstructor constructor = GTToolItem::new;
        private ResourceLocation modelLocation;
        private SoundEntry sound;
        private boolean playSoundOnBlockDestroy;

        public Builder(String name) {
            this.name = name;
            this.idFormat = "%s_" + name;
            this.modelLocation = GTCEu.id("item/tools/" + name);
        }

        @SafeVarargs
        public final Builder toolTag(TagKey<Item> ... tags) {
            return this.toolTag(ToolItemTagType.NONE, tags);
        }

        @SafeVarargs
        public final Builder toolTag(ToolItemTagType tagType, TagKey<Item> ... tags) {
            this.itemTags.addAll(Arrays.asList(tags));
            if (tagType == ToolItemTagType.MATCH) {
                this.matchTags.addAll(Arrays.asList(tags));
            }
            if (tagType == ToolItemTagType.CRAFTING) {
                this.craftingTags.addAll(Arrays.asList(tags));
            }
            return this;
        }

        @SafeVarargs
        public final Builder harvestTag(TagKey<Block> ... tags) {
            this.harvestTags.addAll(Arrays.asList(tags));
            return this;
        }

        public Builder defaultActions(ToolAction ... abilities) {
            this.defaultAbilities.addAll(Arrays.asList(abilities));
            return this;
        }

        public Builder defaultActions(Collection<ToolAction> abilities) {
            this.defaultAbilities.addAll(abilities);
            return this;
        }

        public Builder defaultActions(Collection<ToolAction> abilities, ToolAction ... extra) {
            this.defaultAbilities.addAll(abilities);
            this.defaultAbilities.addAll(Arrays.asList(extra));
            return this;
        }

        public Builder toolClasses(GTToolType ... classes) {
            this.toolClasses.addAll(Arrays.asList(classes));
            this.toolClassNames.addAll(Arrays.stream(classes).map(type -> type.name).toList());
            return this;
        }

        public Builder toolClassNames(String ... classes) {
            this.toolClassNames.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder toolStats(UnaryOperator<ToolDefinitionBuilder> builder) {
            this.toolStats = ((ToolDefinitionBuilder)builder.apply(new ToolDefinitionBuilder())).build();
            return this;
        }

        public Builder sound(SoundEntry sound) {
            return this.sound(sound, false);
        }

        public Builder sound(SoundEntry sound, boolean playSoundOnBlockDestroy) {
            this.sound = sound;
            this.playSoundOnBlockDestroy = playSoundOnBlockDestroy;
            return this;
        }

        public Builder electric(int tier) {
            return this.tier(tier);
        }

        private GTToolType get() {
            return new GTToolType(this.name, this.idFormat, this.symbol, this.toolClasses, this.constructor, this.toolStats, this.itemTags, this.matchTags, this.craftingTags, this.harvestTags, this.defaultAbilities, this.toolClassNames, this.modelLocation, this.sound, this.playSoundOnBlockDestroy, this.tier, this.materialAmount);
        }

        public GTToolType build() {
            if (this.toolClassNames.isEmpty()) {
                this.toolClassNames.add(this.name);
            }
            if (this.symbol == ' ') {
                return this.get();
            }
            GTToolType existing = ToolHelper.getToolFromSymbol(this.symbol);
            if (existing != null) {
                throw new IllegalArgumentException(String.format("Symbol %s has been taken by %s already!", Character.valueOf(this.symbol), existing));
            }
            GTToolType supplied = this.get();
            ToolHelper.registerToolSymbol(this.symbol, supplied);
            return supplied;
        }

        @NotNull
        @Generated
        public Builder idFormat(String idFormat) {
            this.idFormat = idFormat;
            return this;
        }

        @NotNull
        @Generated
        public Builder toolClassNames(Set<String> toolClassNames) {
            this.toolClassNames = toolClassNames;
            return this;
        }

        @NotNull
        @Generated
        public Builder toolStats(IGTToolDefinition toolStats) {
            this.toolStats = toolStats;
            return this;
        }

        @NotNull
        @Generated
        public Builder materialAmount(long materialAmount) {
            this.materialAmount = materialAmount;
            return this;
        }

        @NotNull
        @Generated
        public Builder tier(int tier) {
            this.tier = tier;
            return this;
        }

        @NotNull
        @Generated
        public Builder symbol(char symbol) {
            this.symbol = symbol;
            return this;
        }

        @NotNull
        @Generated
        public Builder constructor(ToolConstructor constructor) {
            this.constructor = constructor;
            return this;
        }

        @NotNull
        @Generated
        public Builder modelLocation(ResourceLocation modelLocation) {
            this.modelLocation = modelLocation;
            return this;
        }
    }

    public static enum ToolItemTagType {
        NONE,
        MATCH,
        CRAFTING;

    }
}

