/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

public class MultiblockMachineDefinition
extends MachineDefinition {
    private boolean generator;
    @NonNull
    private Supplier<BlockPattern> patternFactory;
    private Supplier<List<MultiblockShapeInfo>> shapes;
    private boolean allowFlip;
    private boolean renderXEIPreview;
    @Nullable
    private Supplier<ItemStack[]> recoveryItems;
    private Function<MultiblockControllerMachine, Comparator<IMultiPart>> partSorter;
    private TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance;
    private BiConsumer<IMultiController, List<Component>> additionalDisplay;

    public MultiblockMachineDefinition(ResourceLocation id) {
        super(id);
    }

    public List<MultiblockShapeInfo> getMatchingShapes() {
        List<MultiblockShapeInfo> designs = this.shapes.get();
        if (!designs.isEmpty()) {
            return designs;
        }
        BlockPattern structurePattern = this.patternFactory.get();
        int[][] aisleRepetitions = structurePattern.aisleRepetitions;
        return this.repetitionDFS(structurePattern, new ArrayList<MultiblockShapeInfo>(), aisleRepetitions, new IntArrayList());
    }

    private List<MultiblockShapeInfo> repetitionDFS(BlockPattern pattern, List<MultiblockShapeInfo> pages, int[][] aisleRepetitions, IntArrayList repetitionStack) {
        if (repetitionStack.size() == aisleRepetitions.length) {
            int[] repetition = new int[repetitionStack.size()];
            for (int i = 0; i < repetitionStack.size(); ++i) {
                repetition[i] = repetitionStack.getInt(i);
            }
            pages.add(new MultiblockShapeInfo(pattern.getPreview(repetition)));
        } else {
            for (int i = aisleRepetitions[repetitionStack.size()][0]; i <= aisleRepetitions[repetitionStack.size()][1]; ++i) {
                repetitionStack.push(i);
                this.repetitionDFS(pattern, pages, aisleRepetitions, repetitionStack);
                repetitionStack.popInt();
            }
        }
        return pages;
    }

    @Generated
    public boolean isGenerator() {
        return this.generator;
    }

    @Generated
    public void setGenerator(boolean generator) {
        this.generator = generator;
    }

    @Generated
    public void setPatternFactory(@NonNull Supplier<BlockPattern> patternFactory) {
        if (patternFactory == null) {
            throw new NullPointerException("patternFactory is marked non-null but is null");
        }
        this.patternFactory = patternFactory;
    }

    @NonNull
    @Generated
    public Supplier<BlockPattern> getPatternFactory() {
        return this.patternFactory;
    }

    @Generated
    public void setShapes(Supplier<List<MultiblockShapeInfo>> shapes) {
        this.shapes = shapes;
    }

    @Generated
    public Supplier<List<MultiblockShapeInfo>> getShapes() {
        return this.shapes;
    }

    @Generated
    public boolean isAllowFlip() {
        return this.allowFlip;
    }

    @Generated
    public void setAllowFlip(boolean allowFlip) {
        this.allowFlip = allowFlip;
    }

    @Override
    @Generated
    public boolean isRenderXEIPreview() {
        return this.renderXEIPreview;
    }

    @Override
    @Generated
    public void setRenderXEIPreview(boolean renderXEIPreview) {
        this.renderXEIPreview = renderXEIPreview;
    }

    @Generated
    public void setRecoveryItems(@Nullable Supplier<ItemStack[]> recoveryItems) {
        this.recoveryItems = recoveryItems;
    }

    @Nullable
    @Generated
    public Supplier<ItemStack[]> getRecoveryItems() {
        return this.recoveryItems;
    }

    @Generated
    public void setPartSorter(Function<MultiblockControllerMachine, Comparator<IMultiPart>> partSorter) {
        this.partSorter = partSorter;
    }

    @Generated
    public Function<MultiblockControllerMachine, Comparator<IMultiPart>> getPartSorter() {
        return this.partSorter;
    }

    @Generated
    public TriFunction<IMultiController, IMultiPart, Direction, BlockState> getPartAppearance() {
        return this.partAppearance;
    }

    @Generated
    public void setPartAppearance(TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance) {
        this.partAppearance = partAppearance;
    }

    @Generated
    public BiConsumer<IMultiController, List<Component>> getAdditionalDisplay() {
        return this.additionalDisplay;
    }

    @Generated
    public void setAdditionalDisplay(BiConsumer<IMultiController, List<Component>> additionalDisplay) {
        this.additionalDisplay = additionalDisplay;
    }
}

