/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class MultiblockDisplayText {
    private static final Component EMPTY_COMPONENT = Component.m_237119_();

    public static Builder builder(List<Component> textList, boolean isStructureFormed) {
        return MultiblockDisplayText.builder(textList, isStructureFormed, true);
    }

    public static Builder builder(List<Component> textList, boolean isStructureFormed, boolean showIncompleteStructureWarning) {
        return new Builder(textList, isStructureFormed, showIncompleteStructureWarning);
    }

    public static class Builder {
        private final List<Component> textList;
        private final boolean isStructureFormed;
        private boolean isWorkingEnabled;
        private boolean isActive;
        private String idlingKey = "gtceu.multiblock.idling";
        private String pausedKey = "gtceu.multiblock.work_paused";
        private String runningKey = "gtceu.multiblock.running";

        private Builder(List<Component> textList, boolean isStructureFormed, boolean showIncompleteStructureWarning) {
            this.textList = textList;
            this.isStructureFormed = isStructureFormed;
            if (!isStructureFormed && showIncompleteStructureWarning) {
                MutableComponent base = Component.m_237115_((String)"gtceu.multiblock.invalid_structure").m_130940_(ChatFormatting.RED);
                MutableComponent hover = Component.m_237115_((String)"gtceu.multiblock.invalid_structure.tooltip").m_130940_(ChatFormatting.GRAY);
                textList.add((Component)base.m_130938_(arg_0 -> Builder.lambda$new$0((Component)hover, arg_0)));
            }
        }

        public Builder setWorkingStatus(boolean isWorkingEnabled, boolean isActive) {
            this.isWorkingEnabled = isWorkingEnabled;
            this.isActive = isActive;
            return this;
        }

        public Builder setWorkingStatusKeys(String idlingKey, String pausedKey, String runningKey) {
            if (idlingKey != null) {
                this.idlingKey = idlingKey;
            }
            if (pausedKey != null) {
                this.pausedKey = pausedKey;
            }
            if (runningKey != null) {
                this.runningKey = runningKey;
            }
            return this;
        }

        public Builder addEnergyUsageLine(IEnergyContainer energyContainer) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (energyContainer != null && energyContainer.getEnergyCapacity() > 0L) {
                long maxVoltage = Math.max(energyContainer.getInputVoltage(), energyContainer.getOutputVoltage());
                String energyFormatted = FormattingUtil.formatNumbers(maxVoltage);
                byte voltageTier = GTUtil.getFloorTierByVoltage(maxVoltage);
                MutableComponent voltageName = Component.m_237113_((String)GTValues.VNF[voltageTier]);
                MutableComponent bodyText = Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{energyFormatted, voltageName}).m_130940_(ChatFormatting.GRAY);
                MutableComponent hoverText = Component.m_237115_((String)"gtceu.multiblock.max_energy_per_tick_hover").m_130940_(ChatFormatting.GRAY);
                this.textList.add((Component)bodyText.m_130938_(arg_0 -> Builder.lambda$addEnergyUsageLine$1((Component)hoverText, arg_0)));
            }
            return this;
        }

        public Builder addEnergyTierLine(int tier) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (tier < 0 || tier > 14) {
                return this;
            }
            MutableComponent voltageName = Component.m_237113_((String)GTValues.VNF[tier]);
            MutableComponent bodyText = Component.m_237110_((String)"gtceu.multiblock.max_recipe_tier", (Object[])new Object[]{voltageName}).m_130940_(ChatFormatting.GRAY);
            MutableComponent hoverText = Component.m_237115_((String)"gtceu.multiblock.max_recipe_tier_hover").m_130940_(ChatFormatting.GRAY);
            this.textList.add((Component)bodyText.m_130938_(arg_0 -> Builder.lambda$addEnergyTierLine$2((Component)hoverText, arg_0)));
            return this;
        }

        public Builder addEnergyUsageExactLine(long energyUsage) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (energyUsage > 0L) {
                String energyFormatted = FormattingUtil.formatNumbers(energyUsage);
                MutableComponent voltageName = Component.m_237113_((String)GTValues.VNF[GTUtil.getTierByVoltage(energyUsage)]);
                this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.energy_consumption", (Object[])new Object[]{energyFormatted, voltageName}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addEnergyProductionLine(long maxVoltage, long recipeEUt) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (maxVoltage != 0L && maxVoltage >= -recipeEUt) {
                String energyFormatted = FormattingUtil.formatNumbers(maxVoltage);
                MutableComponent voltageName = Component.m_237113_((String)GTValues.VNF[GTUtil.getFloorTierByVoltage(maxVoltage)]);
                this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{energyFormatted, voltageName}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addEnergyProductionAmpsLine(long maxVoltage, int amperage) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (maxVoltage != 0L && amperage != 0) {
                String energyFormatted = FormattingUtil.formatNumbers(maxVoltage);
                MutableComponent voltageName = Component.m_237113_((String)GTValues.VNF[GTUtil.getFloorTierByVoltage(maxVoltage)]);
                this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick_amps", (Object[])new Object[]{energyFormatted, amperage, voltageName}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addComputationUsageLine(int maxCWUt) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (maxCWUt > 0) {
                MutableComponent computation = Component.m_237113_((String)FormattingUtil.formatNumbers(maxCWUt)).m_130940_(ChatFormatting.AQUA);
                this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.computation.max", (Object[])new Object[]{computation}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addComputationUsageExactLine(int currentCWUt) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (this.isActive && currentCWUt > 0) {
                MutableComponent computation = Component.m_237113_((String)(FormattingUtil.formatNumbers(currentCWUt) + " CWU/t")).m_130940_(ChatFormatting.AQUA);
                this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.computation.usage", (Object[])new Object[]{computation}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addWorkingStatusLine() {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!this.isWorkingEnabled) {
                return this.addWorkPausedLine(false);
            }
            if (this.isActive) {
                return this.addRunningPerfectlyLine(false);
            }
            return this.addIdlingLine(false);
        }

        public Builder addWorkPausedLine(boolean checkState) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!checkState || !this.isWorkingEnabled) {
                this.textList.add((Component)Component.m_237115_((String)this.pausedKey).m_130940_(ChatFormatting.GOLD));
            }
            return this;
        }

        public Builder addRunningPerfectlyLine(boolean checkState) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!checkState || this.isActive) {
                this.textList.add((Component)Component.m_237115_((String)this.runningKey).m_130940_(ChatFormatting.GREEN));
            }
            return this;
        }

        public Builder addIdlingLine(boolean checkState) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (!checkState || this.isWorkingEnabled && !this.isActive) {
                this.textList.add((Component)Component.m_237115_((String)this.idlingKey).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addProgressLineOnlyPercent(double progressPercent) {
            if (!this.isStructureFormed || !this.isActive) {
                return this;
            }
            int currentProgress = (int)(progressPercent * 100.0);
            this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.progress_percent", (Object[])new Object[]{currentProgress}));
            return this;
        }

        public Builder addProgressLine(RecipeLogic recipeLogic) {
            if (recipeLogic.hasCustomProgressLine()) {
                return this.addCustomProgressLine(recipeLogic);
            }
            return this.addProgressLine(recipeLogic.getProgress(), recipeLogic.getMaxProgress(), recipeLogic.getProgressPercent());
        }

        public Builder addProgressLine(double currentDuration, double maxDuration, double progressPercent) {
            if (!this.isStructureFormed || !this.isActive) {
                return this;
            }
            int currentProgress = (int)(progressPercent * 100.0);
            double currentInSec = currentDuration / 20.0;
            double maxInSec = maxDuration / 20.0;
            this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.progress", (Object[])new Object[]{String.format("%.2f", Float.valueOf((float)currentInSec)), String.format("%.2f", Float.valueOf((float)maxInSec)), currentProgress}));
            return this;
        }

        public Builder addCustomProgressLine(RecipeLogic recipeLogic) {
            if (!this.isStructureFormed || !this.isActive) {
                return this;
            }
            Component line = recipeLogic.getCustomProgressLine();
            if (line != null) {
                this.textList.add(line);
            }
            return this;
        }

        public Builder addBatchModeLine(boolean batchEnabled, int batchAmount) {
            if (batchEnabled && batchAmount > 0) {
                MutableComponent runs = Component.m_237113_((String)FormattingUtil.formatNumbers(batchAmount)).m_130940_(ChatFormatting.DARK_PURPLE);
                String key = "gtceu.multiblock.batch_enabled";
                this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{runs}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addSubtickParallelsLine(int subtickParallels) {
            if (subtickParallels > 1) {
                MutableComponent runs = Component.m_237113_((String)FormattingUtil.formatNumbers(subtickParallels)).m_130940_(ChatFormatting.DARK_PURPLE);
                String key = "gtceu.multiblock.subtick_parallels";
                this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{runs}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addTotalRunsLine(int totalRuns) {
            if (totalRuns > 1) {
                MutableComponent runs = Component.m_237113_((String)FormattingUtil.formatNumbers(totalRuns)).m_130940_(ChatFormatting.DARK_PURPLE);
                String key = "gtceu.multiblock.total_runs";
                this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{runs}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addOutputLines(GTRecipe recipe) {
            if (!this.isStructureFormed || !this.isActive) {
                return this;
            }
            if (recipe != null) {
                String key;
                ItemStack[] stacks;
                MutableComponent displaycount;
                ItemStack stack;
                Object provider;
                boolean rounded;
                int recipeTier = RecipeHelper.getPreOCRecipeEuTier(recipe);
                int chanceTier = recipeTier + recipe.ocLevel;
                ChanceBoostFunction function = recipe.getType().getChanceFunction();
                double maxDurationSec = (double)recipe.duration / 20.0;
                List<Content> itemOutputs = recipe.getOutputContents(ItemRecipeCapability.CAP);
                List<Content> fluidOutputs = recipe.getOutputContents(FluidRecipeCapability.CAP);
                int runs = recipe.getTotalRuns();
                for (Content item : itemOutputs) {
                    rounded = false;
                    int count = 0;
                    double countD = 1.0;
                    Object object = item.content;
                    if (object instanceof IntProviderIngredient) {
                        provider = (IntProviderIngredient)((Object)object);
                        rounded = true;
                        stack = ((IntProviderIngredient)((Object)provider)).getMaxSizeStack();
                        displaycount = Component.m_237110_((String)"gtceu.gui.content.range", (Object[])new Object[]{((IntProviderIngredient)((Object)provider)).getCountProvider().m_142739_(), ((IntProviderIngredient)((Object)provider)).getCountProvider().m_142737_()});
                        if (item.chance < item.maxChance) {
                            countD = countD * (double)runs * (double)function.getBoostedChance(item, recipeTier, chanceTier) / (double)item.maxChance;
                        }
                        countD *= ((IntProviderIngredient)((Object)provider)).getMidRoll();
                    } else {
                        stacks = ((Ingredient)ItemRecipeCapability.CAP.of(item.content)).m_43908_();
                        if (stacks.length == 0) continue;
                        stack = stacks[0];
                        count = stack.m_41613_();
                        countD *= (double)count;
                        if (item.chance < item.maxChance) {
                            rounded = true;
                            countD = countD * (double)runs * (double)function.getBoostedChance(item, recipeTier, chanceTier) / (double)item.maxChance;
                        }
                        count = Math.max(1, (int)Math.round(countD));
                        displaycount = Component.m_237113_((String)String.valueOf(count));
                    }
                    if (countD < maxDurationSec) {
                        key = "gtceu.multiblock.output_line." + (rounded ? "2" : "0");
                        this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{stack.m_41786_(), displaycount, FormattingUtil.formatNumber2Places(maxDurationSec / countD)}));
                        continue;
                    }
                    key = "gtceu.multiblock.output_line." + (rounded ? "3" : "1");
                    this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{stack.m_41786_(), displaycount, FormattingUtil.formatNumber2Places(countD / maxDurationSec)}));
                }
                for (Content fluid : fluidOutputs) {
                    rounded = false;
                    int amount = 0;
                    double amountD = 1.0;
                    stacks = fluid.content;
                    if (stacks instanceof IntProviderFluidIngredient) {
                        provider = (IntProviderFluidIngredient)stacks;
                        rounded = true;
                        stack = ((IntProviderFluidIngredient)provider).getMaxSizeStack();
                        displaycount = Component.m_237110_((String)"gtceu.gui.content.range", (Object[])new Object[]{((IntProviderFluidIngredient)provider).getCountProvider().m_142739_(), ((IntProviderFluidIngredient)provider).getCountProvider().m_142737_()});
                        if (fluid.chance < fluid.maxChance) {
                            amountD = amountD * (double)runs * (double)function.getBoostedChance(fluid, recipeTier, chanceTier) / (double)fluid.maxChance;
                        }
                        amountD *= ((IntProviderFluidIngredient)provider).getMidRoll();
                    } else {
                        stacks = ((FluidIngredient)FluidRecipeCapability.CAP.of(fluid.content)).getStacks();
                        if (stacks.length == 0) continue;
                        stack = stacks[0];
                        amount = stack.getAmount();
                        amountD *= (double)amount;
                        if (fluid.chance < fluid.maxChance) {
                            rounded = true;
                            amountD = amountD * (double)runs * (double)function.getBoostedChance(fluid, recipeTier, chanceTier) / (double)fluid.maxChance;
                        }
                        amount = Math.max(1, (int)Math.round(amountD));
                        displaycount = Component.m_237113_((String)String.valueOf(amount));
                    }
                    if (amountD < maxDurationSec) {
                        key = "gtceu.multiblock.output_line." + (rounded ? "2" : "0");
                        this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{stack.getDisplayName(), displaycount, FormattingUtil.formatNumber2Places(maxDurationSec / amountD)}));
                        continue;
                    }
                    key = "gtceu.multiblock.output_line." + (rounded ? "3" : "1");
                    this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{stack.getDisplayName(), displaycount, FormattingUtil.formatNumber2Places(amountD / maxDurationSec)}));
                }
            }
            return this;
        }

        public Builder addMachineModeLine(GTRecipeType recipeType, boolean hasMultipleModes) {
            if (!this.isStructureFormed || !hasMultipleModes) {
                return this;
            }
            this.textList.add((Component)Component.m_237110_((String)"gtceu.gui.machinemode", (Object[])new Object[]{Component.m_237115_((String)recipeType.registryName.m_214298_())}).m_130940_(ChatFormatting.AQUA));
            return this;
        }

        public Builder addParallelsLine(int numParallels) {
            return this.addParallelsLine(numParallels, false);
        }

        public Builder addParallelsLine(int numParallels, boolean exact) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (numParallels > 1) {
                MutableComponent parallels = Component.m_237113_((String)FormattingUtil.formatNumbers(numParallels)).m_130940_(ChatFormatting.DARK_PURPLE);
                Object key = "gtceu.multiblock.parallel";
                if (exact) {
                    key = (String)key + ".exact";
                }
                this.textList.add((Component)Component.m_237110_((String)key, (Object[])new Object[]{parallels}).m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addLowPowerLine(boolean isLowPower) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isLowPower) {
                this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.not_enough_energy").m_130940_(ChatFormatting.YELLOW));
            }
            return this;
        }

        public Builder addLowComputationLine(boolean isLowComputation) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isLowComputation) {
                this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.computation.not_enough_computation").m_130940_(ChatFormatting.YELLOW));
            }
            return this;
        }

        public Builder addLowDynamoTierLine(boolean isTooLow) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isTooLow) {
                this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.not_enough_energy_output").m_130940_(ChatFormatting.YELLOW));
            }
            return this;
        }

        public Builder addMaintenanceProblemLines(byte maintenanceProblems) {
            if (!this.isStructureFormed || !ConfigHolder.INSTANCE.machines.enableMaintenance) {
                return this;
            }
            if (maintenanceProblems <= 63 && maintenanceProblems > 0) {
                this.addMaintenanceProblemHeader();
                if ((maintenanceProblems & 1) == 0) {
                    this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.problem.wrench").m_130940_(ChatFormatting.GRAY));
                }
                if ((maintenanceProblems >> 1 & 1) == 0) {
                    this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.problem.screwdriver").m_130940_(ChatFormatting.GRAY));
                }
                if ((maintenanceProblems >> 2 & 1) == 0) {
                    this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.problem.soft_mallet").m_130940_(ChatFormatting.GRAY));
                }
                if ((maintenanceProblems >> 3 & 1) == 0) {
                    this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.problem.hard_hammer").m_130940_(ChatFormatting.GRAY));
                }
                if ((maintenanceProblems >> 4 & 1) == 0) {
                    this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.problem.wire_cutter").m_130940_(ChatFormatting.GRAY));
                }
                if ((maintenanceProblems >> 5 & 1) == 0) {
                    this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.problem.crowbar").m_130940_(ChatFormatting.GRAY));
                }
            }
            return this;
        }

        private void addMaintenanceProblemHeader() {
            this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.has_problems").m_130940_(ChatFormatting.YELLOW));
        }

        public Builder addMufflerObstructedLine(boolean isObstructed) {
            if (!this.isStructureFormed) {
                return this;
            }
            if (isObstructed) {
                this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.muffler_obstructed").m_130940_(ChatFormatting.RED));
                this.textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.universal.muffler_obstructed.tooltip").m_130940_(ChatFormatting.GRAY));
            }
            return this;
        }

        public Builder addFuelNeededLine(String fuelName, int previousRecipeDuration) {
            if (!this.isStructureFormed || !this.isActive || fuelName == null) {
                return this;
            }
            MutableComponent fuelNeeded = Component.m_237113_((String)fuelName).m_130940_(ChatFormatting.RED);
            MutableComponent numTicks = Component.m_237113_((String)FormattingUtil.formatNumbers(previousRecipeDuration)).m_130940_(ChatFormatting.AQUA);
            this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.fuel_needed", (Object[])new Object[]{fuelNeeded, numTicks}).m_130940_(ChatFormatting.GRAY));
            return this;
        }

        public Builder addEmptyLine() {
            this.textList.add(EMPTY_COMPONENT);
            return this;
        }

        public Builder addCustom(Consumer<List<Component>> customConsumer) {
            customConsumer.accept(this.textList);
            return this;
        }

        public Builder addCurrentEnergyProductionLine(long euOutput) {
            this.textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.turbine.energy_per_tick_maxed", (Object[])new Object[]{FormattingUtil.formatNumbers(euOutput)}).m_130940_(ChatFormatting.GRAY));
            return this;
        }

        private static /* synthetic */ Style lambda$addEnergyTierLine$2(Component hoverText, Style style) {
            return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText));
        }

        private static /* synthetic */ Style lambda$addEnergyUsageLine$1(Component hoverText, Style style) {
            return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverText));
        }

        private static /* synthetic */ Style lambda$new$0(Component hover, Style style) {
            return style.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hover));
        }
    }
}

