/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.ICleanroomProvider;
import com.gregtechceu.gtceu.api.machine.feature.IMufflableMachine;
import com.gregtechceu.gtceu.api.machine.feature.IVoidable;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IWorkableMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class WorkableMultiblockMachine
extends MultiblockControllerMachine
implements IWorkableMultiController,
IMufflableMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(WorkableMultiblockMachine.class, MultiblockControllerMachine.MANAGED_FIELD_HOLDER);
    @Nullable
    private ICleanroomProvider cleanroom;
    @Persisted
    @DescSynced
    public final RecipeLogic recipeLogic;
    private final GTRecipeType[] recipeTypes;
    @Persisted
    private int activeRecipeType = 0;
    protected final Map<IO, List<RecipeHandlerList>> capabilitiesProxy;
    protected final Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> capabilitiesFlat;
    protected final List<ISubscription> traitSubscriptions;
    @Persisted
    @DescSynced
    protected boolean isMuffled;
    protected boolean previouslyMuffled = true;
    @Nullable
    protected LongSet activeBlocks;
    @Persisted
    @DescSynced
    protected IVoidable.VoidingMode voidingMode = IVoidable.VoidingMode.VOID_NONE;

    public WorkableMultiblockMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder);
        this.recipeTypes = this.getDefinition().getRecipeTypes();
        this.recipeLogic = this.createRecipeLogic(args);
        this.capabilitiesProxy = new EnumMap<IO, List<RecipeHandlerList>>(IO.class);
        this.capabilitiesFlat = new EnumMap(IO.class);
        this.traitSubscriptions = new ArrayList<ISubscription>();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onUnload() {
        super.onUnload();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.inValid();
    }

    protected RecipeLogic createRecipeLogic(Object ... args) {
        return new RecipeLogic(this);
    }

    @Override
    public void onStructureFormed() {
        super.onStructureFormed();
        this.activeBlocks = this.getMultiblockState().getMatchContext().getOrDefault("vaBlocks", LongSets.emptySet());
        this.capabilitiesProxy.clear();
        this.capabilitiesFlat.clear();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        Long2ObjectMap ioMap = this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
        for (IMultiPart part : this.getParts()) {
            IO iO = (IO)ioMap.getOrDefault(part.self().getPos().m_121878_(), (Object)IO.BOTH);
            if (iO == IO.NONE) continue;
            List<RecipeHandlerList> handlerLists = part.getRecipeHandlers();
            for (RecipeHandlerList handlerList : handlerLists) {
                if (!handlerList.isValid(iO)) continue;
                this.addHandlerList(handlerList);
                this.traitSubscriptions.add(handlerList.subscribe(this.recipeLogic::updateTickSubscription));
            }
        }
        EnumMap<IO, List> ioTraits = new EnumMap<IO, List>(IO.class);
        for (MachineTrait machineTrait : this.getTraits()) {
            if (!(machineTrait instanceof IRecipeHandlerTrait)) continue;
            IRecipeHandlerTrait handlerTrait = (IRecipeHandlerTrait)((Object)machineTrait);
            ioTraits.computeIfAbsent(handlerTrait.getHandlerIO(), i -> new ArrayList()).add(handlerTrait);
        }
        for (Map.Entry entry : ioTraits.entrySet()) {
            RecipeHandlerList handlerList = RecipeHandlerList.of((IO)entry.getKey(), (Iterable)entry.getValue());
            this.addHandlerList(handlerList);
            this.traitSubscriptions.add(handlerList.subscribe(this.recipeLogic::updateTickSubscription));
        }
        this.recipeLogic.updateTickSubscription();
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.updateActiveBlocks(false);
        this.activeBlocks = null;
        this.capabilitiesProxy.clear();
        this.capabilitiesFlat.clear();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.resetRecipeLogic();
    }

    @Override
    public void onPartUnload() {
        super.onPartUnload();
        this.updateActiveBlocks(false);
        this.activeBlocks = null;
        this.capabilitiesProxy.clear();
        this.capabilitiesFlat.clear();
        this.traitSubscriptions.forEach(ISubscription::unsubscribe);
        this.traitSubscriptions.clear();
        this.recipeLogic.updateTickSubscription();
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.previouslyMuffled != this.isMuffled) {
            this.previouslyMuffled = this.isMuffled;
            if (this.recipeLogic != null) {
                this.recipeLogic.updateSound();
            }
        }
    }

    @Override
    @Nullable
    public final GTRecipe doModifyRecipe(GTRecipe recipe) {
        for (IMultiPart part : this.getParts()) {
            recipe = part.modifyRecipe(recipe);
            if (recipe != null) continue;
            return null;
        }
        return this.getRealRecipe(recipe);
    }

    @Nullable
    protected GTRecipe getRealRecipe(GTRecipe recipe) {
        return this.self().getDefinition().getRecipeModifier().applyModifier(this.self(), recipe);
    }

    public void updateActiveBlocks(boolean active) {
        if (this.activeBlocks != null) {
            LongIterator longIterator = this.activeBlocks.iterator();
            while (longIterator.hasNext()) {
                BlockState newState;
                long pos = (Long)longIterator.next();
                BlockPos blockPos = BlockPos.m_122022_((long)pos);
                BlockState blockState = this.getLevel().m_8055_(blockPos);
                if (!blockState.m_61138_((Property)GTBlockStateProperties.ACTIVE) || (newState = (BlockState)blockState.m_61124_((Property)GTBlockStateProperties.ACTIVE, (Comparable)Boolean.valueOf(active))) == blockState) continue;
                this.getLevel().m_7731_(blockPos, newState, 18);
            }
        }
    }

    @Override
    public boolean keepSubscribing() {
        return false;
    }

    @Override
    public void notifyStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
        IWorkableMultiController.super.notifyStatusChanged(oldStatus, newStatus);
        if (newStatus == RecipeLogic.Status.WORKING || oldStatus == RecipeLogic.Status.WORKING) {
            this.updateActiveBlocks(newStatus == RecipeLogic.Status.WORKING);
        }
        for (IMultiPart part : this.getParts()) {
            MachineRenderState state = part.self().getRenderState();
            if (!state.m_61138_((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS)) continue;
            part.self().setRenderState((MachineRenderState)((Object)state.m_61124_((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)newStatus))));
        }
    }

    @Override
    public boolean isRecipeLogicAvailable() {
        return this.isFormed && !this.getMultiblockState().hasError();
    }

    @Override
    public void afterWorking() {
        for (IMultiPart part : this.getParts()) {
            part.afterWorking(this);
        }
        IWorkableMultiController.super.afterWorking();
    }

    @Override
    public boolean beforeWorking(@Nullable GTRecipe recipe) {
        for (IMultiPart part : this.getParts()) {
            if (part.beforeWorking(this)) continue;
            return false;
        }
        return IWorkableMultiController.super.beforeWorking(recipe);
    }

    @Override
    public boolean onWorking() {
        for (IMultiPart part : this.getParts()) {
            if (part.onWorking(this)) continue;
            return false;
        }
        return IWorkableMultiController.super.onWorking();
    }

    @Override
    public void onWaiting() {
        for (IMultiPart part : this.getParts()) {
            part.onWaiting(this);
        }
        IWorkableMultiController.super.onWaiting();
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        if (!isWorkingAllowed) {
            for (IMultiPart part : this.getParts()) {
                part.onPaused(this);
            }
        }
        IWorkableMultiController.super.setWorkingEnabled(isWorkingAllowed);
    }

    @Override
    @NotNull
    public GTRecipeType getRecipeType() {
        return this.recipeTypes[this.activeRecipeType];
    }

    @ApiStatus.Internal
    @VisibleForTesting
    public void setRecipeType(GTRecipeType newType) {
        this.recipeTypes[this.activeRecipeType] = newType;
    }

    @Override
    public void setVoidingMode(IVoidable.VoidingMode mode) {
        this.voidingMode = mode;
        this.getRecipeLogic().updateTickSubscription();
    }

    @Override
    @Nullable
    @Generated
    public ICleanroomProvider getCleanroom() {
        return this.cleanroom;
    }

    @Override
    @Generated
    public void setCleanroom(@Nullable ICleanroomProvider cleanroom) {
        this.cleanroom = cleanroom;
    }

    @Override
    @Generated
    public RecipeLogic getRecipeLogic() {
        return this.recipeLogic;
    }

    @Override
    @Generated
    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes;
    }

    @Override
    @Generated
    public int getActiveRecipeType() {
        return this.activeRecipeType;
    }

    @Override
    @Generated
    public void setActiveRecipeType(int activeRecipeType) {
        this.activeRecipeType = activeRecipeType;
    }

    @Override
    @Generated
    public Map<IO, List<RecipeHandlerList>> getCapabilitiesProxy() {
        return this.capabilitiesProxy;
    }

    @Override
    @Generated
    public Map<IO, Map<RecipeCapability<?>, List<IRecipeHandler<?>>>> getCapabilitiesFlat() {
        return this.capabilitiesFlat;
    }

    @Override
    @Generated
    public boolean isMuffled() {
        return this.isMuffled;
    }

    @Override
    @Generated
    public void setMuffled(boolean isMuffled) {
        this.isMuffled = isMuffled;
    }

    @Nullable
    @Generated
    public LongSet getActiveBlocks() {
        return this.activeBlocks;
    }

    @Override
    @Generated
    public IVoidable.VoidingMode getVoidingMode() {
        return this.voidingMode;
    }
}

