/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.multipart;

import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.MultipartModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiPartBakedModel
implements IDynamicBakedModel {
    private final List<Pair<Predicate<MachineRenderState>, BakedModel>> selectors;
    protected final boolean hasAmbientOcclusion;
    protected final boolean isGui3d;
    protected final boolean usesBlockLight;
    protected final TextureAtlasSprite particleIcon;
    protected final ItemTransforms transforms;
    protected final ItemOverrides overrides;
    private final Map<MachineRenderState, BitSet> selectorCache = new Object2ObjectOpenCustomHashMap(Util.m_137583_());
    private final BakedModel defaultModel;

    public MultiPartBakedModel(List<Pair<Predicate<MachineRenderState>, BakedModel>> selectors) {
        BakedModel defaultModel;
        this.selectors = selectors;
        this.defaultModel = defaultModel = (BakedModel)selectors.iterator().next().getRight();
        this.hasAmbientOcclusion = defaultModel.m_7541_();
        this.isGui3d = defaultModel.m_7539_();
        this.usesBlockLight = defaultModel.m_7547_();
        this.particleIcon = defaultModel.m_6160_();
        this.transforms = defaultModel.m_7442_();
        this.overrides = defaultModel.m_7343_();
    }

    public BitSet getSelectors(@Nullable MachineRenderState state) {
        BitSet bitset = this.selectorCache.get((Object)state);
        if (bitset == null) {
            bitset = new BitSet();
            for (int i = 0; i < this.selectors.size(); ++i) {
                Pair<Predicate<MachineRenderState>, BakedModel> pair = this.selectors.get(i);
                if (!((Predicate)pair.getLeft()).test(state)) continue;
                bitset.set(i);
            }
            this.selectorCache.put(state, bitset);
        }
        return bitset;
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        return this.defaultModel.getQuads(state, side, rand, modelData, renderType);
    }

    public List<BakedQuad> getMachineQuads(MachineDefinition definition, MachineRenderState renderState, @Nullable BlockState blockState, @Nullable Direction direction, RandomSource random, ModelData modelData, @Nullable RenderType renderType) {
        if (blockState == null) {
            blockState = definition.defaultBlockState();
        }
        BitSet bitset = this.getSelectors(renderState);
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        long k = random.m_188505_();
        for (int j = 0; j < bitset.length(); ++j) {
            if (!bitset.get(j)) continue;
            BakedModel model = (BakedModel)this.selectors.get(j).getRight();
            ModelData partData = MultipartModelData.resolve((ModelData)modelData, (BakedModel)model);
            if (renderType != null && !model.getRenderTypes(blockState, random, partData).contains(renderType)) continue;
            quads.addAll(model.getQuads(blockState, direction, RandomSource.m_216335_((long)k), partData, renderType));
        }
        return quads;
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData modelData) {
        MetaMachine machine;
        BlockAndTintGetter level = (BlockAndTintGetter)modelData.get(IMachineBlockEntity.MODEL_DATA_LEVEL);
        BlockPos pos = (BlockPos)modelData.get(IMachineBlockEntity.MODEL_DATA_POS);
        MetaMachine metaMachine = machine = level == null || pos == null ? null : MetaMachine.getMachine((BlockGetter)level, pos);
        if (machine == null) {
            return super.getRenderTypes(state, rand, modelData);
        }
        LinkedList<ChunkRenderTypeSet> renderTypeSets = new LinkedList<ChunkRenderTypeSet>();
        BitSet selectors = this.getSelectors(machine.getRenderState());
        for (int i = 0; i < selectors.length(); ++i) {
            if (!selectors.get(i)) continue;
            BakedModel model = (BakedModel)this.selectors.get(i).getRight();
            ModelData partData = MultipartModelData.resolve((ModelData)modelData, (BakedModel)model);
            renderTypeSets.add(model.getRenderTypes(state, rand, partData));
        }
        return ChunkRenderTypeSet.union(renderTypeSets);
    }

    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
        ModelData.Builder builder = modelData.derive().with(IMachineBlockEntity.MODEL_DATA_LEVEL, (Object)level).with(IMachineBlockEntity.MODEL_DATA_POS, (Object)pos);
        MetaMachine machine = MetaMachine.getMachine((BlockGetter)level, pos);
        if (machine == null) {
            return builder.build();
        }
        this.addMachineModelData(machine.getRenderState(), level, pos, state, modelData, builder);
        return builder.build();
    }

    public void addMachineModelData(MachineRenderState renderState, BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData baseData, ModelData.Builder builder) {
        MultipartModelData.Builder multiPartData = MultipartModelData.builder();
        BitSet selectors = this.getSelectors(renderState);
        for (int i = 0; i < selectors.length(); ++i) {
            if (!selectors.get(i)) continue;
            BakedModel model = (BakedModel)this.selectors.get(i).getRight();
            multiPartData.with(model, model.getModelData(level, pos, state, baseData));
        }
        builder.with(MultipartModelData.PROPERTY, (Object)multiPartData.build());
    }

    public boolean m_7541_() {
        return this.hasAmbientOcclusion;
    }

    public boolean useAmbientOcclusion(BlockState state) {
        return this.defaultModel.useAmbientOcclusion(state);
    }

    public boolean useAmbientOcclusion(BlockState state, RenderType renderType) {
        return this.defaultModel.useAmbientOcclusion(state, renderType);
    }

    public boolean m_7521_() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon(ModelData modelData) {
        MetaMachine machine;
        BlockAndTintGetter level = (BlockAndTintGetter)modelData.get(IMachineBlockEntity.MODEL_DATA_LEVEL);
        BlockPos pos = (BlockPos)modelData.get(IMachineBlockEntity.MODEL_DATA_POS);
        MetaMachine metaMachine = machine = level == null || pos == null ? null : MetaMachine.getMachine((BlockGetter)level, pos);
        if (machine != null) {
            return this.getParticleIcon(machine.getRenderState(), modelData);
        }
        return this.defaultModel.getParticleIcon(modelData);
    }

    public TextureAtlasSprite getParticleIcon(@NotNull MachineRenderState renderState, ModelData modelData) {
        BitSet selectors = this.getSelectors(renderState);
        for (int i = 0; i < selectors.length(); ++i) {
            if (!selectors.get(i)) continue;
            BakedModel model = (BakedModel)this.selectors.get(i).getRight();
            ModelData partData = MultipartModelData.resolve((ModelData)modelData, (BakedModel)model);
            return model.getParticleIcon(partData);
        }
        return this.defaultModel.getParticleIcon(modelData);
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        return this.defaultModel.applyTransform(transformType, poseStack, applyLeftHandTransform);
    }

    @Generated
    public boolean m_7539_() {
        return this.isGui3d;
    }

    @Generated
    public boolean m_7547_() {
        return this.usesBlockLight;
    }

    @Generated
    public TextureAtlasSprite m_6160_() {
        return this.particleIcon;
    }

    @Generated
    public ItemTransforms m_7442_() {
        return this.transforms;
    }

    @Generated
    public ItemOverrides m_7343_() {
        return this.overrides;
    }

    public static class Builder {
        private final List<Pair<Predicate<MachineRenderState>, BakedModel>> selectors = new ArrayList<Pair<Predicate<MachineRenderState>, BakedModel>>();

        public void add(Predicate<MachineRenderState> predicate, BakedModel model) {
            this.selectors.add((Pair<Predicate<MachineRenderState>, BakedModel>)Pair.of(predicate, (Object)model));
        }

        public MultiPartBakedModel build() {
            return new MultiPartBakedModel(this.selectors);
        }
    }
}

