/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.util;

import net.minecraft.client.renderer.FaceInfo;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.QuadTransformers;

public final class GTQuadTransformers {
    public static IQuadTransformer offset(float by) {
        return GTQuadTransformers.offset(by, by, by);
    }

    public static IQuadTransformer offset(float xOffset, float yOffset, float zOffset) {
        if (xOffset == 0.0f && yOffset == 0.0f && zOffset == 0.0f) {
            return QuadTransformers.empty();
        }
        return quad -> {
            int[] vertices = quad.m_111303_();
            Direction direction = quad.m_111306_();
            FaceInfo faceInfo = FaceInfo.m_108984_((Direction)direction);
            for (int i = 0; i < 4; ++i) {
                FaceInfo.VertexInfo normal = faceInfo.m_108982_(i);
                int xNormal = Direction.m_122376_((int)normal.f_108998_).m_122429_();
                int yNormal = Direction.m_122376_((int)normal.f_108999_).m_122430_();
                int zNormal = Direction.m_122376_((int)normal.f_109000_).m_122431_();
                int offset = i * IQuadTransformer.STRIDE + IQuadTransformer.POSITION;
                float x = Float.intBitsToFloat(vertices[offset]);
                float y = Float.intBitsToFloat(vertices[offset + 1]);
                float z = Float.intBitsToFloat(vertices[offset + 2]);
                vertices[offset] = Float.floatToRawIntBits(x += xOffset * (float)xNormal);
                vertices[offset + 1] = Float.floatToRawIntBits(y += yOffset * (float)yNormal);
                vertices[offset + 2] = Float.floatToRawIntBits(z += zOffset * (float)zNormal);
            }
        };
    }

    public static BakedQuad setSprite(BakedQuad quad, TextureAtlasSprite sprite) {
        TextureAtlasSprite oldSprite = quad.m_173410_();
        int[] vertices = (int[])quad.m_111303_().clone();
        for (int i = 0; i < 4; ++i) {
            int offset = i * IQuadTransformer.STRIDE + IQuadTransformer.UV0;
            float u = Float.intBitsToFloat(vertices[offset]);
            float v = Float.intBitsToFloat(vertices[offset + 1]);
            u = Mth.m_184637_((float)u, (float)oldSprite.m_118409_(), (float)oldSprite.m_118410_(), (float)sprite.m_118409_(), (float)sprite.m_118410_());
            v = Mth.m_184637_((float)v, (float)oldSprite.m_118411_(), (float)oldSprite.m_118412_(), (float)sprite.m_118411_(), (float)sprite.m_118412_());
            vertices[offset] = Float.floatToRawIntBits(u);
            vertices[offset + 1] = Float.floatToRawIntBits(v);
        }
        BakedQuad newQuad = new BakedQuad(vertices, quad.m_111305_(), quad.m_111306_(), sprite, quad.m_111307_(), quad.hasAmbientOcclusion());
        return newQuad.gtceu$setTextureKey(quad.gtceu$getTextureKey());
    }

    public static BakedQuad setColor(BakedQuad quad, int argbColor, boolean clearTintIndex) {
        int[] vertices = (int[])quad.m_111303_().clone();
        BakedQuad copy = new BakedQuad(vertices, clearTintIndex ? -1 : quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_(), quad.hasAmbientOcclusion());
        QuadTransformers.applyingColor((int)argbColor).processInPlace(copy);
        return copy.gtceu$setTextureKey(quad.gtceu$getTextureKey());
    }

    public static BakedQuad copy(BakedQuad quad) {
        return new BakedQuad((int[])quad.m_111303_().clone(), quad.m_111305_(), quad.m_111306_(), quad.m_173410_(), quad.m_111307_(), quad.hasAmbientOcclusion()).gtceu$setTextureKey(quad.gtceu$getTextureKey());
    }

    private GTQuadTransformers() {
    }
}

