/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.commands;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IMedicalConditionTracker;
import com.gregtechceu.gtceu.api.data.medicalcondition.MedicalCondition;
import com.gregtechceu.gtceu.common.commands.arguments.MedicalConditionArgument;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public class MedicalConditionCommands {
    private static final SimpleCommandExceptionType ERROR_CLEAR_EVERYTHING_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.effect.clear.everything.failed"));
    private static final SimpleCommandExceptionType ERROR_GIVE_FAILED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.effect.give.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"medical_condition").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"query").executes(ctx -> MedicalConditionCommands.queryMedicalConditions(((CommandSourceStack)ctx.getSource()).m_81375_()))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).requires(source -> source.m_6761_(2))).executes(context -> MedicalConditionCommands.queryMedicalConditions(EntityArgument.m_91474_((CommandContext)context, (String)"target")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"clear").requires(ctx -> ctx.m_6761_(3))).executes(ctx -> MedicalConditionCommands.clearMedicalConditions(Collections.singleton(((CommandSourceStack)ctx.getSource()).m_81375_()), null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).executes(ctx -> MedicalConditionCommands.clearMedicalConditions(EntityArgument.m_91477_((CommandContext)ctx, (String)"targets"), null))).then(Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(ctx -> {
            Collection targets = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            MedicalCondition condition = MedicalConditionArgument.getCondition(ctx, "condition");
            return MedicalConditionCommands.clearMedicalConditions(targets, condition);
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"apply").requires(ctx -> ctx.m_6761_(2))).then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"condition", (ArgumentType)MedicalConditionArgument.medicalCondition()).executes(ctx -> {
            MedicalCondition condition = MedicalConditionArgument.getCondition(ctx, "condition");
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            return MedicalConditionCommands.applyMedicalConditions(players, condition, 1.0f);
        })).then(Commands.m_82129_((String)"progression_multiplier", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(ctx -> {
            MedicalCondition condition = MedicalConditionArgument.getCondition(ctx, "condition");
            Collection players = EntityArgument.m_91477_((CommandContext)ctx, (String)"targets");
            float strength = FloatArgumentType.getFloat((CommandContext)ctx, (String)"progression_multiplier");
            return MedicalConditionCommands.applyMedicalConditions(players, condition, strength);
        }))))));
    }

    private static int queryMedicalConditions(ServerPlayer target) throws CommandSyntaxException {
        IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)target);
        if (tracker == null) {
            throw EntityArgument.f_91440_.create();
        }
        int count = tracker.getMedicalConditions().size();
        if (count == 0) {
            target.m_213846_((Component)Component.m_237110_((String)"command.gtceu.medical_condition.get.empty", (Object[])new Object[]{target.m_7755_()}));
        } else {
            target.m_213846_((Component)Component.m_237110_((String)"command.gtceu.medical_condition.get", (Object[])new Object[]{target.m_7755_()}));
        }
        for (Object2FloatMap.Entry entry : tracker.getMedicalConditions().object2FloatEntrySet()) {
            String langKey = "command.gtceu.medical_condition.get.element";
            if (((MedicalCondition)entry.getKey()).maxProgression * 2.0f <= entry.getFloatValue() && ((MedicalCondition)entry.getKey()).canBePermanent) {
                langKey = "command.gtceu.medical_condition.get.element.permanent";
            }
            float time = entry.getFloatValue();
            target.m_213846_((Component)Component.m_237110_((String)langKey, (Object[])new Object[]{Component.m_237115_((String)("gtceu.medical_condition." + ((MedicalCondition)entry.getKey()).name)), (int)(time / 60.0f), (int)(time % 60.0f)}));
        }
        return count;
    }

    private static int clearMedicalConditions(Collection<ServerPlayer> targets, @Nullable MedicalCondition condition) throws CommandSyntaxException {
        int count = 0;
        for (ServerPlayer target : targets) {
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)target);
            if (tracker == null) continue;
            if (condition == null) {
                count += tracker.getMedicalConditions().keySet().size();
                for (MedicalCondition medicalCondition : tracker.getMedicalConditions().keySet()) {
                    tracker.removeMedicalCondition(medicalCondition);
                }
                continue;
            }
            ++count;
            tracker.removeMedicalCondition(condition);
        }
        if (count == 0) {
            throw ERROR_CLEAR_EVERYTHING_FAILED.create();
        }
        return count;
    }

    private static int applyMedicalConditions(Collection<ServerPlayer> targets, MedicalCondition condition, float strength) throws CommandSyntaxException {
        int success = 0;
        for (ServerPlayer player : targets) {
            IMedicalConditionTracker tracker = GTCapabilityHelper.getMedicalConditionTracker((Entity)player);
            if (tracker == null) continue;
            tracker.progressCondition(condition, strength);
            ++success;
        }
        if (success == 0) {
            throw ERROR_GIVE_FAILED.create();
        }
        return success;
    }
}

