/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover.detector;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.IUICover;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandler;
import com.gregtechceu.gtceu.api.cover.filter.FilterHandlers;
import com.gregtechceu.gtceu.api.cover.filter.FluidFilter;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.api.gui.widget.ToggleButtonWidget;
import com.gregtechceu.gtceu.common.cover.detector.DetectorCover;
import com.gregtechceu.gtceu.common.cover.detector.FluidDetectorCover;
import com.gregtechceu.gtceu.utils.RedstoneUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextBoxWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class AdvancedFluidDetectorCover
extends FluidDetectorCover
implements IUICover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AdvancedFluidDetectorCover.class, DetectorCover.MANAGED_FIELD_HOLDER);
    private static final int DEFAULT_MIN = 64;
    private static final int DEFAULT_MAX = 512;
    @Persisted
    private int minValue = 64;
    @Persisted
    private int maxValue = 512;
    @Persisted
    @DescSynced
    private boolean isLatched;
    @Persisted
    @DescSynced
    protected final FilterHandler<FluidStack, FluidFilter> filterHandler = FilterHandlers.fluid(this);

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public AdvancedFluidDetectorCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide) {
        super(definition, coverHolder, attachedSide);
    }

    @Override
    public List<ItemStack> getAdditionalDrops() {
        List<ItemStack> list = super.getAdditionalDrops();
        if (!this.filterHandler.getFilterItem().m_41619_()) {
            list.add(this.filterHandler.getFilterItem());
        }
        return list;
    }

    @Override
    protected void update() {
        if (this.coverHolder.getOffsetTimer() % 20L != 0L) {
            return;
        }
        FluidFilter filter = this.filterHandler.getFilter();
        IFluidHandler fluidHandler = this.getFluidHandler();
        if (fluidHandler == null) {
            return;
        }
        long storedFluid = 0L;
        for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
            FluidStack content = fluidHandler.getFluidInTank(tank);
            if (content.isEmpty() || !filter.test(content)) continue;
            storedFluid += (long)content.getAmount();
        }
        if (this.isLatched) {
            this.setRedstoneSignalOutput(RedstoneUtil.computeLatchedRedstoneBetweenValues(storedFluid, this.maxValue, this.minValue, this.isInverted(), this.redstoneSignalOutput));
        } else {
            this.setRedstoneSignalOutput(RedstoneUtil.computeRedstoneBetweenValues(storedFluid, this.maxValue, this.minValue, this.isInverted()));
        }
    }

    public void setMinValue(int minValue) {
        this.minValue = Mth.m_14045_((int)minValue, (int)0, (int)(this.maxValue - 1));
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = Math.max(maxValue, 0);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 176, 170);
        group.addWidget((Widget)new LabelWidget(10, 5, "cover.advanced_fluid_detector.label"));
        group.addWidget((Widget)new TextBoxWidget(10, 55, 65, List.of(LocalizationUtils.format((String)"cover.advanced_fluid_detector.min", (Object[])new Object[0]))));
        group.addWidget((Widget)new TextBoxWidget(10, 80, 65, List.of(LocalizationUtils.format((String)"cover.advanced_fluid_detector.max", (Object[])new Object[0]))));
        group.addWidget((Widget)new IntInputWidget(80, 50, 86, 20, this::getMinValue, this::setMinValue));
        group.addWidget((Widget)new IntInputWidget(80, 75, 86, 20, this::getMaxValue, this::setMaxValue));
        group.addWidget((Widget)new ToggleButtonWidget(9, 20, 20, 20, (IGuiTexture)GuiTextures.INVERT_REDSTONE_BUTTON, this::isInverted, this::setInverted).isMultiLang().setTooltipText("cover.advanced_fluid_detector.invert"));
        group.addWidget((Widget)new ToggleButtonWidget(31, 21, 18, 18, (IGuiTexture)GuiTextures.BUTTON_LOCK, this::isLatched, this::setLatched).setShouldUseBaseBackground().isMultiLang().setTooltipText("cover.advanced_detector.latch"));
        group.addWidget(this.filterHandler.createFilterSlotUI(148, 100));
        group.addWidget(this.filterHandler.createFilterConfigUI(10, 100, 156, 60));
        return group;
    }

    @Generated
    public int getMinValue() {
        return this.minValue;
    }

    @Generated
    public int getMaxValue() {
        return this.maxValue;
    }

    @Generated
    public boolean isLatched() {
        return this.isLatched;
    }

    @Generated
    public void setLatched(boolean isLatched) {
        this.isLatched = isLatched;
    }

    @Generated
    public FilterHandler<FluidStack, FluidFilter> getFilterHandler() {
        return this.filterHandler;
    }
}

