/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTCEuAPI;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.recipe.condition.AdjacentBlockCondition;
import com.gregtechceu.gtceu.common.recipe.condition.AdjacentFluidCondition;
import com.gregtechceu.gtceu.common.recipe.condition.BiomeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.CleanroomCondition;
import com.gregtechceu.gtceu.common.recipe.condition.DaytimeCondition;
import com.gregtechceu.gtceu.common.recipe.condition.DimensionCondition;
import com.gregtechceu.gtceu.common.recipe.condition.EUToStartCondition;
import com.gregtechceu.gtceu.common.recipe.condition.EnvironmentalHazardCondition;
import com.gregtechceu.gtceu.common.recipe.condition.FTBQuestCondition;
import com.gregtechceu.gtceu.common.recipe.condition.GameStageCondition;
import com.gregtechceu.gtceu.common.recipe.condition.HeraclesQuestCondition;
import com.gregtechceu.gtceu.common.recipe.condition.PositionYCondition;
import com.gregtechceu.gtceu.common.recipe.condition.RainingCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.gregtechceu.gtceu.common.recipe.condition.ThunderCondition;
import com.gregtechceu.gtceu.common.recipe.condition.VentCondition;
import com.mojang.serialization.Codec;
import net.minecraftforge.fml.ModLoader;

public final class GTRecipeConditions {
    public static final RecipeConditionType<BiomeCondition> BIOME;
    public static final RecipeConditionType<DimensionCondition> DIMENSION;
    public static final RecipeConditionType<PositionYCondition> POSITION_Y;
    public static final RecipeConditionType<RainingCondition> RAINING;
    public static final RecipeConditionType<AdjacentFluidCondition> ADJACENT_FLUID;
    public static final RecipeConditionType<AdjacentBlockCondition> ADJACENT_BLOCK;
    public static final RecipeConditionType<ThunderCondition> THUNDER;
    public static final RecipeConditionType<VentCondition> VENT;
    public static final RecipeConditionType<CleanroomCondition> CLEANROOM;
    public static final RecipeConditionType<EUToStartCondition> EU_TO_START;
    public static final RecipeConditionType<ResearchCondition> RESEARCH;
    public static final RecipeConditionType<EnvironmentalHazardCondition> ENVIRONMENTAL_HAZARD;
    public static final RecipeConditionType<DaytimeCondition> DAYTIME;
    public static RecipeConditionType<FTBQuestCondition> FTB_QUEST;
    public static RecipeConditionType<GameStageCondition> GAMESTAGE;
    public static RecipeConditionType<HeraclesQuestCondition> HERACLES_QUEST;

    private GTRecipeConditions() {
    }

    public static void init() {
        if (GTCEu.Mods.isFTBQuestsLoaded()) {
            FTB_QUEST = GTRecipeConditions.register("ftb_quest", FTBQuestCondition::new, FTBQuestCondition.CODEC);
        }
        if (GTCEu.Mods.isGameStagesLoaded()) {
            GAMESTAGE = GTRecipeConditions.register("game_stage", GameStageCondition::new, GameStageCondition.CODEC);
        }
        if (GTCEu.Mods.isHeraclesLoaded()) {
            HERACLES_QUEST = GTRecipeConditions.register("heracles_quest", HeraclesQuestCondition::new, HeraclesQuestCondition.CODEC);
        }
        GTRegistries.RECIPE_CONDITIONS.remap("rock_breaker", "adjacent_fluid");
        ModLoader.get().postEvent(new GTCEuAPI.RegisterEvent(GTRegistries.RECIPE_CONDITIONS, RecipeConditionType.class));
        GTRegistries.RECIPE_CONDITIONS.freeze();
    }

    private static <T extends RecipeCondition> RecipeConditionType<T> register(String name, RecipeConditionType.ConditionFactory<T> factory, Codec<T> codec) {
        return GTRegistries.RECIPE_CONDITIONS.register(name, new RecipeConditionType<T>(factory, codec));
    }

    static {
        GTRegistries.RECIPE_CONDITIONS.unfreeze();
        BIOME = GTRecipeConditions.register("biome", BiomeCondition::new, BiomeCondition.CODEC);
        DIMENSION = GTRecipeConditions.register("dimension", DimensionCondition::new, DimensionCondition.CODEC);
        POSITION_Y = GTRecipeConditions.register("pos_y", PositionYCondition::new, PositionYCondition.CODEC);
        RAINING = GTRecipeConditions.register("rain", RainingCondition::new, RainingCondition.CODEC);
        ADJACENT_FLUID = GTRecipeConditions.register("adjacent_fluid", AdjacentFluidCondition::new, AdjacentFluidCondition.CODEC);
        ADJACENT_BLOCK = GTRecipeConditions.register("adjacent_block", AdjacentBlockCondition::new, AdjacentBlockCondition.CODEC);
        THUNDER = GTRecipeConditions.register("thunder", ThunderCondition::new, ThunderCondition.CODEC);
        VENT = GTRecipeConditions.register("steam_vent", VentCondition::new, VentCondition.CODEC);
        CLEANROOM = GTRecipeConditions.register("cleanroom", CleanroomCondition::new, CleanroomCondition.CODEC);
        EU_TO_START = GTRecipeConditions.register("eu_to_start", EUToStartCondition::new, EUToStartCondition.CODEC);
        RESEARCH = GTRecipeConditions.register("research", ResearchCondition::new, ResearchCondition.CODEC);
        ENVIRONMENTAL_HAZARD = GTRecipeConditions.register("environmental_hazard", EnvironmentalHazardCondition::new, EnvironmentalHazardCondition.CODEC);
        DAYTIME = GTRecipeConditions.register("daytime", DaytimeCondition::new, DaytimeCondition.CODEC);
    }
}

