/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.data.models;

import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.provider.GTBlockstateProvider;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.model.machine.overlays.EnergyIOOverlay;
import com.gregtechceu.gtceu.client.model.machine.overlays.HPCAOverlay;
import com.gregtechceu.gtceu.client.model.machine.overlays.WorkableOverlays;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import com.gregtechceu.gtceu.common.machine.electric.ChargerMachine;
import com.gregtechceu.gtceu.common.machine.multiblock.part.DiodePartMachine;
import com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import org.jetbrains.annotations.Nullable;

public class GTMachineModels {
    public static final String OVERLAY_PREFIX = "overlay_";
    public static final String EMISSIVE_SUFFIX = "_emissive";
    public static final ResourceLocation SIDED_SIDED_OVERLAY_MODEL = GTCEu.id("block/machine/template/sided/sided");
    public static final ResourceLocation SIDED_SINGLE_OVERLAY_MODEL = GTCEu.id("block/machine/template/sided/single");
    public static final ResourceLocation CUBE_ALL_SIDED_OVERLAY_MODEL = GTCEu.id("block/machine/template/cube_all/sided");
    public static final ResourceLocation CUBE_ALL_SINGLE_OVERLAY_MODEL = GTCEu.id("block/machine/template/cube_all/single");
    public static final Int2ObjectMap<ResourceLocation> TIERED_HULL_MODELS = (Int2ObjectMap)Util.m_137469_((Object)new Int2ObjectOpenHashMap(), map -> {
        for (int tier : GTValues.ALL_TIERS) {
            String vn = GTValues.VN[tier].toLowerCase(Locale.ROOT);
            map.put(tier, (Object)GTCEu.id("block/casings/voltage/" + vn));
        }
        map.defaultReturnValue((Object)GTCEu.id("block/casings/voltage/lv"));
    });
    public static final ResourceLocation LP_STEAM_HULL_MODEL = GTCEu.id("block/casings/steam/bricked_bronze");
    public static final ResourceLocation HP_STEAM_HULL_MODEL = GTCEu.id("block/casings/steam/bricked_steel");
    public static final ResourceLocation HATCH_PART_MODEL = GTCEu.id("block/machine/template/part/hatch_machine");
    public static final ResourceLocation HATCH_PART_COLOR_RING_MODEL = GTCEu.id("block/machine/template/part/hatch_machine_color_ring");
    public static final ResourceLocation HATCH_PART_EMISSIVE_MODEL = GTCEu.id("block/machine/template/part/hatch_machine_emissive");
    public static final ResourceLocation HATCH_PART_EMISSIVE_COLOR_RING_MODEL = GTCEu.id("block/machine/template/part/hatch_machine_emissive_color_ring");
    public static final ResourceLocation VENT_OVERLAY = GTCEu.id("block/overlay/machine/overlay_steam_vent");
    public static final String OVERLAY_FLUID_HATCH_INPUT = "overlay_fluid_hatch_input";
    public static final String OVERLAY_FLUID_HATCH_OUTPUT = "overlay_fluid_hatch_output";
    public static final String OVERLAY_ITEM_HATCH_INPUT = "overlay_item_hatch_input";
    public static final String OVERLAY_ITEM_HATCH_OUTPUT = "overlay_item_hatch_output";
    @Deprecated
    public static final String OVERLAY_FLUID_HATCH_TEX = "overlay_fluid_hatch";
    @Deprecated
    public static final String OVERLAY_FLUID_HATCH_HALF_PX_TEX = "overlay_fluid_hatch_half_px_out";
    @Deprecated
    public static final String OVERLAY_ITEM_HATCH = "overlay_item_hatch";
    public static final ResourceLocation GENERATOR_MODEL = GTCEu.id("block/machine/template/generator_machine");
    public static final ResourceLocation CHARGER_IDLE = GTCEu.id("block/machines/charger/overlay_charger_idle");
    public static final ResourceLocation CHARGER_RUNNING = GTCEu.id("block/machines/charger/overlay_charger_running");
    public static final ResourceLocation CHARGER_RUNNING_EMISSIVE = GTCEu.id("block/machines/charger/overlay_charger_running_emissive");
    public static final ResourceLocation CHARGER_FINISHED = GTCEu.id("block/machines/charger/overlay_charger_finished");
    public static final ResourceLocation CHARGER_FINISHED_EMISSIVE = GTCEu.id("block/machines/charger/overlay_charger_finished_emissive");
    public static final ResourceLocation TRANSFORMER_LIKE = GTCEu.id("block/machine/template/transformer_like_machine");
    public static final ResourceLocation CONVERTER_FE_IN = GTCEu.id("block/overlay/converter/converter_native_in");
    public static final ResourceLocation CONVERTER_FE_OUT = GTCEu.id("block/overlay/converter/converter_native_out");
    public static final ResourceLocation CONVERTER_FE_IN_EMISSIVE = GTCEu.id("block/overlay/converter/converter_native_in_emissive");
    public static final ResourceLocation CONVERTER_FE_OUT_EMISSIVE = GTCEu.id("block/overlay/converter/converter_native_out_emissive");
    public static final ResourceLocation ROTOR_HOLDER_BLOCK = GTCEu.id("block/machine/template/rotor_holder/block");
    public static final ResourceLocation ROTOR_HOLDER_OVERLAY = GTCEu.id("block/machine/template/rotor_holder/overlay");
    public static final ResourceLocation ROTOR_HOLDER_ROTOR_IDLE = GTCEu.id("block/machine/template/rotor_holder/rotor_idle");
    public static final ResourceLocation ROTOR_HOLDER_ROTOR_SPINNING = GTCEu.id("block/machine/template/rotor_holder/rotor_spinning");
    public static final ImmutableMap<Material, ResourceLocation> MATERIALS_TO_CASING_TEXTURES = (ImmutableMap)Util.m_137537_(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)GTMaterials.Bronze, (Object)GTCEu.id("block/casings/solid/machine_casing_bronze_plated_bricks"));
        builder.put((Object)GTMaterials.Invar, (Object)GTCEu.id("block/casings/solid/machine_casing_heatproof"));
        builder.put((Object)GTMaterials.Aluminium, (Object)GTCEu.id("block/casings/solid/machine_casing_frost_proof"));
        builder.put((Object)GTMaterials.Steel, (Object)GTCEu.id("block/casings/solid/machine_casing_solid_steel"));
        builder.put((Object)GTMaterials.StainlessSteel, (Object)GTCEu.id("block/casings/solid/machine_casing_clean_stainless_steel"));
        builder.put((Object)GTMaterials.Titanium, (Object)GTCEu.id("block/casings/solid/machine_casing_stable_titanium"));
        builder.put((Object)GTMaterials.TungstenSteel, (Object)GTCEu.id("block/casings/solid/machine_casing_robust_tungstensteel"));
        builder.put((Object)GTMaterials.Polytetrafluoroethylene, (Object)GTCEu.id("block/casings/solid/machine_casing_inert_ptfe"));
        builder.put((Object)GTMaterials.HSSE, (Object)GTCEu.id("block/casings/solid/machine_casing_sturdy_hsse"));
        return builder.build();
    });
    public static final ResourceLocation MAINTENANCE_TAPED_OVERLAY = GTCEu.id("block/overlay/machine/overlay_maintenance_taped");
    public static final ResourceLocation HPCA_PART_MODEL = GTCEu.id("block/machine/template/part/hpca_part_machine");
    public static final ResourceLocation COMPUTER_CASING_TEXTURE = GTCEu.id("block/casings/hpca/computer_casing/");
    public static final ResourceLocation ADVANCED_COMPUTER_CASING_TEXTURE = GTCEu.id("block/casings/hpca/advanced_computer_casing/");
    public static final ResourceLocation OVERLAY_SCREEN_TEXTURE = GTCEu.id("block/overlay/machine/overlay_screen");
    public static final ResourceLocation OVERLAY_QTANK_EMISSIVE_TEXTURE = GTCEu.id("block/overlay/machine/overlay_qtank_emissive");

    public static MachineBuilder.ModelInitializer createBasicMachineModel(ResourceLocation baseModel) {
        return (ctx, prov, builder) -> {
            ModelFile.ExistingModelFile model = prov.models().getExistingFile(baseModel);
            builder.forAllStatesModels(state -> model);
        };
    }

    public static MachineBuilder.ModelInitializer createBasicReplaceableTextureMachineModel(ResourceLocation baseModel) {
        return (ctx, prov, builder) -> {
            ModelFile.ExistingModelFile model = prov.models().getExistingFile(baseModel);
            builder.forAllStatesModels(state -> model);
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createTieredHullMachineModel(ResourceLocation parentModel) {
        return (ctx, prov, builder) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(parentModel));
            GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            builder.forAllStatesModels(state -> model);
        };
    }

    public static MachineBuilder.ModelInitializer createOverlayTieredHullMachineModel(ResourceLocation overlayModel) {
        return (ctx, prov, builder) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(overlayModel));
            GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            builder.forAllStatesModels(state -> model);
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createOverlayCasingMachineModel(ResourceLocation baseCasingTexture, ResourceLocation overlayModel) {
        return (ctx, prov, builder) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(overlayModel));
            model.texture("all", baseCasingTexture);
            builder.forAllStatesModels(state -> model);
            builder.addReplaceableTextures("all");
        };
    }

    public static MachineBuilder.ModelInitializer createColorOverlayTieredHullMachineModel(ResourceLocation overlay, @Nullable ResourceLocation pipeOverlay, @Nullable ResourceLocation emissiveOverlay) {
        return (ctx, prov, builder) -> {
            builder.forAllStatesModels(state -> {
                BlockModelBuilder model = GTMachineModels.colorOverlayHullModel(overlay, pipeOverlay, emissiveOverlay, state, prov.models());
                return GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            });
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createSingleOverlayTieredHullMachineModel(ResourceLocation overlayTexture, ResourceLocation emissiveOverlayTexture) {
        return (ctx, prov, builder) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(SIDED_SINGLE_OVERLAY_MODEL))).texture("overlay", overlayTexture)).texture("overlay_emissive", emissiveOverlayTexture);
            GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            builder.forAllStatesModels(state -> model);
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createWorkableTieredHullMachineModel(ResourceLocation overlayDir) {
        return (ctx, prov, builder) -> {
            WorkableOverlays overlays = WorkableOverlays.get(overlayDir, prov.getExistingFileHelper());
            builder.forAllStates(state -> {
                RecipeLogic.Status status = (RecipeLogic.Status)((Object)((Object)((Object)state.m_61143_((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS))));
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent(GTMachineModels.tieredHullModel(prov.models(), builder));
                return GTMachineModels.addWorkableOverlays(overlays, status, model);
            });
        };
    }

    public static MachineBuilder.ModelInitializer createOverlaySteamHullMachineModel(ResourceLocation overlayModel) {
        return (ctx, prov, builder) -> {
            builder.forAllStatesModels(state -> {
                boolean steel = state.m_61145_((Property)GTMachineModelProperties.IS_STEEL_MACHINE).orElse(false);
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(overlayModel));
                GTMachineModels.steamCasingTextures(model, steel);
                return model;
            });
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createColorOverlaySteamHullMachineModel(ResourceLocation overlay, @Nullable ResourceLocation pipeOverlay, @Nullable ResourceLocation emissiveOverlay) {
        return (ctx, prov, builder) -> {
            builder.forAllStatesModels(state -> {
                BlockModelBuilder model = GTMachineModels.colorOverlayHullModel(overlay, pipeOverlay, emissiveOverlay, state, prov.models());
                GTMachineModels.steamCasingTextures(model, state.m_61145_((Property)GTMachineModelProperties.IS_STEEL_MACHINE).orElse(false));
                return model;
            });
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createWorkableSteamHullMachineModel(boolean highPressure, ResourceLocation overlayDir) {
        return (ctx, prov, builder) -> {
            WorkableOverlays overlays = WorkableOverlays.get(overlayDir, prov.getExistingFileHelper());
            ModelFile parent = GTMachineModels.steamHullModel(prov.models(), highPressure);
            GTMachineModels.makeWorkableOverlayPart(prov.models(), builder, parent, overlays, RecipeLogic.Status.IDLE);
            GTMachineModels.makeWorkableOverlayPart(prov.models(), builder, parent, overlays, RecipeLogic.Status.WORKING);
            GTMachineModels.makeWorkableOverlayPart(prov.models(), builder, parent, overlays, RecipeLogic.Status.WAITING);
            GTMachineModels.makeWorkableOverlayPart(prov.models(), builder, parent, overlays, RecipeLogic.Status.SUSPEND);
            if (!builder.getOwner().defaultRenderState().m_61138_((Property)GTMachineModelProperties.VENT_DIRECTION)) {
                return;
            }
            for (RelativeDirection relative : RelativeDirection.VALUES) {
                Direction dir = relative.global;
                ((MachineModelBuilder.PartBuilder)builder.part().modelFile((ModelFile)prov.models().getExistingFile(VENT_OVERLAY)).rotationX(dir == Direction.DOWN ? 90 : (dir == Direction.UP ? 270 : 0)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).addModel()).condition((Property)GTMachineModelProperties.VENT_DIRECTION, (Comparable[])new RelativeDirection[]{relative});
            }
        };
    }

    private static void makeWorkableOverlayPart(BlockModelProvider models, MachineModelBuilder<BlockModelBuilder> builder, ModelFile parentModel, WorkableOverlays overlays, RecipeLogic.Status status) {
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)models.nested()).parent(parentModel);
        GTMachineModels.addWorkableOverlays(overlays, status, model);
        builder.part((ModelFile)model).condition((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable[])new RecipeLogic.Status[]{status});
    }

    public static MachineBuilder.ModelInitializer createWorkableCasingMachineModel(ResourceLocation baseCasingTexture, ResourceLocation overlayDir) {
        return (ctx, prov, builder) -> {
            WorkableOverlays overlays = WorkableOverlays.get(overlayDir, prov.getExistingFileHelper());
            builder.forAllStates(state -> {
                RecipeLogic.Status status = (RecipeLogic.Status)((Object)((Object)((Object)state.m_61143_((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS))));
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(CUBE_ALL_SIDED_OVERLAY_MODEL))).texture("all", baseCasingTexture);
                return GTMachineModels.addWorkableOverlays(overlays, status, model);
            });
            builder.addTextureOverride("all", baseCasingTexture);
        };
    }

    public static MachineBuilder.ModelInitializer createSidedOverlayCasingMachineModel(ResourceLocation baseCasingTexture, ResourceLocation overlayModel) {
        return (ctx, prov, builder) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(overlayModel));
            GTMachineModels.casingTextures(model, baseCasingTexture);
            builder.forAllStatesModels(state -> model);
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createSidedWorkableCasingMachineModel(ResourceLocation baseCasingTexture, ResourceLocation overlayDir) {
        return (ctx, prov, builder) -> {
            WorkableOverlays overlays = WorkableOverlays.get(overlayDir, prov.getExistingFileHelper());
            builder.forAllStates(state -> {
                RecipeLogic.Status status = (RecipeLogic.Status)((Object)((Object)((Object)state.m_61143_((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS))));
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(SIDED_SIDED_OVERLAY_MODEL));
                GTMachineModels.casingTextures(model, baseCasingTexture);
                return GTMachineModels.addWorkableOverlays(overlays, status, model);
            });
            ResourceLocation texturePath = baseCasingTexture;
            if (!texturePath.m_135815_().endsWith("/")) {
                texturePath = texturePath.m_266382_("/");
            }
            builder.addTextureOverride("bottom", texturePath.m_266382_("bottom"));
            builder.addTextureOverride("top", texturePath.m_266382_("top"));
            builder.addTextureOverride("side", texturePath.m_266382_("side"));
        };
    }

    public static MachineBuilder.ModelInitializer createSimpleGeneratorModel(ResourceLocation overlayDir) {
        return (ctx, prov, builder) -> {
            WorkableOverlays overlays = WorkableOverlays.get(overlayDir, prov.getExistingFileHelper());
            builder.forAllStatesModels(state -> {
                RecipeLogic.Status status = (RecipeLogic.Status)((Object)((Object)((Object)state.m_61143_((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS))));
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(GENERATOR_MODEL));
                GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
                GTMachineModels.addWorkableOverlays(overlays, status, model);
                return model;
            });
        };
    }

    public static MachineBuilder.ModelInitializer createBatteryBufferModel(int inventorySize) {
        return (ctx, prov, builder) -> {
            EnergyIOOverlay overlay = (EnergyIOOverlay)EnergyIOOverlay.OUT_OVERLAYS_FOR_AMP.get(inventorySize);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(TRANSFORMER_LIKE))).texture("overlay_in_io", overlay.getIoPart())).texture("overlay_in_tinted", overlay.getTintedPart())).texture("overlay_out_io", GTModels.BLANK_TEXTURE);
            GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            builder.forAllStatesModels(state -> model);
        };
    }

    public static MachineBuilder.ModelInitializer createChargerModel() {
        return (ctx, prov, builder) -> builder.forAllStatesModels(renderState -> {
            ChargerMachine.State state = (ChargerMachine.State)((Object)((Object)((Object)renderState.m_61143_((Property)GTMachineModelProperties.CHARGER_STATE))));
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(SIDED_SIDED_OVERLAY_MODEL));
            GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            switch (state) {
                case IDLE: {
                    model.texture("overlay_front", CHARGER_IDLE);
                    break;
                }
                case RUNNING: {
                    model.texture("overlay_front", CHARGER_RUNNING);
                    model.texture("overlay_front_emissive", CHARGER_RUNNING_EMISSIVE);
                    break;
                }
                case FINISHED: {
                    model.texture("overlay_front", CHARGER_FINISHED);
                    model.texture("overlay_front_emissive", CHARGER_FINISHED_EMISSIVE);
                }
            }
            return model;
        });
    }

    public static MachineBuilder.ModelInitializer createConverterModel(int amperage) {
        return (ctx, prov, builder) -> {
            EnergyIOOverlay energyIn = (EnergyIOOverlay)EnergyIOOverlay.IN_OVERLAYS_FOR_AMP.get(amperage);
            EnergyIOOverlay energyOut = (EnergyIOOverlay)EnergyIOOverlay.OUT_OVERLAYS_FOR_AMP.get(amperage);
            BlockModelBuilder euToFeModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(TRANSFORMER_LIKE))).texture("overlay_in_io", energyIn.getIoPart())).texture("overlay_in_tinted", energyIn.getTintedPart())).texture("overlay_in_io_emissive", energyIn.getIoPartEmissive())).texture("overlay_out_io_emissive", CONVERTER_FE_OUT_EMISSIVE)).texture("overlay_out_io", CONVERTER_FE_OUT);
            GTMachineModels.tieredHullTextures(euToFeModel, builder.getOwner().getTier());
            BlockModelBuilder feToEuModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(TRANSFORMER_LIKE))).texture("overlay_in_io", energyOut.getIoPart())).texture("overlay_in_tinted", energyOut.getTintedPart())).texture("overlay_in_io_emissive", energyOut.getIoPartEmissive())).texture("overlay_out_io_emissive", CONVERTER_FE_IN_EMISSIVE)).texture("overlay_out_io", CONVERTER_FE_IN);
            GTMachineModels.tieredHullTextures(feToEuModel, builder.getOwner().getTier());
            builder.partialState().with(GTMachineModelProperties.IS_FE_TO_EU, false).setModel((ModelFile)euToFeModel).partialState().with(GTMachineModelProperties.IS_FE_TO_EU, true).setModel((ModelFile)feToEuModel).end();
        };
    }

    public static MachineBuilder.ModelInitializer createCrateModel(boolean wooden) {
        return (ctx, prov, builder) -> {
            String modelPath = "block/machine/template/crate/" + (wooden ? "wooden" : "metal") + "_crate";
            ModelFile.ExistingModelFile baseModel = prov.models().getExistingFile(GTCEu.id(modelPath));
            ModelFile.ExistingModelFile tapedModel = prov.models().getExistingFile(GTCEu.id(modelPath + "_taped"));
            builder.forAllStatesModels(arg_0 -> GTMachineModels.lambda$createCrateModel$35((ModelFile)tapedModel, (ModelFile)baseModel, arg_0));
        };
    }

    public static MachineBuilder.ModelInitializer createDiodeModel() {
        return (ctx, prov, builder) -> {
            builder.forAllStatesModels(renderState -> {
                DiodePartMachine.AmpMode mode = (DiodePartMachine.AmpMode)((Object)((Object)((Object)renderState.m_61143_((Property)GTMachineModelProperties.DIODE_AMP_MODE))));
                EnergyIOOverlay energyIn = (EnergyIOOverlay)EnergyIOOverlay.IN_OVERLAYS_FOR_AMP.get(mode.getAmpValue());
                EnergyIOOverlay energyOut = (EnergyIOOverlay)EnergyIOOverlay.OUT_OVERLAYS_FOR_AMP.get(mode.getAmpValue());
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(TRANSFORMER_LIKE))).texture("overlay_in_io_emissive", energyIn.getIoPartEmissive())).texture("overlay_in_io", energyIn.getIoPart())).texture("overlay_in_tinted", energyIn.getTintedPart())).texture("overlay_out_io_emissive", energyOut.getIoPartEmissive())).texture("overlay_out_io", energyOut.getIoPart())).texture("overlay_out_tinted", energyOut.getTintedPart());
                GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
                return model;
            });
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createTransformerModel(int baseAmp) {
        return (ctx, prov, builder) -> builder.forAllStatesModels(renderState -> {
            boolean transformUp = (Boolean)renderState.m_61143_((Property)GTMachineModelProperties.IS_TRANSFORM_UP);
            EnergyIOOverlay frontFace = (EnergyIOOverlay)(transformUp ? EnergyIOOverlay.OUT_OVERLAYS_FOR_AMP : EnergyIOOverlay.IN_OVERLAYS_FOR_AMP).get(baseAmp);
            EnergyIOOverlay otherFace = (EnergyIOOverlay)(transformUp ? EnergyIOOverlay.IN_OVERLAYS_FOR_AMP : EnergyIOOverlay.OUT_OVERLAYS_FOR_AMP).get(baseAmp * 4);
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(TRANSFORMER_LIKE))).texture("overlay_in_io", frontFace.getIoPart())).texture("overlay_in_io_emissive", frontFace.getIoPartEmissive())).texture("overlay_in_tinted", frontFace.getTintedPart())).texture("overlay_out_io_emissive", otherFace.getIoPartEmissive())).texture("overlay_out_tinted", otherFace.getTintedPart());
            GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            return model;
        });
    }

    public static MachineBuilder.ModelInitializer createRotorHolderModel() {
        return (ctx, prov, builder) -> {
            BlockModelProvider models = prov.models();
            BlockModelBuilder blockModel = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(ROTOR_HOLDER_BLOCK));
            GTMachineModels.tieredHullTextures(blockModel, builder.getOwner().getTier());
            builder.part((ModelFile)blockModel).end();
            builder.part(ROTOR_HOLDER_OVERLAY).condition((Property)GTMachineModelProperties.IS_FORMED, new Boolean[]{true}).end();
            GTMachineModels.makeRotorHolderState(builder, models, ROTOR_HOLDER_ROTOR_IDLE, false, false);
            GTMachineModels.makeRotorHolderState(builder, models, ROTOR_HOLDER_ROTOR_IDLE.m_266382_(EMISSIVE_SUFFIX), false, true);
            GTMachineModels.makeRotorHolderState(builder, models, ROTOR_HOLDER_ROTOR_SPINNING, true, false);
            GTMachineModels.makeRotorHolderState(builder, models, ROTOR_HOLDER_ROTOR_SPINNING.m_266382_(EMISSIVE_SUFFIX), true, true);
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    private static void makeRotorHolderState(MachineModelBuilder<BlockModelBuilder> builder, BlockModelProvider provider, ResourceLocation model, boolean spinning, boolean emissive) {
        builder.partialState().with(GTMachineModelProperties.IS_FORMED, true).with(GTMachineModelProperties.HAS_ROTOR, true).with(GTMachineModelProperties.IS_ROTOR_SPINNING, spinning).with(GTMachineModelProperties.IS_EMISSIVE_ROTOR, emissive).setModel((ModelFile)provider.getExistingFile(model));
    }

    public static MachineBuilder.ModelInitializer createWorldAcceleratorModel(ResourceLocation beModeModelPath, ResourceLocation rtModeModelPath) {
        return (ctx, prov, builder) -> {
            WorkableOverlays rtOverlays = WorkableOverlays.get(rtModeModelPath, prov.getExistingFileHelper());
            WorkableOverlays beOverlays = WorkableOverlays.get(beModeModelPath, prov.getExistingFileHelper());
            builder.forAllStates(state -> {
                boolean rtMode = (Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_RANDOM_TICK_MODE);
                WorkableOverlays overlays = rtMode ? rtOverlays : beOverlays;
                boolean active = (Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_ACTIVE);
                boolean workingEnabled = (Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_WORKING_ENABLED);
                RecipeLogic.Status status = active ? (workingEnabled ? RecipeLogic.Status.WORKING : RecipeLogic.Status.SUSPEND) : RecipeLogic.Status.IDLE;
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(SIDED_SIDED_OVERLAY_MODEL));
                GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
                return GTMachineModels.addWorkableOverlays(overlays, status, model);
            });
        };
    }

    public static MachineBuilder.ModelInitializer createMaintenanceModel(ResourceLocation overlayModel) {
        return (ctx, prov, builder) -> {
            builder.forAllStatesModels(state -> {
                BlockModelBuilder baseModel = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(overlayModel));
                GTMachineModels.tieredHullTextures(baseModel, builder.getOwner().getTier());
                if (((Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_TAPED)).booleanValue()) {
                    baseModel.texture("overlay_2", MAINTENANCE_TAPED_OVERLAY);
                }
                return baseModel;
            });
            builder.addReplaceableTextures("bottom", "top", "side");
        };
    }

    public static MachineBuilder.ModelInitializer createHPCAPartModel(boolean advanced, ResourceLocation normalTexture, ResourceLocation damagedTexture) {
        return (ctx, prov, builder) -> {
            ResourceLocation textures = advanced ? ADVANCED_COMPUTER_CASING_TEXTURE : COMPUTER_CASING_TEXTURE;
            HPCAOverlay overlay = HPCAOverlay.get(normalTexture, damagedTexture, prov.getExistingFileHelper());
            BlockModelBuilder baseModel = (BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_base", HPCA_PART_MODEL);
            GTMachineModels.casingTexture(baseModel, "bottom", textures);
            GTMachineModels.casingTexture(baseModel, "top", textures);
            GTMachineModels.casingTexture(baseModel, "front", textures);
            GTMachineModels.casingTexture(baseModel, "back", textures);
            GTMachineModels.casingTexture(baseModel, "side", textures);
            builder.forAllStatesModels(state -> {
                boolean damaged = (Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_HPCA_PART_DAMAGED);
                boolean active = (Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_ACTIVE);
                return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)baseModel)).texture("overlay", overlay.getTexture(active, damaged))).texture("overlay_emissive", overlay.getEmissiveTexture(active, damaged));
            });
        };
    }

    public static MachineBuilder.ModelInitializer createFisherModel() {
        return (ctx, prov, builder) -> {
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(GTCEu.id("block/overlay/2_layer/top_emissive")))).texture("overlay", OVERLAY_SCREEN_TEXTURE)).texture("overlay_emissive", OVERLAY_QTANK_EMISSIVE_TEXTURE);
            GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
            builder.forAllStatesModels(state -> model);
        };
    }

    public static MachineBuilder.ModelInitializer createItemCollectorModel(ResourceLocation overlayDir) {
        return (ctx, prov, builder) -> {
            WorkableOverlays overlays = WorkableOverlays.get(overlayDir, prov.getExistingFileHelper());
            builder.forAllStates(state -> {
                boolean active = (Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_ACTIVE);
                boolean workingEnabled = (Boolean)state.m_61143_((Property)GTMachineModelProperties.IS_WORKING_ENABLED);
                RecipeLogic.Status status = active ? (workingEnabled ? RecipeLogic.Status.WORKING : RecipeLogic.Status.SUSPEND) : RecipeLogic.Status.IDLE;
                BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)prov.models().nested()).parent((ModelFile)prov.models().getExistingFile(SIDED_SIDED_OVERLAY_MODEL));
                GTMachineModels.tieredHullTextures(model, builder.getOwner().getTier());
                return GTMachineModels.addWorkableOverlays(overlays, status, model);
            });
        };
    }

    public static NonNullBiConsumer<DataGenContext<Block, ? extends Block>, GTBlockstateProvider> createMachineModel(MachineBuilder.ModelInitializer modelInitializer) {
        return (ctx, prov) -> {
            Block block = (Block)ctx.getEntry();
            if (!(block instanceof IMachineBlock)) {
                throw new IllegalArgumentException("passed block must be a machine block, is " + block.getClass().getName());
            }
            IMachineBlock machineBlock = (IMachineBlock)block;
            MachineDefinition definition = machineBlock.getDefinition();
            String modelLocation = ctx.getId().m_246208_("block/machine/").toString();
            MachineModelBuilder builder = (MachineModelBuilder)((BlockModelBuilder)prov.models().getBuilder(modelLocation)).customLoader(MachineModelBuilder.begin(definition));
            modelInitializer.configureModel((DataGenContext<Block, ? extends Block>)ctx, (GTBlockstateProvider)((Object)prov), builder);
            BlockModelBuilder model = (BlockModelBuilder)builder.end();
            model.parent((ModelFile)prov.models().getExistingFile(prov.mcLoc("block/block")));
            MultiVariantGenerator generator = prov.multiVariantGenerator(block, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model.getLocation()));
            PropertyDispatch dispatch = GTBlockstateProvider.createFacingDispatch(definition);
            if (dispatch != null) {
                generator.m_125271_(dispatch);
            }
        };
    }

    public static ConfiguredModel[] addWorkableOverlays(WorkableOverlays overlays, RecipeLogic.Status status, BlockModelBuilder model) {
        for (Map.Entry<WorkableOverlays.OverlayFace, WorkableOverlays.StatusTextures> entry : overlays.getTextures().entrySet()) {
            WorkableOverlays.OverlayFace face = entry.getKey();
            WorkableOverlays.StatusTextures textures = entry.getValue();
            ResourceLocation overlay = textures.getTexture(status);
            ResourceLocation overlayEmissive = textures.getEmissiveTexture(status);
            if (overlay != GTModels.BLANK_TEXTURE) {
                model.texture(OVERLAY_PREFIX + face.getName(), overlay);
            }
            if (overlayEmissive == GTModels.BLANK_TEXTURE) continue;
            model.texture(OVERLAY_PREFIX + face.getName() + EMISSIVE_SUFFIX, overlayEmissive);
        }
        return ConfiguredModel.builder().modelFile((ModelFile)model).build();
    }

    public static BlockModelBuilder colorOverlayHullModel(ResourceLocation overlay, @Nullable ResourceLocation pipeOverlay, @Nullable ResourceLocation emissiveOverlay, MachineRenderState state, BlockModelProvider models) {
        ResourceLocation parent = state.m_61145_((Property)GTMachineModelProperties.IS_PAINTED).orElse(false) != false ? (emissiveOverlay != null ? HATCH_PART_EMISSIVE_COLOR_RING_MODEL : HATCH_PART_COLOR_RING_MODEL) : (emissiveOverlay != null ? HATCH_PART_EMISSIVE_MODEL : HATCH_PART_MODEL);
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)models.nested()).parent((ModelFile)models.getExistingFile(parent))).texture("overlay", overlay);
        if (emissiveOverlay != null) {
            model.texture("overlay_emissive", emissiveOverlay);
        }
        if (pipeOverlay != null) {
            model.texture("overlay_pipe", pipeOverlay);
        }
        return model;
    }

    public static ModelFile tieredHullModel(BlockModelProvider models, MachineModelBuilder<BlockModelBuilder> builder) {
        return GTMachineModels.tieredHullModel(models, builder.getOwner().getTier());
    }

    public static ModelFile tieredHullModel(BlockModelProvider models, int tier) {
        return models.getExistingFile((ResourceLocation)TIERED_HULL_MODELS.get(tier));
    }

    public static ModelFile steamHullModel(BlockModelProvider models, boolean highPressure) {
        return models.getExistingFile(highPressure ? HP_STEAM_HULL_MODEL : LP_STEAM_HULL_MODEL);
    }

    public static ResourceLocation getTieredHullTexture(int tier) {
        return GTCEu.id("block/casings/voltage/%s/".formatted(GTValues.VN[tier].toLowerCase(Locale.ROOT)));
    }

    public static BlockModelBuilder tieredHullTextures(BlockModelBuilder model, int tier) {
        return GTMachineModels.casingTextures(model, GTMachineModels.getTieredHullTexture(tier));
    }

    public static ResourceLocation getSteamCasingTexture(boolean steel) {
        return GTCEu.id("block/casings/steam/%s/".formatted(steel ? "steel" : "bronze"));
    }

    public static BlockModelBuilder steamCasingTextures(BlockModelBuilder model, boolean steel) {
        return GTMachineModels.casingTextures(model, GTMachineModels.getSteamCasingTexture(steel));
    }

    public static void casingTexture(BlockModelBuilder model, String key, ResourceLocation texturePath) {
        model.texture(key, texturePath.m_266382_(key));
    }

    public static BlockModelBuilder casingTextures(BlockModelBuilder model, ResourceLocation texturePath) {
        if (!texturePath.m_135815_().endsWith("/")) {
            texturePath = texturePath.m_266382_("/");
        }
        GTMachineModels.casingTexture(model, "bottom", texturePath);
        GTMachineModels.casingTexture(model, "top", texturePath);
        GTMachineModels.casingTexture(model, "side", texturePath);
        return model;
    }

    private static /* synthetic */ ModelFile lambda$createCrateModel$35(ModelFile tapedModel, ModelFile baseModel, MachineRenderState state) {
        if (state.m_61145_((Property)GTMachineModelProperties.IS_TAPED).orElse(false).booleanValue()) {
            return tapedModel;
        }
        return baseModel;
    }
}

