/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import appeng.api.util.AEColor;
import appeng.blockentity.networking.CableBusBlockEntity;
import com.google.common.collect.ImmutableMap;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDurabilityBar;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.gregtechceu.gtceu.utils.BreadthFirstBlockSearch;
import com.gregtechceu.gtceu.utils.GradientUtil;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.FastColor;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;

public class ColorSprayBehaviour
implements IDurabilityBar,
IInteractionItem,
IAddInformation {
    private static final ImmutableMap<DyeColor, Block> GLASS_MAP;
    private static final ImmutableMap<DyeColor, Block> GLASS_PANE_MAP;
    private static final ImmutableMap<DyeColor, Block> TERRACOTTA_MAP;
    private static final ImmutableMap<DyeColor, Block> WOOL_MAP;
    private static final ImmutableMap<DyeColor, Block> CARPET_MAP;
    private static final ImmutableMap<DyeColor, Block> CONCRETE_MAP;
    private static final ImmutableMap<DyeColor, Block> CONCRETE_POWDER_MAP;
    private static final ImmutableMap<DyeColor, Block> SHULKER_BOX_MAP;
    private static final ImmutableMap<DyeColor, Block> CANDLE_MAP;
    private final Supplier<ItemStack> empty;
    private final DyeColor color;
    public final int totalUses;
    private final IntIntPair durabilityBarColors;
    private static final TriPredicate<IPaintable, IPaintable, Direction> paintablePredicate;
    private static final TriPredicate<IPipeNode, IPipeNode, Direction> gtPipePredicate;

    private static Block getBlock(DyeColor color, String postfix) {
        ResourceLocation id = new ResourceLocation("minecraft", color.m_7912_() + "_" + postfix);
        return (Block)BuiltInRegistries.f_256975_.m_7745_(id);
    }

    public ColorSprayBehaviour(Supplier<ItemStack> empty, int totalUses, int color) {
        this.empty = empty;
        DyeColor[] colors = DyeColor.values();
        this.color = color >= colors.length || color < 0 ? null : colors[color];
        int colorValue = this.color == null ? 0x969696 : this.color.m_41071_();
        this.totalUses = totalUses;
        this.durabilityBarColors = GradientUtil.getGradient(colorValue, 10);
    }

    @Override
    public float getDurabilityForDisplay(ItemStack stack) {
        return (float)this.getUsesLeft(stack) / (float)this.totalUses;
    }

    @Override
    public int getMaxDurability(ItemStack stack) {
        return this.totalUses;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        float f = Math.max(0.0f, this.getDurabilityForDisplay(stack));
        return ColorSprayBehaviour.mixColors(f, this.durabilityBarColors.leftInt(), this.durabilityBarColors.rightInt());
    }

    @Override
    @Nullable
    public IntIntPair getDurabilityColorsForDisplay(ItemStack itemStack) {
        return this.durabilityBarColors;
    }

    private static int mixColors(float ratio, int ... colors) {
        int r = 0;
        int g = 0;
        int b = 0;
        ratio *= 1.0f / (float)colors.length;
        for (int color : colors) {
            r = (int)((float)r + (float)FastColor.ARGB32.m_13665_((int)color) * ratio);
            g = (int)((float)g + (float)FastColor.ARGB32.m_13667_((int)color) * ratio);
            b = (int)((float)b + (float)FastColor.ARGB32.m_13669_((int)color) * ratio);
        }
        return FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        int remainingUses = this.getUsesLeft(stack);
        if (this.color != null) {
            tooltipComponents.add((Component)Component.m_237115_((String)("behaviour.paintspray." + this.color.m_7912_() + ".tooltip")));
        } else {
            tooltipComponents.add((Component)Component.m_237115_((String)"behaviour.paintspray.solvent.tooltip"));
        }
        tooltipComponents.add((Component)Component.m_237110_((String)"behaviour.paintspray.uses", (Object[])new Object[]{remainingUses}));
    }

    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        Player player = context.m_43723_();
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (player == null) {
            return InteractionResult.PASS;
        }
        int maxBlocksToRecolor = player.m_6144_() ? ConfigHolder.INSTANCE.tools.sprayCanChainLength : 1;
        BlockEntity first = level.m_7702_(pos);
        if (first == null || !this.handleSpecialBlockEntities(first, maxBlocksToRecolor, context)) {
            this.handleBlocks(pos, maxBlocksToRecolor, context);
        }
        GTSoundEntries.SPRAY_CAN_TOOL.play(level, null, player.m_20182_(), 1.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    private static boolean paintPaintable(IPaintable paintable, DyeColor color) {
        if (color == null) {
            if (!paintable.isPainted()) {
                return false;
            }
            paintable.setPaintingColor(-1);
        } else if (paintable.getPaintingColor() != color.m_284406_().f_283871_) {
            paintable.setPaintingColor(color.m_284406_().f_283871_);
        } else {
            return false;
        }
        return true;
    }

    private boolean handleSpecialBlockEntities(BlockEntity first, int limit, UseOnContext context) {
        Player player = context.m_43723_();
        if (player == null) {
            return false;
        }
        if (GTCEu.Mods.isAE2Loaded() && AE2CallWrapper.isAE2Cable(first)) {
            Set<CableBusBlockEntity> collected = AE2CallWrapper.collect(first, limit);
            AEColor ae2Color = this.color == null ? AEColor.TRANSPARENT : AEColor.values()[this.color.ordinal()];
            for (CableBusBlockEntity c : collected) {
                if (c.getColor() == ae2Color) continue;
                c.recolourBlock(context.m_43719_(), ae2Color, player);
                if (this.useItemDurability(player, context.m_43724_(), context.m_43722_(), ItemStack.f_41583_)) continue;
                break;
            }
        } else if (first instanceof IPipeNode) {
            IPipeNode pipe = (IPipeNode)first;
            Set<IPipeNode> collected = BreadthFirstBlockSearch.conditionalSearch(IPipeNode.class, pipe, first.m_58904_(), IPipeNode::getPipePos, gtPipePredicate, limit, limit * 6);
            this.paintPaintables(collected, context);
        } else if (first instanceof IPaintable) {
            IPaintable paintable = (IPaintable)first;
            Set<IPaintable> collected = BreadthFirstBlockSearch.conditionalSearch(IPaintable.class, paintable, first.m_58904_(), p -> ((BlockEntity)p).m_58899_(), paintablePredicate, limit, limit * 6);
            this.paintPaintables(collected, context);
        } else if (first instanceof ShulkerBoxBlockEntity) {
            ShulkerBoxBlockEntity shulkerBox = (ShulkerBoxBlockEntity)first;
            CompoundTag tag = shulkerBox.m_187482_();
            Level level = first.m_58904_();
            BlockPos pos = first.m_58899_();
            ColorSprayBehaviour.recolorBlockNoState(SHULKER_BOX_MAP, this.color, level, pos, Blocks.f_50456_);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof ShulkerBoxBlockEntity) {
                ShulkerBoxBlockEntity newShulker = (ShulkerBoxBlockEntity)blockEntity;
                newShulker.m_142466_(tag);
            }
        } else {
            return false;
        }
        return true;
    }

    private void handleBlocks(BlockPos start, int limit, UseOnContext context) {
        Level level = context.m_43725_();
        Player player = context.m_43723_();
        if (player == null) {
            return;
        }
        ItemStack stack = context.m_43722_();
        Set<BlockPos> collected = BreadthFirstBlockSearch.conditionalBlockPosSearch(start, (parent, child) -> parent == null || level.m_8055_(child).m_60713_(level.m_8055_(parent).m_60734_()), limit, limit * 6);
        for (BlockPos pos : collected) {
            if (!this.tryPaintBlock(level, pos) || !this.useItemDurability(player, context.m_43724_(), stack, this.empty.get())) break;
        }
    }

    private <T extends IPaintable> void paintPaintables(Set<T> paintables, UseOnContext context) {
        IPaintable c;
        Iterator<T> iterator = paintables.iterator();
        while (iterator.hasNext() && (!ColorSprayBehaviour.paintPaintable(c = (IPaintable)iterator.next(), this.color) || this.useItemDurability(context.m_43723_(), context.m_43724_(), context.m_43722_(), ItemStack.f_41583_))) {
        }
    }

    private boolean tryPaintBlock(Level level, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        Block block = blockState.m_60734_();
        if (this.color == null) {
            return ColorSprayBehaviour.tryStripBlockColor(level, pos, block);
        }
        return ColorSprayBehaviour.recolorBlockState(level, pos, this.color) || this.tryPaintSpecialBlock(level, pos, block);
    }

    private static boolean recolorBlockState(Level level, BlockPos pos, DyeColor color) {
        BlockState state = level.m_8055_(pos);
        for (Property property : state.m_61147_()) {
            if (property.m_61709_() != DyeColor.class) continue;
            level.m_46597_(pos, (BlockState)state.m_61124_(property, (Comparable)color));
            return true;
        }
        return false;
    }

    private boolean tryPaintSpecialBlock(Level world, BlockPos pos, Block block) {
        if (block.m_49966_().m_204336_(Tags.Blocks.GLASS) && ColorSprayBehaviour.recolorBlockNoState(GLASS_MAP, this.color, world, pos, Blocks.f_50058_)) {
            return true;
        }
        if (block.m_49966_().m_204336_(Tags.Blocks.GLASS_PANES) && ColorSprayBehaviour.recolorBlockNoState(GLASS_PANE_MAP, this.color, world, pos, Blocks.f_50185_)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_198156_) && ColorSprayBehaviour.recolorBlockNoState(TERRACOTTA_MAP, this.color, world, pos, Blocks.f_50352_)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13089_) && ColorSprayBehaviour.recolorBlockNoState(WOOL_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_215838_) && ColorSprayBehaviour.recolorBlockNoState(CARPET_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_MAP, this.color, world, pos)) {
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_POWDER_BLOCK) && ColorSprayBehaviour.recolorBlockNoState(CONCRETE_POWDER_MAP, this.color, world, pos)) {
            return true;
        }
        return block.m_49966_().m_204336_(BlockTags.f_144265_) && ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, this.color, world, pos);
    }

    private static boolean recolorBlockNoState(Map<DyeColor, Block> map, DyeColor color, Level world, BlockPos pos) {
        return ColorSprayBehaviour.recolorBlockNoState(map, color, world, pos, null);
    }

    private static boolean recolorBlockNoState(Map<DyeColor, Block> map, @Nullable DyeColor color, Level level, BlockPos pos, Block defaultBlock) {
        Block newBlock = map.getOrDefault(color, defaultBlock);
        if (newBlock == Blocks.f_50016_) {
            newBlock = defaultBlock;
        }
        BlockState old = level.m_8055_(pos);
        if (newBlock != null && newBlock != old.m_60734_()) {
            BlockState state = newBlock.m_49966_();
            for (Property property : old.m_61147_()) {
                if (!state.m_61138_(property)) continue;
                state.m_61124_(property, old.m_61143_(property));
            }
            level.m_46597_(pos, state);
            return true;
        }
        return false;
    }

    private static boolean tryStripBlockColor(Level world, BlockPos pos, Block block) {
        if (block instanceof StainedGlassBlock) {
            world.m_46597_(pos, Blocks.f_50058_.m_49966_());
            return true;
        }
        if (block instanceof StainedGlassPaneBlock) {
            world.m_46597_(pos, Blocks.f_50185_.m_49966_());
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_198156_) && block != Blocks.f_50352_) {
            world.m_46597_(pos, Blocks.f_50352_.m_49966_());
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_13089_) && block != Blocks.f_50041_) {
            world.m_46597_(pos, Blocks.f_50041_.m_49966_());
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_215838_) && block != Blocks.f_50336_) {
            world.m_46597_(pos, Blocks.f_50336_.m_49966_());
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_BLOCK) && block != Blocks.f_50542_) {
            world.m_46597_(pos, Blocks.f_50542_.m_49966_());
            return true;
        }
        if (block.m_49966_().m_204336_(CustomTags.CONCRETE_POWDER_BLOCK) && block != Blocks.f_50506_) {
            world.m_46597_(pos, Blocks.f_50506_.m_49966_());
            return true;
        }
        if (block.m_49966_().m_204336_(BlockTags.f_144265_) && block != Blocks.f_152483_) {
            ColorSprayBehaviour.recolorBlockNoState(CANDLE_MAP, DyeColor.WHITE, world, pos);
            return true;
        }
        BlockState state = world.m_8055_(pos);
        for (Property prop : state.m_61147_()) {
            if (prop.m_61709_() != DyeColor.class) continue;
            BlockState defaultState = block.m_49966_();
            DyeColor defaultColor = DyeColor.WHITE;
            try {
                defaultColor = (DyeColor)defaultState.m_61143_(prop);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ColorSprayBehaviour.recolorBlockState(world, pos, defaultColor);
            return true;
        }
        return false;
    }

    public boolean useItemDurability(Player player, InteractionHand hand, ItemStack stack, ItemStack replacementStack) {
        int usesLeft = this.getUsesLeft(stack);
        if (!player.m_7500_()) {
            if (--usesLeft <= 0) {
                if (replacementStack.m_41619_()) {
                    stack.m_41774_(1);
                } else {
                    player.m_21008_(hand, replacementStack);
                }
                return false;
            }
            ColorSprayBehaviour.setUsesLeft(stack, usesLeft);
        }
        return true;
    }

    public final int getUsesLeft(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound == null || !tagCompound.m_128425_("UsesLeft", 3)) {
            return this.totalUses;
        }
        return tagCompound.m_128451_("UsesLeft");
    }

    public static void setUsesLeft(ItemStack itemStack, int usesLeft) {
        CompoundTag tagCompound = itemStack.m_41784_();
        tagCompound.m_128405_("UsesLeft", usesLeft);
    }

    static {
        ImmutableMap.Builder glassBuilder = ImmutableMap.builder();
        ImmutableMap.Builder glassPaneBuilder = ImmutableMap.builder();
        ImmutableMap.Builder terracottaBuilder = ImmutableMap.builder();
        ImmutableMap.Builder woolBuilder = ImmutableMap.builder();
        ImmutableMap.Builder carpetBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concreteBuilder = ImmutableMap.builder();
        ImmutableMap.Builder concretePowderBuilder = ImmutableMap.builder();
        ImmutableMap.Builder shulkerBoxBuilder = ImmutableMap.builder();
        ImmutableMap.Builder candleBuilder = ImmutableMap.builder();
        for (DyeColor color : DyeColor.values()) {
            glassBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "stained_glass"));
            glassPaneBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "stained_glass_pane"));
            terracottaBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "terracotta"));
            woolBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "wool"));
            carpetBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "carpet"));
            concreteBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "concrete"));
            concretePowderBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "concrete_powder"));
            shulkerBoxBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "shulker_box"));
            candleBuilder.put((Object)color, (Object)ColorSprayBehaviour.getBlock(color, "candle"));
        }
        GLASS_MAP = glassBuilder.build();
        GLASS_PANE_MAP = glassPaneBuilder.build();
        TERRACOTTA_MAP = terracottaBuilder.build();
        WOOL_MAP = woolBuilder.build();
        CARPET_MAP = carpetBuilder.build();
        CONCRETE_MAP = concreteBuilder.build();
        CONCRETE_POWDER_MAP = concretePowderBuilder.build();
        SHULKER_BOX_MAP = shulkerBoxBuilder.build();
        CANDLE_MAP = candleBuilder.build();
        paintablePredicate = (parent, child, dir) -> {
            if (parent == null) {
                return true;
            }
            if (!parent.getClass().equals(child.getClass())) {
                return false;
            }
            return parent.getPaintingColor() == child.getPaintingColor();
        };
        gtPipePredicate = (parent, child, direction) -> {
            if (parent == null) {
                return true;
            }
            if (!paintablePredicate.test(parent, child, direction)) {
                return false;
            }
            return parent.isConnected((Direction)direction) && child.isConnected(direction.m_122424_());
        };
    }

    private static class AE2CallWrapper {
        private AE2CallWrapper() {
        }

        static Set<CableBusBlockEntity> collect(BlockEntity first, int limit) {
            return BreadthFirstBlockSearch.conditionalBlockEntitySearch(CableBusBlockEntity.class, (CableBusBlockEntity)first, AE2CallWrapper::ae2CablePredicate, limit, limit * 6);
        }

        static boolean isAE2Cable(BlockEntity be) {
            return be instanceof CableBusBlockEntity;
        }

        static boolean ae2CablePredicate(CableBusBlockEntity parent, CableBusBlockEntity child, Direction direction) {
            if (parent == null) {
                return true;
            }
            Direction childDirection = direction.m_122424_();
            return parent.getPart(direction) == null && parent.getCableConnectionType(direction).isValid() && child.getPart(childDirection) == null && child.getCableConnectionType(childDirection).isValid() && parent.getColor() == child.getColor();
        }
    }
}

