/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.item;

import com.gregtechceu.gtceu.api.blockentity.MetaMachineBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.item.component.IAddInformation;
import com.gregtechceu.gtceu.api.item.component.IDataItem;
import com.gregtechceu.gtceu.api.item.component.IInteractionItem;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IDataStickInteractable;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.common.machine.owner.MachineOwner;
import com.gregtechceu.gtceu.utils.GTStringUtils;
import com.gregtechceu.gtceu.utils.ResearchManager;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class DataItemBehavior
implements IInteractionItem,
IAddInformation,
IDataItem {
    private final boolean requireDataBank;
    private final int capacity;

    public DataItemBehavior(boolean requireDataBank, int capacity) {
        this.requireDataBank = requireDataBank;
        this.capacity = capacity;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Item item, Level level, Player player, InteractionHand usedHand) {
        if (player.m_6144_()) {
            ItemStack stack = player.m_21120_(usedHand);
            stack.m_41784_().m_128359_("boundPlayerName", Component.Serializer.m_130703_((Component)player.m_5446_()));
            int perm = 0;
            while (player.m_20310_(perm)) {
                ++perm;
            }
            stack.m_41784_().m_128405_("boundPlayerPermLevel", perm - 1);
            stack.m_41784_().m_128359_("boundPlayerUUID", player.m_20149_());
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return IInteractionItem.super.use(item, level, player, usedHand);
    }

    @Override
    public boolean requireDataBank() {
        return this.requireDataBank;
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        ResearchManager.ResearchItem researchData;
        if (stack.m_41784_().m_128441_("boundPlayerName")) {
            MutableComponent name = Component.Serializer.m_130701_((String)stack.m_41784_().m_128461_("boundPlayerName"));
            tooltipComponents.add((Component)Component.m_237110_((String)"gtceu.tooltip.player_bind", (Object[])new Object[]{name}));
        }
        if (stack.m_41784_().m_128441_("targetX")) {
            tooltipComponents.add((Component)Component.m_237110_((String)"gtceu.tooltip.wireless_transmitter_bind", (Object[])new Object[]{Component.m_237113_((String)("" + stack.m_41784_().m_128451_("targetX"))).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)("" + stack.m_41784_().m_128451_("targetY"))).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)("" + stack.m_41784_().m_128451_("targetZ"))).m_130940_(ChatFormatting.GOLD), Component.m_237113_((String)stack.m_41784_().m_128461_("face")).m_130940_(ChatFormatting.DARK_PURPLE), Component.m_237113_((String)stack.m_41784_().m_128461_("dim")).m_130940_(ChatFormatting.GREEN)}));
        }
        if (stack.m_41784_().m_128441_("computer_monitor_cover_config")) {
            tooltipComponents.add((Component)Component.m_237115_((String)"gtceu.tooltip.computer_monitor_config"));
        }
        if (stack.m_41784_().m_128441_("computer_monitor_cover_data")) {
            tooltipComponents.add((Component)Component.m_237110_((String)"gtceu.tooltip.computer_monitor_data", (Object[])new Object[]{GTStringUtils.toComponent(stack.m_41784_().m_128437_("computer_monitor_cover_data", 8))}));
        }
        if ((researchData = ResearchManager.readResearchId(stack)) == null) {
            if (stack.m_41784_().m_128425_("pos", 11) && stack.m_41782_()) {
                int[] posArray = stack.m_41784_().m_128465_("pos");
                tooltipComponents.add((Component)Component.m_237110_((String)"gtceu.tooltip.proxy_bind", (Object[])new Object[]{Component.m_237113_((String)("" + posArray[0])).m_130940_(ChatFormatting.LIGHT_PURPLE), Component.m_237113_((String)("" + posArray[1])).m_130940_(ChatFormatting.LIGHT_PURPLE), Component.m_237113_((String)("" + posArray[2])).m_130940_(ChatFormatting.LIGHT_PURPLE)}));
            }
        } else {
            Collection<GTRecipe> recipes = researchData.recipeType().getDataStickEntry(researchData.researchId());
            if (recipes != null && !recipes.isEmpty()) {
                List<Content> contents;
                tooltipComponents.add((Component)Component.m_237110_((String)"behavior.data_item.title", (Object[])new Object[]{Component.m_237115_((String)researchData.recipeType().registryName.m_214298_())}));
                ObjectOpenHashSet addedItems = new ObjectOpenHashSet();
                ObjectOpenHashSet addedFluids = new ObjectOpenHashSet();
                block0: for (GTRecipe recipe : recipes) {
                    contents = recipe.getOutputContents(ItemRecipeCapability.CAP);
                    if (contents.isEmpty()) continue;
                    ItemStack outputItems = ((Ingredient)ItemRecipeCapability.CAP.of(contents.get((int)0).content)).m_43908_()[0];
                    for (ItemStack item : addedItems) {
                        if (!outputItems.m_150930_(item.m_41720_())) continue;
                        continue block0;
                    }
                    if (!addedItems.add(outputItems)) continue;
                    tooltipComponents.add((Component)Component.m_237110_((String)"behavior.data_item.data", (Object[])new Object[]{outputItems.m_41611_()}));
                }
                block2: for (GTRecipe recipe : recipes) {
                    contents = recipe.getOutputContents(FluidRecipeCapability.CAP);
                    if (contents.isEmpty()) continue;
                    FluidStack outputFluids = ((FluidIngredient)FluidRecipeCapability.CAP.of(contents.get((int)0).content)).getStacks()[0];
                    for (FluidStack fluid : addedFluids) {
                        if (!outputFluids.isFluidStackIdentical(fluid)) continue;
                        continue block2;
                    }
                    if (!addedFluids.add(outputFluids)) continue;
                    tooltipComponents.add((Component)Component.m_237110_((String)"behavior.data_item.data", (Object[])new Object[]{outputFluids.getDisplayName()}));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        CoverBehavior coverBehavior;
        ICoverable coverable = GTCapabilityHelper.getCoverable(context.m_43725_(), context.m_8083_(), context.m_43719_());
        if (coverable != null && (coverBehavior = coverable.getCoverAtSide(context.m_43719_())) instanceof IDataStickInteractable) {
            IDataStickInteractable interactable = (IDataStickInteractable)((Object)coverBehavior);
            if (!context.m_7078_()) return interactable.onDataStickUse(context.m_43723_(), itemStack);
            if (ResearchManager.readResearchId(itemStack) == null) {
                return interactable.onDataStickShiftUse(context.m_43723_(), itemStack);
            }
        }
        if (!((coverBehavior = context.m_43725_().m_7702_(context.m_8083_())) instanceof MetaMachineBlockEntity)) return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        MetaMachineBlockEntity blockEntity = (MetaMachineBlockEntity)((Object)coverBehavior);
        MetaMachine machine = blockEntity.getMetaMachine();
        if (!MachineOwner.canOpenOwnerMachine(context.m_43723_(), machine)) {
            return InteractionResult.FAIL;
        }
        if (!(machine instanceof IDataStickInteractable)) return InteractionResult.PASS;
        IDataStickInteractable interactable = (IDataStickInteractable)((Object)machine);
        if (!context.m_7078_()) return interactable.onDataStickUse(context.m_43723_(), itemStack);
        if (ResearchManager.readResearchId(itemStack) != null) return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        return interactable.onDataStickShiftUse(context.m_43723_(), itemStack);
    }

    @Override
    @Generated
    public int getCapacity() {
        return this.capacity;
    }
}

